/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.TupleStreamIterator;
import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.common.params.SolrParams;

public class SolrStreamIterator
extends TupleStreamIterator {
    private static final Logger log = Logger.getLogger(SolrStreamIterator.class);
    protected SolrClient solrServer;
    protected SolrQuery solrQuery;
    protected String shardUrl;

    public SolrStreamIterator(String shardUrl, SolrClient solrServer, SolrQuery solrQuery) {
        super((SolrParams)solrQuery);
        this.shardUrl = shardUrl;
        this.solrServer = solrServer;
        this.solrQuery = this.mergeFq(solrQuery);
        if (solrQuery.getRequestHandler() == null) {
            solrQuery = solrQuery.setRequestHandler("/export");
        }
        solrQuery.setRows(null);
    }

    @Override
    protected TupleStream openStream() {
        SolrStream stream;
        try {
            stream = new SolrStream(this.shardUrl, (SolrParams)this.solrQuery);
            stream.open();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        return stream;
    }

    @Override
    protected void afterStreamClosed() throws Exception {
        if (!(this.solrServer instanceof CloudSolrClient)) {
            IOUtils.closeQuietly((Closeable)this.solrServer);
        }
    }

    protected SolrQuery mergeFq(SolrQuery solrQuery) {
        String[] values = solrQuery.getFilterQueries();
        if (values != null && values.length > 1) {
            String fqResult = "";
            for (int i = 0; i < values.length; ++i) {
                fqResult = i != values.length - 1 ? fqResult + "(" + values[i] + ")" + " AND " : fqResult + "(" + values[i] + ")";
            }
            log.info((Object)("Merged multiple FQ params in to a single param. Result: '" + fqResult + "'"));
            solrQuery.set("fq", new String[]{fqResult});
        }
        return solrQuery;
    }
}

