/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.solr.common.util.NamedList;
import org.apache.spark.mllib.feature.HashingTF;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;

public class SolrTermVector
extends SparseVector
implements Vector,
Serializable {
    private static final Analyzer stdAnalyzer = new StandardAnalyzer();
    protected String docId;
    protected String[] terms;

    public static SolrTermVector newInstance(String docId, HashingTF hashingTF, NamedList<Object> termList) {
        int termCount = termList.size();
        int[] indices = new int[termCount];
        double[] weights = new double[termCount];
        String[] terms = new String[termCount];
        Iterator termsIter = termList.iterator();
        int idx = -1;
        while (termsIter.hasNext()) {
            String term;
            Object w;
            Map.Entry termEntry = (Map.Entry)termsIter.next();
            double weight = 0.0;
            Object termVal = termEntry.getValue();
            if (termVal instanceof NamedList && (w = ((NamedList)termVal).get("tf-idf")) != null) {
                weight = w instanceof Number ? ((Number)w).doubleValue() : Double.parseDouble(w.toString());
            }
            terms[++idx] = term = (String)termEntry.getKey();
            indices[idx] = hashingTF.indexOf((Object)term);
            weights[idx] = weight;
        }
        return new SolrTermVector(docId, terms, hashingTF.numFeatures(), indices, weights);
    }

    public static SolrTermVector newInstance(String docId, HashingTF hashingTF, String rawText) {
        return SolrTermVector.newInstance(docId, hashingTF, stdAnalyzer, new StringReader(rawText));
    }

    public static SolrTermVector newInstance(String docId, HashingTF hashingTF, Analyzer analyzer, Reader rawTextReader) {
        ArrayList<String> termList = new ArrayList<String>();
        TokenStream ts = null;
        try {
            ts = analyzer.tokenStream(null, rawTextReader);
            ts.reset();
            while (ts.incrementToken()) {
                termList.add(((CharTermAttribute)ts.getAttribute(CharTermAttribute.class)).toString());
            }
            ts.end();
        }
        catch (IOException ioExc) {
            throw new RuntimeException(ioExc);
        }
        finally {
            if (ts != null) {
                try {
                    ts.close();
                }
                catch (IOException iOException) {}
            }
        }
        int termCount = termList.size();
        int[] indices = new int[termCount];
        double[] weights = new double[termCount];
        String[] terms = new String[termCount];
        for (int t = 0; t < termList.size(); ++t) {
            String term;
            terms[t] = term = (String)termList.get(t);
            indices[t] = hashingTF.indexOf((Object)term);
            weights[t] = 1.0;
        }
        return new SolrTermVector(docId, terms, hashingTF.numFeatures(), indices, weights);
    }

    protected SolrTermVector(String docId, String[] terms, int size, int[] indices, double[] weights) {
        super(size, indices, weights);
        this.docId = docId;
        this.terms = terms;
    }

    public String getDocumentId() {
        return this.docId;
    }

    public String toString() {
        return this.docId + ": " + super.toString();
    }
}

