/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.TupleStreamIterator;
import com.lucidworks.spark.util.SolrSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class StreamingExpressionResultIterator
extends TupleStreamIterator {
    private static final Logger log = Logger.getLogger(StreamingExpressionResultIterator.class);
    protected String zkHost;
    protected String collection;
    protected Set<String> promoteToDoubleFields = Collections.EMPTY_SET;
    private final Random random = new Random(5150L);

    public StreamingExpressionResultIterator(String zkHost, String collection, SolrParams solrParams) {
        super(solrParams);
        String promoteToDoubleFieldList;
        this.zkHost = zkHost;
        this.collection = collection;
        if ("/sql".equals(solrParams.get("qt")) && (promoteToDoubleFieldList = solrParams.get("promote_to_double")) != null) {
            this.promoteToDoubleFields = new HashSet<String>();
            this.promoteToDoubleFields.addAll(Arrays.asList(promoteToDoubleFieldList.split(",")));
        }
    }

    @Override
    protected TupleStream openStream() {
        SolrStream stream;
        String qt = this.solrParams.get("qt");
        if (qt == null) {
            qt = "/stream";
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("qt", new String[]{qt});
        String aggregationMode = this.solrParams.get("aggregationMode");
        log.info((Object)("aggregationMode=" + aggregationMode + ", solrParams: " + this.solrParams));
        if (aggregationMode != null) {
            params.set("aggregationMode", new String[]{aggregationMode});
        } else {
            params.set("aggregationMode", new String[]{"facet"});
        }
        if ("/sql".equals(qt)) {
            String sql = this.solrParams.get("sql").replaceAll("\\s+", " ");
            log.info((Object)("Executing SQL statement " + sql + " against collection " + this.collection));
            params.set("stmt", new String[]{sql});
        } else {
            String expr = this.solrParams.get("expr").replaceAll("\\s+", " ");
            log.info((Object)("Executing streaming expression " + expr + " against collection " + this.collection));
            params.set("expr", new String[]{expr});
        }
        try {
            String url = new ZkCoreNodeProps((ZkNodeProps)this.getRandomReplica()).getCoreUrl();
            log.info((Object)("Sending " + qt + " request to replica " + url + " of " + this.collection + " with params: " + params));
            long startMs = System.currentTimeMillis();
            stream = new SolrStream(url, (SolrParams)params);
            stream.open();
            long diffMs = System.currentTimeMillis() - startMs;
            log.info((Object)("Open stream to " + url + " took " + diffMs + " (ms)"));
        }
        catch (Exception e) {
            log.error((Object)("Failed to execute request [" + this.solrParams + "] due to: " + e), (Throwable)e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return stream;
    }

    @Override
    protected SolrDocument tuple2doc(Tuple tuple) {
        SolrDocument doc = new SolrDocument();
        for (Object key : tuple.fields.keySet()) {
            String keyStr = (String)key;
            Object value = tuple.get(key);
            if (this.promoteToDoubleFields.contains(keyStr) && value instanceof Number) {
                doc.setField(keyStr, (Object)((Number)value).doubleValue());
                continue;
            }
            doc.setField(keyStr, value);
        }
        return doc;
    }

    protected Replica getRandomReplica() {
        CloudSolrClient cloudSolrClient = SolrSupport.getCachedCloudClient(this.zkHost);
        ZkStateReader zkStateReader = cloudSolrClient.getZkStateReader();
        Collection slices = zkStateReader.getClusterState().getCollection(this.collection).getActiveSlices();
        if (slices == null || slices.size() == 0) {
            throw new IllegalStateException("No active shards found " + this.collection);
        }
        ArrayList shuffler = new ArrayList();
        for (Slice slice : slices) {
            shuffler.addAll(slice.getReplicas());
        }
        return (Replica)shuffler.get(this.random.nextInt(shuffler.size()));
    }
}

