/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.ResultsIterator;
import com.lucidworks.spark.util.SolrQuerySupport;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import scala.Option;

public class StreamingResultsIterator
extends ResultsIterator {
    private static Logger log = Logger.getLogger(StreamingResultsIterator.class);
    protected SolrClient solrServer;
    protected SolrQuery solrQuery;
    protected int currentPageSize = 0;
    protected int iterPos = 0;
    protected long totalDocs = -1L;
    protected long numDocs = 0L;
    protected boolean usingCursors = false;
    protected String nextCursorMark = null;
    protected String cursorMarkOfCurrentPage = null;
    protected boolean closeAfterIterating = false;
    protected LinkedBlockingDeque<SolrDocument> queue;
    protected Integer maxSampleDocs = null;
    protected String solrId = null;
    private ResponseCallback responseCallback = new ResponseCallback();
    private CountDownLatch docListInfoLatch = new CountDownLatch(1);

    public StreamingResultsIterator(SolrClient solrServer, SolrQuery solrQuery) {
        this(solrServer, solrQuery, null);
    }

    public StreamingResultsIterator(SolrClient solrServer, SolrQuery solrQuery, String cursorMark) {
        this.queue = new LinkedBlockingDeque();
        this.solrServer = solrServer;
        if (solrServer instanceof HttpSolrClient) {
            HttpSolrClient httpSolrClient = (HttpSolrClient)solrServer;
            this.solrId = httpSolrClient.getBaseURL();
        } else {
            this.solrId = solrServer.toString();
        }
        this.closeAfterIterating = !(solrServer instanceof CloudSolrClient);
        this.solrQuery = solrQuery;
        this.usingCursors = cursorMark != null;
        this.nextCursorMark = cursorMark;
        this.cursorMarkOfCurrentPage = cursorMark;
        if (solrQuery.getRows() == null) {
            solrQuery.setRows(Integer.valueOf(50));
        }
    }

    @Override
    public boolean hasNext() {
        if (this.totalDocs == 0L || this.totalDocs != -1L && this.numDocs >= this.totalDocs || this.maxSampleDocs != null && this.maxSampleDocs >= 0 && this.numDocs >= (long)this.maxSampleDocs.intValue()) {
            return false;
        }
        boolean hasNext = false;
        if (this.totalDocs == -1L || this.iterPos == this.currentPageSize) {
            try {
                hasNext = this.fetchNextPage();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        } else {
            boolean bl = hasNext = this.totalDocs > 0L && this.iterPos < this.currentPageSize;
        }
        if (!hasNext && this.closeAfterIterating) {
            try {
                this.solrServer.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        return hasNext;
    }

    protected int getStartForNextPage() {
        Integer currentStart = this.solrQuery.getStart();
        return currentStart != null ? currentStart + this.solrQuery.getRows() : 0;
    }

    protected boolean fetchNextPage() throws SolrServerException, InterruptedException {
        int start = this.usingCursors ? 0 : this.getStartForNextPage();
        this.currentPageSize = this.solrQuery.getRows();
        this.cursorMarkOfCurrentPage = this.nextCursorMark;
        Option<QueryResponse> resp = SolrQuerySupport.querySolr(this.solrServer, this.solrQuery, start, this.cursorMarkOfCurrentPage, this.responseCallback);
        if (resp.isDefined()) {
            if (this.usingCursors) {
                this.nextCursorMark = ((QueryResponse)resp.get()).getNextCursorMark();
            }
            this.iterPos = 0;
            if (this.usingCursors) {
                if (this.nextCursorMark != null) {
                    this.docListInfoLatch.await();
                    return this.totalDocs > 0L;
                }
                return false;
            }
            this.docListInfoLatch.await();
            return this.totalDocs > 0L;
        }
        throw new SolrServerException("No response from " + this.solrId + " found for query '" + this.solrQuery + "'");
    }

    @Override
    public SolrDocument next() {
        if (this.iterPos >= this.currentPageSize) {
            throw new NoSuchElementException("No more docs available from " + this.solrId + "! Please call hasNext before calling next!");
        }
        SolrDocument next = null;
        try {
            next = this.queue.poll(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
        if (next == null) {
            throw new RuntimeException("No SolrDocument in queue (waited 60 seconds) while processing cursorMark=" + this.cursorMarkOfCurrentPage + ", read " + this.numDocs + " of " + this.totalDocs + " so far from " + this.solrId + ". Most likely this means your query's sort criteria is not generating stable results for computing deep-paging cursors, has the index changed? " + "If so, try using a filter criteria the bounds the results to non-changing data.");
        }
        ++this.numDocs;
        ++this.iterPos;
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    @Override
    public Iterator<SolrDocument> iterator() {
        return this;
    }

    @Override
    public long getNumDocs() {
        return this.numDocs;
    }

    private class ResponseCallback
    extends StreamingResponseCallback {
        private ResponseCallback() {
        }

        public void streamSolrDocument(SolrDocument doc) {
            if (doc != null) {
                StreamingResultsIterator.this.queue.offer(doc);
            } else {
                log.warn((Object)("Received null SolrDocument from " + StreamingResultsIterator.this.solrId + " callback while processing cursorMark=" + StreamingResultsIterator.this.cursorMarkOfCurrentPage + ", read " + StreamingResultsIterator.this.numDocs + " of " + StreamingResultsIterator.this.totalDocs + " so far."));
            }
        }

        public void streamDocListInfo(long numFound, long start, Float maxScore) {
            StreamingResultsIterator.this.docListInfoLatch.countDown();
            StreamingResultsIterator.this.totalDocs = numFound;
            if (StreamingResultsIterator.this.maxSampleDocs == null) {
                if (numFound > 0L) {
                    String samplePctParam = StreamingResultsIterator.this.solrQuery.get("sample_pct");
                    if (samplePctParam != null) {
                        float pct = Float.parseFloat(samplePctParam);
                        StreamingResultsIterator.this.maxSampleDocs = Math.round((float)numFound * pct);
                        log.info((Object)("Sampling " + StreamingResultsIterator.this.maxSampleDocs + " (" + pct + " of " + numFound + ") from " + StreamingResultsIterator.this.solrId));
                    } else {
                        StreamingResultsIterator.this.maxSampleDocs = -1;
                    }
                } else {
                    StreamingResultsIterator.this.maxSampleDocs = -1;
                }
            }
            if ((long)StreamingResultsIterator.this.currentPageSize > StreamingResultsIterator.this.totalDocs) {
                StreamingResultsIterator.this.currentPageSize = (int)StreamingResultsIterator.this.totalDocs;
            }
        }
    }
}

