/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.AbstractFieldShardSplitStrategy;
import com.lucidworks.spark.query.AbstractShardSplit;
import com.lucidworks.spark.query.ShardSplit;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.FieldStatsInfo;

public class StringFieldShardSplitStrategy
extends AbstractFieldShardSplitStrategy<String>
implements Serializable {
    public static Logger log = Logger.getLogger(StringFieldShardSplitStrategy.class);
    public static final char[] alpha = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    @Override
    protected ShardSplit<String> createShardSplit(SolrQuery query, String shardUrl, String rangeField, FieldStatsInfo stats, String lowerInc, String upper) {
        String min = (String)stats.getMin();
        String max = (String)stats.getMax();
        if (lowerInc == null) {
            lowerInc = min;
        }
        if (upper == null) {
            upper = max;
        }
        return new StringShardSplit(query, shardUrl, rangeField, min, max, lowerInc, upper);
    }

    static {
        Arrays.sort(alpha);
    }

    class StringShardSplit
    extends AbstractShardSplit<String> {
        StringShardSplit(SolrQuery query, String shardUrl, String rangeField, String min, String max, String lowerInc, String upper) {
            super(query, shardUrl, rangeField, min, max, lowerInc, upper);
        }

        @Override
        public String nextUpper(String lower, long increment) {
            long lowerIndex = this.getIndex(lower);
            String nextUpper = this.getKeyAt(lowerIndex + increment);
            return nextUpper.compareTo((String)this.upper) < 0 ? nextUpper : (String)this.upper;
        }

        @Override
        public long getRange() {
            long upperIndex = this.getIndex((String)this.upper);
            long lowerIndex = this.getIndex((String)this.lowerInc);
            return upperIndex - lowerIndex;
        }

        protected String getKeyAt(long at) {
            if (at < (long)alpha.length) {
                throw new IllegalArgumentException("Requested key index must be greater than the length of the alphabet!");
            }
            long rem = at % (long)alpha.length;
            int i = (int)((at - rem) / (long)alpha.length);
            if (i > alpha.length) {
                throw new IllegalArgumentException("Key index (" + at + ") is out of range! max key is: " + alpha.length * alpha.length);
            }
            return Character.toString(alpha[i - 1]) + alpha[(int)rem];
        }

        protected long getIndex(String str) {
            long at = 0L;
            for (int i = 0; i < alpha.length; ++i) {
                if (alpha[i] != str.charAt(0)) continue;
                for (int j = 0; j < alpha.length; ++j) {
                    if (alpha[j] != str.charAt(1)) continue;
                    at = (i + 1) * alpha.length + j;
                    return at;
                }
            }
            return at;
        }
    }
}

