/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.PagedResultsIterator;
import com.lucidworks.spark.query.SolrTermVector;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.util.NamedList;
import org.apache.spark.mllib.feature.HashingTF;
import org.apache.spark.mllib.linalg.Vector;

public class TermVectorIterator
extends PagedResultsIterator<Vector> {
    private String field = null;
    private HashingTF hashingTF = null;

    public TermVectorIterator(SolrClient solrServer, SolrQuery solrQuery, String cursorMark, String field, int numFeatures) {
        super(solrServer, solrQuery, cursorMark);
        this.field = field;
        this.hashingTF = new HashingTF(numFeatures);
    }

    @Override
    protected List<Vector> processQueryResponse(QueryResponse resp) {
        NamedList response = resp.getResponse();
        NamedList termVectorsNL = (NamedList)response.get("termVectors");
        if (termVectorsNL == null) {
            throw new RuntimeException("No termVectors in response! Please check your query to make sure it is requesting term vector information from Solr correctly.");
        }
        ArrayList<Vector> termVectors = new ArrayList<Vector>(termVectorsNL.size());
        for (Map.Entry next : termVectorsNL) {
            NamedList nextList;
            Object fieldTerms;
            String nextKey = (String)next.getKey();
            Object nextValue = next.getValue();
            if (!(nextValue instanceof NamedList) || (fieldTerms = (nextList = (NamedList)nextValue).get(this.field)) == null || !(fieldTerms instanceof NamedList)) continue;
            termVectors.add(SolrTermVector.newInstance(nextKey, this.hashingTF, (NamedList<Object>)((NamedList)fieldTerms)));
        }
        SolrDocumentList docs = resp.getResults();
        this.totalDocs = docs.getNumFound();
        return termVectors;
    }
}

