/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query;

import com.lucidworks.spark.query.ResultsIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;

public abstract class TupleStreamIterator
extends ResultsIterator {
    private static final Logger log = Logger.getLogger(TupleStreamIterator.class);
    protected TupleStream stream;
    protected long numDocs = 0L;
    protected SolrParams solrParams;
    private Tuple currentTuple = null;
    private long openedAt;
    private boolean isClosed = false;

    public TupleStreamIterator(SolrParams solrParams) {
        this.solrParams = solrParams;
    }

    @Override
    public synchronized boolean hasNext() {
        if (this.isClosed) {
            return false;
        }
        if (this.stream == null) {
            this.stream = this.openStream();
            this.openedAt = System.currentTimeMillis();
        }
        try {
            if (this.currentTuple == null) {
                this.currentTuple = this.fetchNextTuple();
            }
        }
        catch (IOException e) {
            log.error((Object)("Failed to fetch next Tuple for query: " + this.solrParams.toQueryString()), (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this.currentTuple == null) {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close the SolrStream.", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                this.isClosed = true;
            }
            long diffMs = System.currentTimeMillis() - this.openedAt;
            log.info((Object)("Took " + diffMs + " (ms) to read " + this.numDocs + " from stream."));
            try {
                this.afterStreamClosed();
            }
            catch (Exception exc) {
                log.warn((Object)exc);
            }
        }
        return this.currentTuple != null;
    }

    protected void afterStreamClosed() throws Exception {
    }

    protected Tuple fetchNextTuple() throws IOException {
        Tuple tuple = this.stream.read();
        if (tuple.EOF) {
            return null;
        }
        return tuple;
    }

    protected abstract TupleStream openStream();

    public synchronized Tuple nextTuple() {
        if (this.isClosed) {
            throw new NoSuchElementException("already closed");
        }
        if (this.currentTuple == null) {
            throw new NoSuchElementException();
        }
        Tuple tempCurrentTuple = this.currentTuple;
        this.currentTuple = null;
        ++this.numDocs;
        return tempCurrentTuple;
    }

    @Override
    public synchronized SolrDocument next() {
        return this.tuple2doc(this.nextTuple());
    }

    protected SolrDocument tuple2doc(Tuple tuple) {
        SolrDocument doc = new SolrDocument();
        for (Object key : tuple.fields.keySet()) {
            doc.setField((String)key, tuple.get(key));
        }
        return doc;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    @Override
    public Iterator<SolrDocument> iterator() {
        return this;
    }

    @Override
    public long getNumDocs() {
        return this.numDocs;
    }
}

