/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.query.sql;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SolrSQLSupport {
    private static final String SELECT = "select ";
    private static final String FROM = " from";
    private static final String AS = "as ";
    private static final String DISTINCT = "distinct ";

    public static Map<String, String> parseColumns(String sqlStmt) throws Exception {
        String tmp = sqlStmt.replaceAll("\\s+", " ").trim();
        String lc = tmp.toLowerCase();
        if (!lc.startsWith(SELECT)) {
            throw new IllegalArgumentException("Expected SQL to start with 'select ' but found [" + sqlStmt + "] instead!");
        }
        int fromAt = lc.indexOf(FROM, SELECT.length());
        if (fromAt == -1) {
            throw new IllegalArgumentException("No FROM keyword found in SQL: " + sqlStmt);
        }
        String columnList = tmp.substring(SELECT.length(), fromAt).trim();
        if ("*".equals(columnList)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> columns = new HashMap<String, String>();
        for (String pair : columnList.split(",")) {
            String alias;
            String col;
            int spaceAt;
            if ((pair = pair.trim()).toLowerCase().startsWith(DISTINCT)) {
                pair = pair.substring(DISTINCT.length());
            }
            if ((spaceAt = pair.indexOf(" ")) != -1) {
                col = pair.substring(0, spaceAt);
                alias = pair.substring(spaceAt + 1);
                if (alias.toLowerCase().startsWith(AS)) {
                    alias = alias.substring(AS.length());
                }
            } else {
                col = pair;
                alias = pair;
            }
            columns.put(col.replace("`", "").replace("'", ""), alias.replace("`", "").replace("'", ""));
        }
        return columns;
    }
}

