/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.util;

import org.apache.spark.mllib.linalg.MatrixUDT;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;

public class SQLQuerySupport {
    public static DataType getsqlDataType(String s) {
        if (s.toLowerCase().equals("double")) {
            return DataTypes.DoubleType;
        }
        if (s.toLowerCase().equals("byte")) {
            return DataTypes.ByteType;
        }
        if (s.toLowerCase().equals("short")) {
            return DataTypes.ShortType;
        }
        if (s.toLowerCase().equals("int") || s.toLowerCase().equals("integer")) {
            return DataTypes.IntegerType;
        }
        if (s.toLowerCase().equals("long")) {
            return DataTypes.LongType;
        }
        if (s.toLowerCase().equals("String")) {
            return DataTypes.StringType;
        }
        if (s.toLowerCase().equals("boolean")) {
            return DataTypes.BooleanType;
        }
        if (s.toLowerCase().equals("timestamp")) {
            return DataTypes.TimestampType;
        }
        if (s.toLowerCase().equals("date")) {
            return DataTypes.DateType;
        }
        if (s.toLowerCase().equals("vector")) {
            return new VectorUDT();
        }
        if (s.toLowerCase().equals("matrix")) {
            return new MatrixUDT();
        }
        if (s.contains(":") && s.split(":")[0].toLowerCase().equals("array")) {
            return SQLQuerySupport.getArrayTypeRecurse(s, 0);
        }
        return DataTypes.StringType;
    }

    public static DataType getArrayTypeRecurse(String s, int fromIdx) {
        if (s.contains(":") && s.split(":")[1].toLowerCase().equals("array")) {
            fromIdx = s.indexOf(":", fromIdx);
            s = s.substring(fromIdx + 1, s.length());
            return DataTypes.createArrayType((DataType)SQLQuerySupport.getArrayTypeRecurse(s, fromIdx));
        }
        return DataTypes.createArrayType((DataType)SQLQuerySupport.getsqlDataType(s.split(":")[1]));
    }
}

