/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.spark.mllib.linalg.Matrices;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Option;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.WrappedArray;

public class ScalaUtil
implements Serializable {
    public static Logger log = Logger.getLogger(ScalaUtil.class);

    public static String optionalParam(Map<String, String> config, String param, String defaultValue) {
        Option opt = config.get((Object)param);
        String val = opt != null && !opt.isEmpty() ? (String)opt.get() : null;
        return val == null || val.trim().isEmpty() ? defaultValue : val;
    }

    public static String requiredParam(Map<String, String> config, String param) {
        String val = ScalaUtil.optionalParam(config, param, null);
        if (val == null) {
            throw new IllegalArgumentException(param + " parameter is required!");
        }
        return val;
    }

    public static Object getArrayToString(DataType dataType, Object value) {
        if (dataType.typeName().equals("array")) {
            Object[] d;
            WrappedArray ab;
            ArrayType a = (ArrayType)dataType;
            DataType e = a.elementType();
            int arraysize = 0;
            Object[] ab1 = new Object[arraysize];
            if (value instanceof WrappedArray) {
                ab = (WrappedArray)value;
                arraysize = ab.size();
                ab1 = new Object[ab.size()];
                ab.deep().copyToArray((Object)ab1);
            }
            if (value instanceof ArrayBuffer) {
                ab = (ArrayBuffer)value;
                arraysize = ab.size();
                ab1 = ab.array();
            }
            if (arraysize > 0) {
                d = new Object[arraysize];
                for (int i = 0; i < ab1.length; ++i) {
                    d[i] = e.typeName().equals("array") ? ScalaUtil.getArrayToString(e, ab1[i]) : ab1[i];
                }
            } else {
                d = new String[]{};
            }
            return Arrays.toString(d);
        }
        return "";
    }

    public static String getArraySchema(DataType dType) {
        if (((ArrayType)dType).elementType().typeName().equals("array")) {
            return dType.typeName() + ":" + ScalaUtil.getArraySchema(((ArrayType)dType).elementType());
        }
        return dType.typeName() + ":" + ((ArrayType)dType).elementType().typeName();
    }

    public static String getFieldTypeMapping(StructType s, String fieldName) {
        for (StructField f : s) {
            String fieldType;
            if (f.name().equals(fieldName) && !f.dataType().typeName().toString().toLowerCase().equals("struct")) {
                if (f.dataType().typeName().toLowerCase().equals("array")) {
                    if (((ArrayType)f.dataType()).elementType().typeName().toLowerCase().equals("array")) {
                        return f.dataType().typeName() + ":" + ScalaUtil.getFieldTypeMapping((ArrayType)((ArrayType)f.dataType()).elementType(), fieldName);
                    }
                    return f.dataType().typeName() + ":" + ((ArrayType)f.dataType()).elementType().typeName();
                }
                return f.dataType().typeName();
            }
            if (!f.dataType().typeName().toString().toLowerCase().equals("struct") || (fieldType = ScalaUtil.getFieldTypeMapping((StructType)f.dataType(), fieldName)).equals("")) continue;
            return fieldType;
        }
        return "";
    }

    public static String getFieldTypeMapping(ArrayType d, String fieldName) {
        if (d.elementType().typeName().toLowerCase().equals("array")) {
            ScalaUtil.getFieldTypeMapping((ArrayType)d.elementType(), fieldName);
        }
        return d.typeName() + ":" + d.elementType().typeName();
    }

    public static Integer convertToInteger(String s) {
        return Integer.parseInt(s);
    }

    public static Double convertToDouble(String s) {
        return Double.parseDouble(s);
    }

    public static Float convertToFloat(String s) {
        return Float.valueOf(Float.parseFloat(s));
    }

    public static Short convertToShort(String s) {
        return Short.parseShort(s);
    }

    public static Long convertToLong(String s) {
        return Long.parseLong(s);
    }

    public static Decimal convertToDecimal(String s) {
        return Decimal.apply((String)s);
    }

    public static Boolean convertToBoolean(String s) {
        return Boolean.parseBoolean(s);
    }

    public static Timestamp convertToTimestamp(String s) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        Timestamp timestamp = null;
        try {
            timestamp = new Timestamp(dateFormat.parse(s).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return timestamp;
    }

    public static Date convertToDate(String s) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        Date date = null;
        try {
            date = dateFormat.parse(s);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static Vector convertToVector(String s) {
        return Vectors.parse((String)s);
    }

    public static Matrix convertToMatrix(String s) {
        String[] data = s.split(":");
        String dataArray = data[2];
        String[] items = dataArray.replaceFirst("\\[", "").substring(0, dataArray.replaceFirst("\\[", "").lastIndexOf("]")).split(",");
        double[] doubleArray = new double[items.length];
        for (int i = 0; i < items.length; ++i) {
            doubleArray[i] = Double.parseDouble(items[i]);
        }
        return Matrices.dense((int)Integer.parseInt(data[0]), (int)Integer.parseInt(data[1]), (double[])doubleArray);
    }

    public static Object[] getArrayFromString(String type, String s, int fromIdx, ArrayList<Object[]> ret) {
        if (type.contains(":") && type.split(":")[1].equals("array")) {
            fromIdx = type.indexOf(":", fromIdx);
            type = type.substring(fromIdx + 1, type.length());
            String[] items = s.replaceFirst("\\[", "").substring(0, s.replaceFirst("\\[", "").lastIndexOf("]")).split("\\],");
            ArrayList<Object[]> ret1 = new ArrayList<Object[]>();
            for (int i = 0; i < items.length; ++i) {
                if (i == items.length - 1) {
                    ret1.add(ScalaUtil.getArrayFromString(type, items[i], fromIdx, ret1));
                    continue;
                }
                ret1.add(ScalaUtil.getArrayFromString(type, items[i] + "]", fromIdx, ret1));
            }
            ret.add(ret1.toArray());
            return ret1.toArray();
        }
        Object[] items = s.replaceFirst("\\[", "").substring(0, s.replaceFirst("\\[", "").lastIndexOf("]")).split(",");
        if (type.split(":")[1].equals("integer")) {
            return ScalaUtil.convertToIntegerArray((String[])items);
        }
        if (type.split(":")[1].equals("double")) {
            return ScalaUtil.convertToDoubleArray((String[])items);
        }
        if (type.split(":")[1].equals("float")) {
            return ScalaUtil.convertToFloatArray((String[])items);
        }
        if (type.split(":")[1].equals("short")) {
            return ScalaUtil.convertToShortArray((String[])items);
        }
        if (type.split(":")[1].equals("long")) {
            return ScalaUtil.convertToLongArray((String[])items);
        }
        return items;
    }

    public static Integer[] convertToIntegerArray(String[] s) {
        Integer[] results = new Integer[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                results[i] = Integer.parseInt(s[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"Unable to convert String array to integer array");
            }
        }
        return results;
    }

    public static Double[] convertToDoubleArray(String[] s) {
        Double[] results = new Double[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                results[i] = Double.parseDouble(s[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"Unable to convert String array to double array");
            }
        }
        return results;
    }

    public static Float[] convertToFloatArray(String[] s) {
        Float[] results = new Float[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                results[i] = Float.valueOf(Float.parseFloat(s[i]));
                continue;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"Unable to convert String array to float array");
            }
        }
        return results;
    }

    public static Short[] convertToShortArray(String[] s) {
        Short[] results = new Short[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                results[i] = Short.parseShort(s[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"Unable to convert String array to short array");
            }
        }
        return results;
    }

    public static Long[] convertToLongArray(String[] s) {
        Long[] results = new Long[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                results[i] = Long.parseLong(s[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"Unable to convert string array to long array");
            }
        }
        return results;
    }

    public static Boolean[] convertToBooleanArray(String[] s) {
        Boolean[] results = new Boolean[s.length];
        for (int i = 0; i < s.length; ++i) {
            try {
                results[i] = Boolean.parseBoolean(s[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"Unable to convert string array to boolean array");
            }
        }
        return results;
    }
}

