/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.util;

import com.lucidworks.spark.util.JsonUtil$;
import com.lucidworks.spark.util.SolrSupport$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonInput;
import org.json4s.StreamInput;
import org.json4s.jackson.JsonMethods$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SolrJsonSupport$
implements LazyLogging {
    public static final SolrJsonSupport$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SolrJsonSupport$();
    }

    private Logger logger$lzycompute() {
        SolrJsonSupport$ solrJsonSupport$ = this;
        synchronized (solrJsonSupport$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonAST.JValue getJson(HttpClient httpClient, String getUrl, int attempts) {
        BoxedUnit boxedUnit;
        int triedAttempts = attempts;
        None$ json = None$.MODULE$;
        if (triedAttempts < 1) {
            boxedUnit = BoxedUnit.UNIT;
            return (JsonAST.JValue)json.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final JsonAST.JNothing$ apply() {
                    return org.json4s.package$.MODULE$.JNothing();
                }
            });
        }
        try {
            --triedAttempts;
            json = new Some((Object)this.getJson(httpClient, getUrl));
            boxedUnit = BoxedUnit.UNIT;
            return (JsonAST.JValue)json.getOrElse((Function0)new /* invalid duplicate definition of identical inner class */);
        }
        catch (Exception exception) {
            Object object;
            if (triedAttempts <= 0) throw exception;
            if (!SolrSupport$.MODULE$.shouldRetry(exception)) throw exception;
            try {
                Thread.sleep(2000L);
                object = BoxedUnit.UNIT;
            }
            catch (InterruptedException interruptedException) {
                object = BoxesRunTime.boxToBoolean((boolean)Thread.interrupted());
            }
            boxedUnit = this.getJson(httpClient, getUrl, triedAttempts);
        }
        return (JsonAST.JValue)json.getOrElse((Function0)new /* invalid duplicate definition of identical inner class */);
    }

    public JsonAST.JValue getJson(HttpClient httpClient, String getUrl) {
        BoxedUnit boxedUnit;
        String newGetUrl = getUrl;
        URL url = new URL(getUrl);
        String queryString = url.getQuery();
        if (queryString == null) {
            newGetUrl = new StringBuilder().append((Object)newGetUrl).append((Object)"?wt=json").toString();
        } else if (!queryString.contains("wt=json")) {
            newGetUrl = new StringBuilder().append((Object)newGetUrl).append((Object)"&wt=json").toString();
        }
        HttpGet httpGet = new HttpGet(newGetUrl);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"Requesting url: ").append((Object)getUrl).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.doJsonRequest(httpClient, newGetUrl, (HttpUriRequest)httpGet);
    }

    public JsonAST.JValue doJsonRequest(HttpClient httpClient, String url, HttpUriRequest request) {
        HttpResponse response = httpClient.execute(request);
        HttpEntity entity = response.getEntity();
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String body = this.getHttpResponseAsString(entity);
            throw new SolrException(SolrException.ErrorCode.getErrorCode((int)statusCode), new StringBuilder().append((Object)"Request [").append((Object)url).append((Object)"] failed due to: ").append((Object)response.getStatusLine()).append((Object)": ").append((Object)body).toString());
        }
        if (entity == null) {
            throw new Exception("No entity found in the response");
        }
        try {
            JsonAST.JValue jValue = JsonMethods$.MODULE$.parse((JsonInput)new StreamInput(entity.getContent()), JsonMethods$.MODULE$.parse$default$2());
            if (JsonUtil$.MODULE$.JValueExtended(jValue).has("responseHeader") && JsonUtil$.MODULE$.JValueExtended(org.json4s.package$.MODULE$.jvalue2monadic(jValue).$bslash("responseHeader")).has("status")) {
                JsonAST.JValue jStatus = org.json4s.package$.MODULE$.jvalue2monadic(org.json4s.package$.MODULE$.jvalue2monadic(jValue).$bslash("responseHeader")).$bslash("status");
                JsonAST.JValue jValue2 = jStatus;
                if (jValue2 instanceof JsonAST.JInt) {
                    JsonAST.JInt jInt = (JsonAST.JInt)jValue2;
                    BigInt bigInt = jInt.values();
                    BigInt bigInt2 = package$.MODULE$.BigInt().apply(-1);
                    if (!(bigInt != null ? !bigInt.equals(bigInt2) : bigInt2 != null)) {
                        throw new SolrServerException(new StringBuilder().append((Object)"Unable to determine outcome of the request to:").append((Object)url).append((Object)"! Response: ").append((Object)JsonMethods$.MODULE$.compact(jValue)).toString());
                    }
                    BigInt bigInt3 = jInt.values();
                    BigInt bigInt4 = package$.MODULE$.BigInt().apply(0);
                    if (!(bigInt3 != null ? !bigInt3.equals(bigInt4) : bigInt4 != null)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return jValue;
                    }
                    None$ errorMsg = None$.MODULE$;
                    if (JsonUtil$.MODULE$.JValueExtended(jValue).has("error") && JsonUtil$.MODULE$.JValueExtended(org.json4s.package$.MODULE$.jvalue2monadic(jValue).$bslash("error")).has("msg")) {
                        JsonAST.JValue x$1 = org.json4s.package$.MODULE$.jvalue2monadic(org.json4s.package$.MODULE$.jvalue2monadic(jValue).$bslash("error")).$bslash("msg");
                        Formats x$2 = JsonMethods$.MODULE$.render$default$2(x$1);
                        errorMsg = new Some((Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$1, x$2)));
                    } else {
                        JsonAST.JValue x$3 = jValue;
                        Formats x$4 = JsonMethods$.MODULE$.render$default$2(x$3);
                        errorMsg = new Some((Object)JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render(x$3, x$4)));
                    }
                    throw new SolrException(SolrException.ErrorCode.getErrorCode((int)statusCode), new StringBuilder().append((Object)"Request to ").append((Object)url).append((Object)" failed due to: ").append(errorMsg.get()).toString());
                }
                if (jValue2 != null) {
                    throw new Exception(new StringBuilder().append((Object)"unknown data type for 'status' in object ").append((Object)JsonMethods$.MODULE$.compact(org.json4s.package$.MODULE$.jvalue2monadic(jValue).$bslash("responseHeader"))).toString());
                }
                throw new MatchError((Object)jValue2);
            }
            throw new Exception(new StringBuilder().append((Object)"Could not find 'responseHeader' in json: ").append((Object)JsonMethods$.MODULE$.compact(jValue)).toString());
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)"Exception while parsing JSON stream for url '").append((Object)url).append((Object)"'. The payload is ").append((Object)this.getHttpResponseAsString(entity)).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw exception;
        }
        catch (RuntimeException runtimeException) {
            request.abort();
            throw runtimeException;
        }
    }

    public String getHttpResponseAsString(HttpEntity entity) {
        StringBuilder body = new StringBuilder();
        if (entity != null) {
            InputStream inStream = entity.getContent();
            String line = null;
            try {
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                    line = reader.readLine();
                    while (line != null) {
                        body.append(line);
                        line = reader.readLine();
                    }
                }
                catch (Exception exception) {
                }
            }
            finally {
                inStream.close();
            }
        }
        return body.result();
    }

    public HttpClient getHttpClient() {
        SolrSupport$.MODULE$.setupKerberosIfNeeded();
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("maxConnections", 128);
        params.set("maxConnectionsPerHost", 32);
        params.set("followRedirects", false);
        return HttpClientUtil.createClient((SolrParams)params);
    }

    private SolrJsonSupport$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

