/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.util;

import com.lucidworks.spark.query.NumberFieldShardSplitStrategy;
import com.lucidworks.spark.query.ShardSplit;
import com.lucidworks.spark.query.ShardSplitStrategy;
import com.lucidworks.spark.query.StringFieldShardSplitStrategy;
import com.lucidworks.spark.rdd.SolrRDD;
import com.lucidworks.spark.util.JsonUtil$;
import com.lucidworks.spark.util.PivotField;
import com.lucidworks.spark.util.QueryConstants$;
import com.lucidworks.spark.util.SolrFieldMeta;
import com.lucidworks.spark.util.SolrJsonSupport$;
import com.lucidworks.spark.util.SolrQuerySupport$;
import com.lucidworks.spark.util.SolrRelationUtil$;
import com.lucidworks.spark.util.SolrSupport$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.impl.StreamingBinaryResponseParser;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.control.Breaks$;

public final class SolrQuerySupport$
implements LazyLogging {
    public static final SolrQuerySupport$ MODULE$;
    private final scala.collection.immutable.Map<String, DataType> SOLR_DATA_TYPES;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SolrQuerySupport$();
    }

    private Logger logger$lzycompute() {
        SolrQuerySupport$ solrQuerySupport$ = this;
        synchronized (solrQuerySupport$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public scala.collection.immutable.Map<String, DataType> SOLR_DATA_TYPES() {
        return this.SOLR_DATA_TYPES;
    }

    public String getUniqueKey(String zkHost, String collection) {
        block9: {
            BoxedUnit boxedUnit;
            try {
                String solrBaseUrl = SolrSupport$.MODULE$.getSolrBaseUrl(zkHost);
                String schemaUrl = new StringBuilder().append((Object)solrBaseUrl).append((Object)collection).append((Object)"/schema").toString();
                try {
                    JsonAST.JValue schemaMeta = SolrJsonSupport$.MODULE$.getJson(SolrJsonSupport$.MODULE$.getHttpClient(), schemaUrl, 2);
                    if (JsonUtil$.MODULE$.JValueExtended(schemaMeta).has("schema") && JsonUtil$.MODULE$.JValueExtended(package$.MODULE$.jvalue2monadic(schemaMeta).$bslash("schema")).has("uniqueKey")) {
                        JsonAST.JValue jValue = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(schemaMeta).$bslash("schema")).$bslash("uniqueKey");
                        if (jValue instanceof JsonAST.JString) {
                            JsonAST.JString jString = (JsonAST.JString)jValue;
                            return jString.s();
                        }
                        if (jValue != null) {
                            JsonAST.JValue jValue2 = jValue;
                            throw new Exception(new StringBuilder().append((Object)"Unexpected type '").append(jValue2.getClass()).append((Object)"' other than JString for uniqueKey '").append((Object)jValue2).append((Object)"'").toString());
                        }
                        throw new MatchError((Object)jValue);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (SolrException solrException) {
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder().append((Object)"Can't get uniqueKey for ").append((Object)collection).append((Object)" due to solr: ").append((Object)solrException).toString());
                        boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            catch (Exception exception) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder().append((Object)"Can't get uniqueKey for ").append((Object)collection).append((Object)" due to: ").append((Object)exception).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
        return QueryConstants$.MODULE$.DEFAULT_REQUIRED_FIELD();
    }

    public SolrQuery toQuery(String queryString) {
        BoxedUnit boxedUnit;
        ObjectRef solrQuery = ObjectRef.create((Object)new SolrQuery());
        if (queryString == null || queryString.isEmpty()) {
            solrQuery.elem = ((SolrQuery)solrQuery.elem).setQuery("*:*");
            boxedUnit = BoxedUnit.UNIT;
        } else if (queryString.contains("=")) {
            NamedList params = new NamedList();
            JavaConversions$.MODULE$.asScalaBuffer(URLEncodedUtils.parse((String)queryString, (Charset)StandardCharsets.UTF_8)).foreach((Function1)new Serializable(solrQuery, params){
                public static final long serialVersionUID = 0L;
                private final ObjectRef solrQuery$1;
                private final NamedList params$1;

                public final Object apply(NameValuePair nvp) {
                    BoxedUnit boxedUnit;
                    String value = nvp.getValue();
                    if (value != null && value.length() > 0) {
                        String name = nvp.getName();
                        if ("sort".equals(name)) {
                            if (value.contains(" ")) {
                                String[] split = value.split(" ");
                                boxedUnit = ((SolrQuery)this.solrQuery$1.elem).addSort(SolrQuery.SortClause.create((String)split[0], (String)split[1]));
                            } else {
                                boxedUnit = ((SolrQuery)this.solrQuery$1.elem).addSort(SolrQuery.SortClause.asc((String)value));
                            }
                        } else {
                            this.params$1.add(name, (Object)value);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                {
                    this.solrQuery$1 = solrQuery$1;
                    this.params$1 = params$1;
                }
            });
            ((SolrQuery)solrQuery.elem).add(SolrParams.toSolrParams((NamedList)params));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = ((SolrQuery)solrQuery.elem).setQuery(queryString);
        }
        Integer rows = ((SolrQuery)solrQuery.elem).getRows();
        Object object = rows == null ? ((SolrQuery)solrQuery.elem).setRows(Predef$.MODULE$.int2Integer(QueryConstants$.MODULE$.DEFAULT_PAGE_SIZE())) : BoxedUnit.UNIT;
        return (SolrQuery)solrQuery.elem;
    }

    public void addDefaultSort(SolrQuery solrQuery, String uniqueKey) {
        if (solrQuery.getSortField() == null || solrQuery.getSortField().isEmpty()) {
            BoxedUnit boxedUnit;
            solrQuery.addSort(SolrQuery.SortClause.asc((String)uniqueKey));
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Added default sort clause on uniqueKey field ", " to query ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{uniqueKey, solrQuery})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public Option<QueryResponse> querySolr(SolrClient solrClient, SolrQuery solrQuery, int startIndex, String cursorMark) {
        return this.querySolr(solrClient, solrQuery, startIndex, cursorMark, null);
    }

    public QueryResponse queryAndStreamResponsePost(SolrParams params, StreamingResponseCallback callback, SolrClient cloudClient) {
        StreamingBinaryResponseParser parser = new StreamingBinaryResponseParser(callback);
        QueryRequest req = new QueryRequest(params, SolrRequest.METHOD.POST);
        req.setStreamingResponseCallback(callback);
        req.setResponseParser((ResponseParser)parser);
        return (QueryResponse)req.process(cloudClient);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Option<QueryResponse> querySolr(SolrClient solrClient, SolrQuery solrQuery, int startIndex, String cursorMark, StreamingResponseCallback callback) {
        None$ resp = None$.MODULE$;
        try {
            SolrQuery solrQuery2;
            if (cursorMark == null) {
                solrQuery2 = solrQuery.setStart(Predef$.MODULE$.int2Integer(startIndex));
            } else {
                solrQuery.setStart(Predef$.MODULE$.int2Integer(0));
                solrQuery2 = solrQuery.set("cursorMark", new String[]{cursorMark});
            }
            Object object = solrQuery.getRows() == null ? solrQuery.setRows(Predef$.MODULE$.int2Integer(QueryConstants$.MODULE$.DEFAULT_PAGE_SIZE())) : BoxedUnit.UNIT;
            if (callback != null) return new Some((Object)this.queryAndStreamResponsePost((SolrParams)solrQuery, callback, solrClient));
            return new Some((Object)solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST));
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)"Query [").append((Object)solrQuery).append((Object)"] failed due to: ").append((Object)exception).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (SolrSupport$.MODULE$.shouldRetry(exception)) {
                Object object;
                try {
                    Thread.sleep(2000L);
                    object = BoxedUnit.UNIT;
                }
                catch (InterruptedException interruptedException) {
                    object = BoxesRunTime.boxToBoolean((boolean)Thread.interrupted());
                }
            } else {
                Exception exception2 = exception;
                if (exception2 instanceof SolrServerException) {
                    SolrServerException solrServerException = (SolrServerException)((Object)exception2);
                    throw solrServerException;
                }
                if (exception2 == null) throw new MatchError((Object)exception2);
                Exception exception3 = exception2;
                throw new SolrServerException((Throwable)exception3);
            }
            try {
                if (callback != null) return new Some((Object)this.queryAndStreamResponsePost((SolrParams)solrQuery, callback, solrClient));
                return new Some((Object)solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST));
            }
            catch (Exception exception2) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Query on retry [").append((Object)solrQuery).append((Object)"] failed due to: ").append((Object)exception2).toString());
                    boxedUnit2 = BoxedUnit.UNIT;
                    throw new SolrServerException((Throwable)exception2);
                }
                boxedUnit2 = BoxedUnit.UNIT;
                throw new SolrServerException((Throwable)exception2);
            }
            catch (SolrServerException solrServerException) {
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Query on retry [").append((Object)solrQuery).append((Object)"] failed due to: ").append((Object)solrServerException).toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                    throw solrServerException;
                }
                boxedUnit3 = BoxedUnit.UNIT;
                throw solrServerException;
            }
        }
    }

    public void setQueryDefaultsForShards(SolrQuery solrQuery, String uniqueKey) {
        solrQuery.set("distrib", new String[]{"false"});
        solrQuery.setStart(Predef$.MODULE$.int2Integer(0));
        Object object = solrQuery.getRows() == null ? solrQuery.setRows(Predef$.MODULE$.int2Integer(QueryConstants$.MODULE$.DEFAULT_PAGE_SIZE())) : BoxedUnit.UNIT;
        this.addDefaultSort(solrQuery, uniqueKey);
    }

    public void setQueryDefaultsForTV(SolrQuery solrQuery, String field, String uniqueKey) {
        Object object = solrQuery.getRequestHandler() == null ? solrQuery.setRequestHandler("/tvrh") : BoxedUnit.UNIT;
        solrQuery.set("shards.qt", new String[]{solrQuery.getRequestHandler()});
        solrQuery.set("tv.fl", new String[]{field});
        solrQuery.set("fq", new String[]{new StringBuilder().append((Object)field).append((Object)":[* TO *]").toString()});
        solrQuery.set("tv.tf_idf", new String[]{"true"});
        solrQuery.set("distrib", false);
        solrQuery.setStart(Predef$.MODULE$.int2Integer(0));
        Object object2 = solrQuery.getRows() == null ? solrQuery.setRows(Predef$.MODULE$.int2Integer(QueryConstants$.MODULE$.DEFAULT_PAGE_SIZE())) : BoxedUnit.UNIT;
        this.addDefaultSort(solrQuery, uniqueKey);
    }

    public scala.collection.immutable.Map<String, SolrFieldMeta> getFieldTypes(Set<String> fields, String solrBaseUrl, String collection) {
        return this.getFieldTypes(fields, new StringBuilder().append((Object)solrBaseUrl).append((Object)collection).append((Object)"/").toString());
    }

    public scala.collection.immutable.Map<String, SolrFieldMeta> getFieldTypes(Set<String> fields, String solrUrl) {
        BoxedUnit boxedUnit;
        HashMap fieldTypeMap = new HashMap();
        scala.collection.immutable.Map<String, String> fieldTypeToClassMap = this.getFieldTypeToClassMap(solrUrl);
        Set<String> fieldNames = fields == null || fields.isEmpty() ? this.getFieldsFromLuke(solrUrl) : fields;
        scala.collection.immutable.Map<String, Object> fieldDefinitionsFromSchema = this.getFieldDefinitionsFromSchema(solrUrl, fieldNames);
        fieldDefinitionsFromSchema.foreach((Function1)new Serializable(fieldTypeMap, fieldTypeToClassMap){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldTypeMap$1;
            private final scala.collection.immutable.Map fieldTypeToClassMap$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object apply(Tuple2<String, Object> x0$1) {
                BoxedUnit boxedUnit;
                scala.collection.immutable.Map map;
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 == null) throw new MatchError(tuple2);
                Object payloadRef = tuple2._2();
                Object object = payloadRef;
                if (object instanceof scala.collection.immutable.Map && (map = (scala.collection.immutable.Map)object).keySet().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Object x$1) {
                        return x$1 instanceof String;
                    }
                })) {
                    Option option;
                    None$ dynamicBase;
                    None$ none$;
                    None$ isDocValues;
                    None$ none$2;
                    None$ isStored;
                    None$ none$3;
                    None$ isMultiValued;
                    None$ none$4;
                    None$ isRequired;
                    None$ none$5;
                    scala.collection.immutable.Map payload = map;
                    String name = (String)payload.get((Object)"name").get();
                    String fieldType = (String)payload.get((Object)"type").get();
                    if (payload.contains((Object)"required")) {
                        if (payload.get((Object)"required").isDefined()) {
                            Some some;
                            Object object2 = payload.get((Object)"required").get();
                            if (object2 instanceof Boolean) {
                                boolean bl = BoxesRunTime.unboxToBoolean((Object)object2);
                                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            } else {
                                if (!(object2 instanceof Object)) throw new MatchError(object2);
                                Object object3 = object2;
                                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)String.valueOf(object3).equals("true")));
                            }
                            none$5 = some;
                        } else {
                            none$5 = None$.MODULE$;
                        }
                    } else {
                        none$5 = isRequired = None$.MODULE$;
                    }
                    if (payload.contains((Object)"multiValued")) {
                        if (payload.get((Object)"multiValued").isDefined()) {
                            Some some;
                            Object object4 = payload.get((Object)"multiValued").get();
                            if (object4 instanceof Boolean) {
                                boolean bl = BoxesRunTime.unboxToBoolean((Object)object4);
                                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            } else {
                                if (!(object4 instanceof Object)) throw new MatchError(object4);
                                Object object5 = object4;
                                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)String.valueOf(object5).equals("true")));
                            }
                            none$4 = some;
                        } else {
                            none$4 = None$.MODULE$;
                        }
                    } else {
                        none$4 = isMultiValued = None$.MODULE$;
                    }
                    if (payload.contains((Object)"stored")) {
                        if (payload.get((Object)"stored").isDefined()) {
                            Some some;
                            Object object6 = payload.get((Object)"stored").get();
                            if (object6 instanceof Boolean) {
                                boolean bl = BoxesRunTime.unboxToBoolean((Object)object6);
                                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            } else {
                                if (!(object6 instanceof Object)) throw new MatchError(object6);
                                Object object7 = object6;
                                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)String.valueOf(object7).equals("true")));
                            }
                            none$3 = some;
                        } else {
                            none$3 = None$.MODULE$;
                        }
                    } else {
                        none$3 = isStored = None$.MODULE$;
                    }
                    if (payload.contains((Object)"docValues")) {
                        if (payload.get((Object)"docValues").isDefined()) {
                            Some some;
                            Object object8 = payload.get((Object)"docValues").get();
                            if (object8 instanceof Boolean) {
                                boolean bl = BoxesRunTime.unboxToBoolean((Object)object8);
                                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            } else {
                                if (!(object8 instanceof Object)) throw new MatchError(object8);
                                Object object9 = object8;
                                some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)String.valueOf(object9).equals("true")));
                            }
                            none$2 = some;
                        } else {
                            none$2 = None$.MODULE$;
                        }
                    } else {
                        none$2 = isDocValues = None$.MODULE$;
                    }
                    if (payload.contains((Object)"dynamicBase")) {
                        if (payload.get((Object)"dynamicBase").isDefined()) {
                            Object object10 = payload.get((Object)"dynamicBase").get();
                            if (!(object10 instanceof String)) throw new MatchError(object10);
                            String string = (String)object10;
                            Some some = new Some((Object)string);
                            none$ = some;
                        } else {
                            none$ = None$.MODULE$;
                        }
                    } else {
                        none$ = dynamicBase = None$.MODULE$;
                    }
                    None$ fieldClassType = this.fieldTypeToClassMap$1.contains((Object)fieldType) ? (this.fieldTypeToClassMap$1.get((Object)fieldType).isDefined() ? new Some(this.fieldTypeToClassMap$1.get((Object)fieldType).get()) : None$.MODULE$) : None$.MODULE$;
                    SolrFieldMeta solrFieldMeta = new SolrFieldMeta(fieldType, (Option<String>)dynamicBase, (Option<Object>)isRequired, (Option<Object>)isMultiValued, (Option<Object>)isDocValues, (Option<Object>)isStored, (Option<String>)fieldClassType);
                    if (solrFieldMeta.isStored().isDefined() && !BoxesRunTime.unboxToBoolean((Object)solrFieldMeta.isStored().get()) && solrFieldMeta.isDocValues().isDefined() && !BoxesRunTime.unboxToBoolean((Object)solrFieldMeta.isDocValues().get())) {
                        if (SolrQuerySupport$.MODULE$.logger().underlying().isDebugEnabled()) {
                            SolrQuerySupport$.MODULE$.logger().underlying().debug(new StringBuilder().append((Object)"Can't retrieve an index only field: '").append((Object)name).append((Object)"'. Field info ").append((Object)payload).toString());
                            option = BoxedUnit.UNIT;
                        } else {
                            option = BoxedUnit.UNIT;
                        }
                    } else if (solrFieldMeta.isStored().isDefined() && !BoxesRunTime.unboxToBoolean((Object)solrFieldMeta.isStored().get()) && solrFieldMeta.isMultiValued().isDefined() && BoxesRunTime.unboxToBoolean((Object)solrFieldMeta.isMultiValued().get()) && solrFieldMeta.isDocValues().isDefined() && BoxesRunTime.unboxToBoolean((Object)solrFieldMeta.isDocValues().get())) {
                        if (SolrQuerySupport$.MODULE$.logger().underlying().isDebugEnabled()) {
                            SolrQuerySupport$.MODULE$.logger().underlying().debug(new StringBuilder().append((Object)"Can't retrieve a non-stored multiValued docValues field: '").append((Object)name).append((Object)"'. The payload info is ").append((Object)payload).toString());
                            option = BoxedUnit.UNIT;
                        } else {
                            option = BoxedUnit.UNIT;
                        }
                    } else {
                        option = this.fieldTypeMap$1.put((Object)name, (Object)solrFieldMeta);
                    }
                    boxedUnit = option;
                    return boxedUnit;
                } else {
                    BoxedUnit boxedUnit2;
                    if (!(object instanceof Object)) throw new MatchError(object);
                    Object object11 = object;
                    if (SolrQuerySupport$.MODULE$.logger().underlying().isWarnEnabled()) {
                        SolrQuerySupport$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"Unknown class type '").append((Object)object11.getClass().toString()).append((Object)"'").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                }
                return boxedUnit;
            }
            {
                this.fieldTypeMap$1 = fieldTypeMap$1;
                this.fieldTypeToClassMap$1 = fieldTypeToClassMap$1;
            }
        });
        if (fieldTypeMap.isEmpty()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No readable fields found!");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return fieldTypeMap.toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, Object> getFieldDefinitionsFromSchema(String solrUrl, Set<String> fieldNames) {
        scala.collection.immutable.Map map;
        None$ none$;
        if (fieldNames.nonEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("&fl=");
            ((IterableLike)fieldNames.zipWithIndex(Set$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(fieldNames, sb){
                public static final long serialVersionUID = 0L;
                private final Set fieldNames$1;
                private final StringBuilder sb$1;

                public final Object apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        this.sb$1.append(name);
                        BoxedUnit boxedUnit = index < this.fieldNames$1.size() ? this.sb$1.append(",") : BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.fieldNames$1 = fieldNames$1;
                    this.sb$1 = sb$1;
                }
            });
            none$ = new Some((Object)sb.toString());
        } else {
            none$ = None$.MODULE$;
        }
        None$ fl = none$;
        String fieldsUrlBase = new StringBuilder().append((Object)solrUrl).append((Object)"schema/fields?showDefaults=true&includeDynamic=true").toString();
        String flList = (String)fl.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        if (flList.length() > 2048 - fieldsUrlBase.length()) {
            HashMap fieldDefs = HashMap$.MODULE$.empty();
            scala.collection.immutable.Map<String, Object> allFields = this.fetchFieldSchemaInfoFromSolr(fieldsUrlBase);
            fieldNames.foreach((Function1)new Serializable(fieldDefs, allFields){
                public static final long serialVersionUID = 0L;
                private final HashMap fieldDefs$1;
                private final scala.collection.immutable.Map allFields$1;

                public final Object apply(String fname) {
                    return JavaConversions$.MODULE$.mapAsJavaMap((Map)this.allFields$1).containsKey(fname) ? this.fieldDefs$1.put((Object)fname, this.allFields$1.get((Object)fname).get()) : BoxedUnit.UNIT;
                }
                {
                    this.fieldDefs$1 = fieldDefs$1;
                    this.allFields$1 = allFields$1;
                }
            });
            map = fieldDefs.toMap(Predef$.MODULE$.$conforms());
        } else {
            map = this.fetchFieldSchemaInfoFromSolr(new StringBuilder().append((Object)fieldsUrlBase).append((Object)flList).toString());
        }
        return map;
    }

    public scala.collection.immutable.Map<String, Object> fetchFieldSchemaInfoFromSolr(String fieldsUrl) {
        try {
            Object object;
            Object object2 = SolrJsonSupport$.MODULE$.getJson(SolrJsonSupport$.MODULE$.getHttpClient(), fieldsUrl, 2).values();
            if (object2 instanceof scala.collection.immutable.Map && ((MapLike)(object = object2)).keySet().forall((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Object x$2) {
                    return x$2 instanceof String;
                }
            })) {
                scala.collection.immutable.Map payload = (scala.collection.immutable.Map)object;
                if (payload.contains((Object)"fields")) {
                    if (payload.get((Object)"fields").isDefined()) {
                        Object object3 = payload.get((Object)"fields").get();
                        if (object3 instanceof List) {
                            scala.collection.immutable.Map<String, Object> map;
                            List list = (List)object3;
                            scala.collection.immutable.Map<String, Object> map2 = map = this.constructFieldInfoMap((List<Object>)list);
                            return map2;
                        }
                        throw new MatchError(object3);
                    }
                    throw new Exception(new StringBuilder().append((Object)"No fields payload inside the response: ").append((Object)payload).toString());
                }
                throw new Exception(new StringBuilder().append((Object)"No fields payload inside the response: ").append((Object)payload).toString());
            }
            if (object2 instanceof Object) {
                Object object4 = object2;
                throw new Exception(new StringBuilder().append((Object)"Unknown type '").append(object4.getClass()).append((Object)"' from schema object ").append(object4).toString());
            }
            throw new MatchError(object2);
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder().append((Object)"Can't get field metadata from Solr using request '").append((Object)fieldsUrl).append((Object)"' due to exception ").append((Object)exception).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Exception exception2 = exception;
            if (exception2 instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)exception2;
                throw runtimeException;
            }
            if (exception2 != null) {
                Exception exception3 = exception2;
                throw new RuntimeException(exception3);
            }
            throw new MatchError((Object)exception2);
        }
    }

    public scala.collection.immutable.Map<String, Object> constructFieldInfoMap(List<Object> fieldsInfoList) {
        HashMap fieldInfoMap = new HashMap();
        fieldsInfoList.foreach((Function1)new Serializable(fieldInfoMap){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldInfoMap$1;

            public final Object apply(Object x0$3) {
                scala.collection.immutable.Map map;
                Object object = x0$3;
                if (object instanceof scala.collection.immutable.Map && (map = (scala.collection.immutable.Map)object).keySet().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Object x$3) {
                        return x$3 instanceof String;
                    }
                })) {
                    BoxedUnit boxedUnit;
                    scala.collection.immutable.Map fieldInfo = map;
                    if (fieldInfo.contains((Object)"name")) {
                        Option fieldName = fieldInfo.get((Object)"name");
                        if (fieldName.isDefined()) {
                            boxedUnit = this.fieldInfoMap$1.put((Object)((String)fieldName.get()), (Object)fieldInfo);
                        } else if (SolrQuerySupport$.MODULE$.logger().underlying().isInfoEnabled()) {
                            SolrQuerySupport$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"value for key 'name' is not defined in the payload ").append((Object)fieldInfo).toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else if (SolrQuerySupport$.MODULE$.logger().underlying().isInfoEnabled()) {
                        SolrQuerySupport$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"'name' is not defined in the payload ").append((Object)fieldInfo).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                }
                if (object instanceof Object) {
                    Object object2 = object;
                    throw new Exception(new StringBuilder().append((Object)"Unknown type '").append(object2.getClass()).toString());
                }
                throw new MatchError(object);
            }
            {
                this.fieldInfoMap$1 = fieldInfoMap$1;
            }
        });
        return fieldInfoMap.toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getFieldsFromLuke(String solrUrl) {
        String lukeUrl = new StringBuilder().append((Object)solrUrl).append((Object)"admin/luke?numTerms=0").toString();
        try {
            void var4_3;
            JsonAST.JValue adminMeta = SolrJsonSupport$.MODULE$.getJson(SolrJsonSupport$.MODULE$.getHttpClient(), lukeUrl, 2);
            if (JsonUtil$.MODULE$.JValueExtended(adminMeta).has("fields")) {
                Object object;
                JsonAST.JValue fieldsRef = package$.MODULE$.jvalue2monadic(adminMeta).$bslash("fields");
                Object object2 = fieldsRef.values();
                if (object2 instanceof scala.collection.immutable.Map && ((MapLike)(object = object2)).keySet().forall((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Object x$4) {
                        return x$4 instanceof String;
                    }
                })) {
                    Set set = ((scala.collection.immutable.Map)object).keySet();
                    return set;
                }
                if (object2 instanceof Object) {
                    Object object3 = object2;
                    throw new Exception(new StringBuilder().append((Object)"Unknown type '").append(object3.getClass()).append((Object)"'").toString());
                }
                throw new MatchError(object2);
            }
            throw new Exception(new StringBuilder().append((Object)"Cannot find 'fields' payload inside Schema: ").append((Object)JsonMethods$.MODULE$.compact((JsonAST.JValue)var4_3)).toString());
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)"Can't get schema fields from url ").append((Object)lukeUrl).append((Object)" due to: ").append((Object)exception).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw exception;
        }
    }

    public void validateExportHandlerQuery(SolrClient solrServer, SolrQuery solrQuery) {
        SolrQuery cloneQuery = solrQuery.getCopy();
        cloneQuery = cloneQuery.setRows(Predef$.MODULE$.int2Integer(0));
        QueryRequest queryRequest = new QueryRequest((SolrParams)cloneQuery);
        queryRequest.setResponseParser((ResponseParser)new InputStreamResponseParser("json"));
        queryRequest.setMethod(SolrRequest.METHOD.POST);
        try {
            QueryResponse queryResponse = (QueryResponse)queryRequest.process(solrServer);
            if (queryResponse.getStatus() != 0) {
                throw new RuntimeException(new StringBuilder().append((Object)"Solr request returned with status code '").append((Object)BoxesRunTime.boxToInteger((int)queryResponse.getStatus())).append((Object)"'. Response: '").append((Object)queryResponse.getResponse().toString()).toString());
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                BoxedUnit boxedUnit;
                Throwable throwable3 = throwable2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Error while validating query request: ").append((Object)queryRequest.toString()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable3;
            }
            throw throwable;
        }
    }

    public long getNumDocsFromSolr(String collection, String zkHost, Option<SolrQuery> query) {
        SolrQuery solrQuery = query.isDefined() ? (SolrQuery)query.get() : new SolrQuery().setQuery("*:*");
        SolrQuery cloneQuery = solrQuery.getCopy();
        cloneQuery.set("distrib", new String[]{"true"});
        cloneQuery.setRows(Predef$.MODULE$.int2Integer(0));
        CloudSolrClient cloudClient = SolrSupport$.MODULE$.getCachedCloudClient(zkHost);
        QueryResponse response = cloudClient.query(collection, (SolrParams)solrQuery);
        return response.getResults().getNumFound();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<String, String> getFieldTypeToClassMap(String solrUrl) {
        HashMap fieldTypeToClassMap;
        block12: {
            fieldTypeToClassMap = new HashMap();
            String fieldTypeUrl = new StringBuilder().append((Object)solrUrl).append((Object)"schema/fieldtypes").toString();
            try {
                JsonAST.JValue fieldTypeMeta = SolrJsonSupport$.MODULE$.getJson(SolrJsonSupport$.MODULE$.getHttpClient(), fieldTypeUrl, 2);
                if (!JsonUtil$.MODULE$.JValueExtended(fieldTypeMeta).has("fieldTypes")) break block12;
                Object object = package$.MODULE$.jvalue2monadic(fieldTypeMeta).$bslash("fieldTypes").values();
                if (object instanceof List) {
                    BoxedUnit boxedUnit;
                    List list = (List)object;
                    if (list.nonEmpty()) {
                        list.foreach((Function1)new Serializable((scala.collection.mutable.Map)fieldTypeToClassMap){
                            public static final long serialVersionUID = 0L;
                            private final scala.collection.mutable.Map fieldTypeToClassMap$2;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object apply(Object x0$4) {
                                BoxedUnit boxedUnit;
                                Object object = x0$4;
                                if (!(object instanceof scala.collection.immutable.Map)) throw new MatchError(object);
                                scala.collection.immutable.Map map = (scala.collection.immutable.Map)object;
                                if (!map.keySet().forall((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(Object x$5) {
                                        return x$5 instanceof String;
                                    }
                                })) throw new MatchError(object);
                                scala.collection.immutable.Map fieldTypePayload = map;
                                if (fieldTypePayload.contains((Object)"name") && fieldTypePayload.contains((Object)"class")) {
                                    Option fieldTypeName = fieldTypePayload.get((Object)"name");
                                    Option fieldTypeClass = fieldTypePayload.get((Object)"class");
                                    if (fieldTypeName.isDefined() && fieldTypeClass.isDefined()) {
                                        Option option;
                                        Object object2 = fieldTypeName.get();
                                        if (!(object2 instanceof String)) throw new MatchError(object2);
                                        String string = (String)object2;
                                        Object object3 = fieldTypeClass.get();
                                        if (!(object3 instanceof String)) throw new MatchError(object3);
                                        String string2 = (String)object3;
                                        Option option2 = option = this.fieldTypeToClassMap$2.put((Object)string, (Object)string2);
                                        boxedUnit = option2;
                                        return boxedUnit;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    return boxedUnit;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                return boxedUnit;
                            }
                            {
                                this.fieldTypeToClassMap$2 = fieldTypeToClassMap$2;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    break block12;
                }
                if (object instanceof Object) {
                    BoxedUnit boxedUnit;
                    Object object2 = object;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder().append((Object)"Found unexpected object type '").append(object2).append((Object)"' when parsing field types json").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                    break block12;
                }
                throw new MatchError(object);
            }
            catch (Exception exception) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    void var3_3;
                    this.logger().underlying().error(new StringBuilder().append((Object)"Can't get field type metadata from Solr url ").append((Object)var3_3).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Exception exception2 = exception;
                if (exception2 instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)exception2;
                    throw runtimeException;
                }
                if (exception2 != null) {
                    Exception exception3 = exception2;
                    throw new RuntimeException(exception3);
                }
                throw new MatchError((Object)exception2);
            }
        }
        return fieldTypeToClassMap.toMap(Predef$.MODULE$.$conforms());
    }

    public RDD<ShardSplit<?>> splitShard(SparkContext sc, SolrQuery query, List<String> shards, String splitFieldName, int splitsPerShard, String collection) {
        block17: {
            ObjectRef fieldDataType;
            block16: {
                block15: {
                    fieldDataType = ObjectRef.create((Object)None$.MODULE$);
                    if (!"_version_".equals(splitFieldName)) break block15;
                    fieldDataType.elem = new Some((Object)DataTypes.LongType);
                    break block16;
                }
                scala.collection.immutable.Map<String, SolrFieldMeta> fieldMetaMap = this.getFieldTypes((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{splitFieldName}))), (String)JavaConversions$.MODULE$.seqAsJavaList(shards).get(0));
                if (!fieldMetaMap.contains((Object)splitFieldName)) break block17;
                if (fieldMetaMap.get((Object)splitFieldName).isDefined()) {
                    SolrFieldMeta solrFieldMeta = (SolrFieldMeta)fieldMetaMap.get((Object)splitFieldName).get();
                    if (solrFieldMeta.fieldTypeClass().isDefined()) {
                        if (this.SOLR_DATA_TYPES().contains(solrFieldMeta.fieldTypeClass().get())) {
                            fieldDataType.elem = new Some(this.SOLR_DATA_TYPES().get(solrFieldMeta.fieldTypeClass().get()).get());
                        } else {
                            BoxedUnit boxedUnit;
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn(new StringBuilder().append((Object)"Cannot find spark type for solr field class '").append(solrFieldMeta.fieldTypeClass().get()).append((Object)"'. ").append((Object)"Assuming it is a String!. The types dict is ").append(this.SOLR_DATA_TYPES()).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            fieldDataType.elem = new Some((Object)DataTypes.StringType);
                        }
                    } else {
                        BoxedUnit boxedUnit;
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn(new StringBuilder().append((Object)"No field type class found for ").append((Object)splitFieldName).append((Object)", assuming it is a String!").toString());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        fieldDataType.elem = new Some((Object)DataTypes.StringType);
                    }
                } else {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn(new StringBuilder().append((Object)"No field metadata found for ").append((Object)splitFieldName).append((Object)", assuming it is a String!").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    fieldDataType.elem = new Some((Object)DataTypes.StringType);
                }
            }
            return sc.parallelize(shards, shards.size(), ClassTag$.MODULE$.apply(String.class)).flatMap((Function1)new Serializable(query, splitFieldName, splitsPerShard, fieldDataType){
                public static final long serialVersionUID = 0L;
                private final SolrQuery query$1;
                private final String splitFieldName$1;
                private final int splitsPerShard$1;
                private final ObjectRef fieldDataType$1;

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final List<ShardSplit<?>> apply(String shardUrl) {
                    splitStrategy = None$.MODULE$;
                    if (((Option)this.fieldDataType$1.elem).isEmpty()) {
                        throw new Exception(new StringBuilder().append((Object)"data type for field '").append((Object)this.splitFieldName$1).append((Object)"' not defined").toString());
                    }
                    v0 = ((Option)this.fieldDataType$1.elem).get();
                    var3_3 = DataTypes.LongType;
                    if (!(v0 == null ? var3_3 != null : v0.equals(var3_3) == false)) ** GOTO lbl-1000
                    v1 = ((Option)this.fieldDataType$1.elem).get();
                    var4_4 = DataTypes.IntegerType;
                    if (!(v1 != null ? v1.equals(var4_4) == false : var4_4 != null)) lbl-1000:
                    // 2 sources

                    {
                        splitStrategy = new Some((Object)new NumberFieldShardSplitStrategy());
                        v2 /* !! */  = BoxedUnit.UNIT;
                    } else {
                        v3 = ((Option)this.fieldDataType$1.elem).get();
                        var5_5 = DataTypes.StringType;
                        if (!(v3 != null ? v3.equals(var5_5) == false : var5_5 != null)) {
                            v4 = splitStrategy;
                            var6_6 = new Some((Object)new StringFieldShardSplitStrategy());
                            v2 /* !! */  = BoxesRunTime.boxToBoolean((boolean)(!(v4 != null ? v4.equals(var6_6) == false : var6_6 != null)));
                        } else {
                            v2 /* !! */  = BoxedUnit.UNIT;
                        }
                    }
                    if (splitStrategy.isEmpty()) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"Can only split shards on fields of type: long, int, or string!. The field '").append((Object)this.splitFieldName$1).append((Object)"' has field type '").append((Object)((Option)this.fieldDataType$1.elem)).toString());
                    }
                    splits = ((ShardSplitStrategy)splitStrategy.get()).getSplits(shardUrl, this.query$1, this.splitFieldName$1, this.splitsPerShard$1);
                    if (SolrQuerySupport$.MODULE$.logger().underlying().isInfoEnabled()) {
                        SolrQuerySupport$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"Found ").append((Object)BoxesRunTime.boxToInteger((int)splits.size())).append((Object)" splits for ").append((Object)this.splitFieldName$1).append((Object)": ").append(splits).toString());
                        v5 = BoxedUnit.UNIT;
                    } else {
                        v5 = BoxedUnit.UNIT;
                    }
                    return JavaConversions$.MODULE$.asScalaBuffer(splits).toList();
                }
                {
                    this.query$1 = query$1;
                    this.splitFieldName$1 = splitFieldName$1;
                    this.splitsPerShard$1 = splitsPerShard$1;
                    this.fieldDataType$1 = fieldDataType$1;
                }
            }, ClassTag$.MODULE$.apply(ShardSplit.class));
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot find split field '").append((Object)splitFieldName).append((Object)"' in the solr field meta").toString());
    }

    public int[] getPivotFieldRange(StructType schema, String pivotPrefix) {
        StructField[] schemaFields = schema.fields();
        IntRef startAt = IntRef.create((int)-1);
        IntRef endAt = IntRef.create((int)-1);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])schemaFields).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(pivotPrefix, startAt, endAt){
            public static final long serialVersionUID = 0L;
            private final String pivotPrefix$1;
            private final IntRef startAt$1;
            private final IntRef endAt$1;

            public final Tuple2<Object, Object> apply(Tuple2<StructField, Object> x0$5) {
                Tuple2<StructField, Object> tuple2 = x0$5;
                if (tuple2 != null) {
                    StructField schemaField = (StructField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    String name = schemaField.name();
                    if (this.startAt$1.elem == -1 && name.startsWith(this.pivotPrefix$1)) {
                        this.startAt$1.elem = i;
                    }
                    if (this.startAt$1.elem != -1 && !name.startsWith(this.pivotPrefix$1)) {
                        this.endAt$1.elem = i - 1;
                        throw Breaks$.MODULE$.break();
                    }
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(this.startAt$1.elem, this.endAt$1.elem);
                    return sp2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.pivotPrefix$1 = pivotPrefix$1;
                this.startAt$1 = startAt$1;
                this.endAt$1 = endAt$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        return new int[]{startAt.elem, endAt.elem};
    }

    public void fillPivotFieldValues(String rawValue, Object[] row, StructType schema, String pivotPrefix) {
        int[] range = this.getPivotFieldRange(schema, pivotPrefix);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(range[0]), range[1]).foreach$mVc$sp((Function1)new Serializable(row){
            public static final long serialVersionUID = 0L;
            private final Object[] row$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.row$1[i] = BoxesRunTime.boxToInteger((int)0);
            }
            {
                this.row$1 = row$1;
            }
        });
        try {
            row[schema.fieldIndex((String)new StringBuilder().append((Object)pivotPrefix).append((Object)rawValue.toLowerCase()).toString())] = BoxesRunTime.boxToInteger((int)1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            row[range[1]] = BoxesRunTime.boxToInteger((int)1);
        }
    }

    public Dataset<Row> withPivotFields(Dataset<Row> solrData, PivotField[] pivotFields, SolrRDD solrRDD, boolean escapeFieldNames) {
        StructType schema = SolrRelationUtil$.MODULE$.getBaseSchema(solrRDD.zkHost(), solrRDD.collection(), escapeFieldNames, true);
        StructType schemaWithPivots = this.toPivotSchema(solrData.schema(), pivotFields, solrRDD.collection(), schema, solrRDD.uniqueKey(), solrRDD.zkHost());
        RDD withPivotFields = solrData.rdd().map((Function1)new Serializable(pivotFields, schemaWithPivots){
            public static final long serialVersionUID = 0L;
            private final PivotField[] pivotFields$1;
            public final StructType schemaWithPivots$1;

            public final Row apply(Row row) {
                Object[] fields = (Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.Any());
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), row.length() - 1).foreach$mVc$sp((Function1)new Serializable(this, fields, row){
                    public static final long serialVersionUID = 0L;
                    private final Object[] fields$1;
                    private final Row row$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.fields$1[i] = this.row$2.get(i);
                    }
                    {
                        this.fields$1 = fields$1;
                        this.row$2 = row$2;
                    }
                });
                Predef$.MODULE$.refArrayOps((Object[])this.pivotFields$1).foreach((Function1)new Serializable(this, fields, row){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;
                    private final Object[] fields$1;
                    private final Row row$2;

                    public final void apply(PivotField pf) {
                        SolrQuerySupport$.MODULE$.fillPivotFieldValues(this.row$2.getString(this.row$2.fieldIndex(pf.solrField())), this.fields$1, this.$outer.schemaWithPivots$1, pf.prefix());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.fields$1 = fields$1;
                        this.row$2 = row$2;
                    }
                });
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)fields));
            }
            {
                this.pivotFields$1 = pivotFields$1;
                this.schemaWithPivots$1 = schemaWithPivots$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        return solrData.sqlContext().createDataFrame(withPivotFields, schemaWithPivots);
    }

    public StructType toPivotSchema(StructType baseSchema, PivotField[] pivotFields, String collection, StructType schema, String uniqueKey, String zkHost) {
        ListBuffer pivotSchemaFields = new ListBuffer();
        JavaConversions$.MODULE$.bufferAsJavaList((Buffer)pivotSchemaFields).addAll(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])baseSchema.fields()).toList()));
        Predef$.MODULE$.refArrayOps((Object[])pivotFields).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(PivotField check$ifrefutable$1) {
                PivotField pivotField = check$ifrefutable$1;
                boolean bl = pivotField != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(collection, schema, uniqueKey, zkHost, pivotSchemaFields){
            public static final long serialVersionUID = 0L;
            private final String collection$1;
            private final StructType schema$1;
            private final String uniqueKey$1;
            private final String zkHost$1;
            private final ListBuffer pivotSchemaFields$1;

            public final boolean apply(PivotField pf) {
                List<StructField> structFields = SolrQuerySupport$.MODULE$.getPivotSchema(pf.solrField(), pf.maxCols(), pf.prefix(), pf.otherSuffix(), this.collection$1, this.schema$1, this.uniqueKey$1, this.zkHost$1);
                return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.pivotSchemaFields$1).addAll(JavaConversions$.MODULE$.seqAsJavaList(structFields));
            }
            {
                this.collection$1 = collection$1;
                this.schema$1 = schema$1;
                this.uniqueKey$1 = uniqueKey$1;
                this.zkHost$1 = zkHost$1;
                this.pivotSchemaFields$1 = pivotSchemaFields$1;
            }
        });
        return DataTypes.createStructType((java.util.List)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)pivotSchemaFields));
    }

    /*
     * WARNING - void declaration
     */
    public List<StructField> getPivotSchema(String fieldName, int maxCols, String fieldPrefix, String otherName, String collection, StructType schema, String uniqueKey, String zkHost) {
        void var10_10;
        ListBuffer listOfFields = new ListBuffer();
        SolrQuery solrQuery = new SolrQuery("*:*");
        solrQuery.set("collection", new String[]{collection});
        solrQuery.setFacet(true);
        solrQuery.addFacetField(new String[]{fieldName});
        solrQuery.setFacetMinCount(1);
        solrQuery.setFacetLimit(maxCols);
        solrQuery.setRows(Predef$.MODULE$.int2Integer(0));
        Option<QueryResponse> resp = this.querySolr((SolrClient)SolrSupport$.MODULE$.getCachedCloudClient(zkHost), solrQuery, 0, null);
        if (resp.isDefined()) {
            FacetField ff = ((QueryResponse)resp.get()).getFacetField(fieldName);
            JavaConversions$.MODULE$.asScalaBuffer(ff.getValues()).foreach((Function1)new Serializable(fieldPrefix, otherName, listOfFields){
                public static final long serialVersionUID = 0L;
                private final String fieldPrefix$1;
                private final String otherName$1;
                private final ListBuffer listOfFields$1;

                public final Object apply(FacetField.Count f) {
                    JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.listOfFields$1).add(DataTypes.createStructField((String)new StringBuilder().append((Object)this.fieldPrefix$1).append((Object)f.getName().toLowerCase()).toString(), (DataType)DataTypes.IntegerType, (boolean)false));
                    return this.otherName$1 == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.listOfFields$1).add(DataTypes.createStructField((String)new StringBuilder().append((Object)this.fieldPrefix$1).append((Object)this.otherName$1).toString(), (DataType)DataTypes.IntegerType, (boolean)false)));
                }
                {
                    this.fieldPrefix$1 = fieldPrefix$1;
                    this.otherName$1 = otherName$1;
                    this.listOfFields$1 = listOfFields$1;
                }
            });
            return listOfFields.toList();
        }
        throw new Exception(new StringBuilder().append((Object)"No response found for query '").append((Object)var10_10).toString());
    }

    private SolrQuerySupport$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.SOLR_DATA_TYPES = (scala.collection.immutable.Map)scala.collection.immutable.HashMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.StrField"), (Object)DataTypes.StringType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.TextField"), (Object)DataTypes.StringType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.BoolField"), (Object)DataTypes.BooleanType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.TrieIntField"), (Object)DataTypes.LongType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.TrieLongField"), (Object)DataTypes.LongType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.TrieFloatField"), (Object)DataTypes.DoubleType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.TrieDoubleField"), (Object)DataTypes.DoubleType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.TrieDateField"), (Object)DataTypes.TimestampType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"solr.BinaryField"), (Object)DataTypes.BinaryType)}));
    }
}

