/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.util;

import com.lucidworks.spark.util.SolrFieldMeta;
import com.lucidworks.spark.util.SolrQuerySupport$;
import com.lucidworks.spark.util.SolrRelationUtil$;
import com.lucidworks.spark.util.SolrSupport$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.joda.time.DateTime;
import org.joda.time.format.ISODateTimeFormat;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SolrRelationUtil$
implements LazyLogging {
    public static final SolrRelationUtil$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SolrRelationUtil$();
    }

    private Logger logger$lzycompute() {
        SolrRelationUtil$ solrRelationUtil$ = this;
        synchronized (solrRelationUtil$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public StructType getBaseSchema(String zkHost, String collection, boolean escapeFields, boolean flattenMultivalued) {
        return this.getBaseSchema((Set<String>)Predef$.MODULE$.Set().empty(), zkHost, collection, escapeFields, flattenMultivalued);
    }

    public StructType getBaseSchema(Set<String> fields, String zkHost, String collection, boolean escapeFields, boolean flattenMultivalued) {
        String solrBaseUrl = SolrSupport$.MODULE$.getSolrBaseUrl(zkHost);
        Map<String, SolrFieldMeta> fieldTypeMap = SolrQuerySupport$.MODULE$.getFieldTypes(fields, solrBaseUrl, collection);
        ListBuffer structFields = new ListBuffer();
        fieldTypeMap.foreach((Function1)new Serializable(escapeFields, flattenMultivalued, structFields){
            public static final long serialVersionUID = 0L;
            private final boolean escapeFields$1;
            private final boolean flattenMultivalued$1;
            private final ListBuffer structFields$1;

            public final boolean apply(Tuple2<String, SolrFieldMeta> x0$1) {
                Tuple2<String, SolrFieldMeta> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String fieldName = (String)tuple2._1();
                    SolrFieldMeta fieldMeta = (SolrFieldMeta)tuple2._2();
                    MetadataBuilder metadata = new MetadataBuilder();
                    DataType dataType = fieldMeta.fieldTypeClass().isDefined() ? (SolrQuerySupport$.MODULE$.SOLR_DATA_TYPES().contains(fieldMeta.fieldTypeClass().get()) ? (DataType)SolrQuerySupport$.MODULE$.SOLR_DATA_TYPES().apply(fieldMeta.fieldTypeClass().get()) : DataTypes.StringType) : DataTypes.StringType;
                    metadata.putString("name", fieldName);
                    metadata.putString("type", fieldMeta.fieldType());
                    if (!this.flattenMultivalued$1 && fieldMeta.isMultiValued().isDefined()) {
                        if (BoxesRunTime.unboxToBoolean((Object)fieldMeta.isMultiValued().get())) {
                            dataType = new ArrayType(dataType, true);
                            boxedUnit = metadata.putBoolean("multiValued", true);
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Object object = fieldMeta.isRequired().isDefined() ? metadata.putBoolean("required", BoxesRunTime.unboxToBoolean((Object)fieldMeta.isRequired().get())) : BoxedUnit.UNIT;
                    Object object2 = fieldMeta.isDocValues().isDefined() ? metadata.putBoolean("docValues", BoxesRunTime.unboxToBoolean((Object)fieldMeta.isDocValues().get())) : BoxedUnit.UNIT;
                    Object object3 = fieldMeta.isStored().isDefined() ? metadata.putBoolean("stored", BoxesRunTime.unboxToBoolean((Object)fieldMeta.isStored().get())) : BoxedUnit.UNIT;
                    Object object4 = fieldMeta.fieldTypeClass().isDefined() ? metadata.putString("class", (String)fieldMeta.fieldTypeClass().get()) : BoxedUnit.UNIT;
                    Object object5 = fieldMeta.dynamicBase().isDefined() ? metadata.putString("dynamicBase", (String)fieldMeta.dynamicBase().get()) : BoxedUnit.UNIT;
                    String name = this.escapeFields$1 ? fieldName.replaceAll("\\.", "_") : fieldName;
                    boolean bl = JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.structFields$1).add(DataTypes.createStructField((String)name, (DataType)dataType, (!BoxesRunTime.unboxToBoolean((Object)fieldMeta.isRequired().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return false;
                        }
                    })) ? 1 : 0) != 0, (Metadata)metadata.build()));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.escapeFields$1 = escapeFields$1;
                this.flattenMultivalued$1 = flattenMultivalued$1;
                this.structFields$1 = structFields$1;
            }
        });
        return DataTypes.createStructType((List)JavaConversions$.MODULE$.seqAsJavaList((Seq)structFields.toList()));
    }

    public StructType deriveQuerySchema(String[] fields, StructType schema) {
        HashMap fieldMap = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])schema.fields()).foreach((Function1)new Serializable(fieldMap){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldMap$1;

            public final Option<StructField> apply(StructField structField) {
                return this.fieldMap$1.put((Object)structField.name(), (Object)structField);
            }
            {
                this.fieldMap$1 = fieldMap$1;
            }
        });
        ListBuffer listOfFields = new ListBuffer();
        Predef$.MODULE$.refArrayOps((Object[])fields).foreach((Function1)new Serializable(fieldMap, listOfFields){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldMap$1;
            private final ListBuffer listOfFields$1;

            public final Object apply(String field) {
                Object object;
                if (this.fieldMap$1.contains((Object)field)) {
                    if (this.fieldMap$1.get((Object)field).isDefined()) {
                        object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.listOfFields$1).add(this.fieldMap$1.get((Object)field).get()));
                    } else if (SolrRelationUtil$.MODULE$.logger().underlying().isInfoEnabled()) {
                        SolrRelationUtil$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"No structField definition found for field '").append((Object)field).append((Object)"'").toString());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else if (field.equals("score")) {
                    object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.listOfFields$1).add(DataTypes.createStructField((String)"score", (DataType)DataTypes.DoubleType, (boolean)false, (Metadata)Metadata$.MODULE$.empty())));
                } else if (SolrRelationUtil$.MODULE$.logger().underlying().isInfoEnabled()) {
                    SolrRelationUtil$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"Base schema does not contain field '").append((Object)field).append((Object)"'").toString());
                    object = BoxedUnit.UNIT;
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            }
            {
                this.fieldMap$1 = fieldMap$1;
                this.listOfFields$1 = listOfFields$1;
            }
        });
        return listOfFields.isEmpty() ? schema : DataTypes.createStructType((List)JavaConversions$.MODULE$.seqAsJavaList((Seq)listOfFields.toList()));
    }

    public void applyDefaultFields(StructType baseSchema, SolrQuery solrQuery, boolean flattenMultivalued) {
        StructField[] schemaFields = baseSchema.fields();
        ListBuffer fieldList = new ListBuffer();
        Predef$.MODULE$.refArrayOps((Object[])schemaFields).foreach((Function1)new Serializable(flattenMultivalued, fieldList){
            public static final long serialVersionUID = 0L;
            private final boolean flattenMultivalued$2;
            private final ListBuffer fieldList$1;

            public final Object apply(StructField schemaField) {
                Metadata meta = schemaField.metadata();
                boolean isMultiValued = !this.flattenMultivalued$2 && meta.contains("multiValued") ? meta.getBoolean("multiValued") : false;
                boolean isDocValues = meta.contains("docValues") ? meta.getBoolean("docValues") : false;
                boolean isStored = meta.contains("stored") ? meta.getBoolean("stored") : false;
                return isStored || isDocValues && !isMultiValued ? BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.fieldList$1).add(schemaField.name())) : BoxedUnit.UNIT;
            }
            {
                this.flattenMultivalued$2 = flattenMultivalued$2;
                this.fieldList$1 = fieldList$1;
            }
        });
        solrQuery.setFields((String[])fieldList.toList().toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public SolrQuery applyFilter(Filter filter, SolrQuery solrQuery, StructType baseSchema) {
        SolrQuery solrQuery2;
        Filter filter2 = filter;
        if (filter2 instanceof And) {
            And and = (And)filter2;
            solrQuery.addFilterQuery(new String[]{this.fq(and.left(), baseSchema)});
            solrQuery2 = solrQuery.addFilterQuery(new String[]{this.fq(and.right(), baseSchema)});
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            solrQuery2 = solrQuery.addFilterQuery(new String[]{new StringBuilder().append((Object)"(").append((Object)this.fq(or.left(), baseSchema)).append((Object)" OR ").append((Object)this.fq(or.right(), baseSchema)).append((Object)")").toString()});
        } else if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            solrQuery2 = solrQuery.addFilterQuery(new String[]{new StringBuilder().append((Object)"NOT ").append((Object)this.fq(not.child(), baseSchema)).toString()});
        } else {
            solrQuery2 = solrQuery.addFilterQuery(new String[]{this.fq(filter, baseSchema)});
        }
        return solrQuery2;
    }

    public String getFilterValue(String attr, String value, StructType baseSchema) {
        StructField fieldType = baseSchema.apply(attr);
        DataType dataType = fieldType.dataType();
        String string = TimestampType$.MODULE$.equals(dataType) ? this.convertToISO(value) : value;
        return string;
    }

    public String convertToISO(String ts) {
        long unixSeconds = Timestamp.valueOf(ts).getTime();
        String isoValue = ISODateTimeFormat.dateTime().withZoneUTC().print(unixSeconds);
        return String.format("\"%s\"", isoValue);
    }

    public String fq(Filter filter, StructType baseSchema) {
        block17: {
            None$ attr;
            None$ crit;
            String negate;
            block6: {
                Filter filter2;
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block10: {
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block5: {
                                                            negate = "";
                                                            crit = None$.MODULE$;
                                                            attr = None$.MODULE$;
                                                            filter2 = filter;
                                                            if (!(filter2 instanceof EqualTo)) break block5;
                                                            EqualTo equalTo = (EqualTo)filter2;
                                                            attr = new Some((Object)equalTo.attribute());
                                                            crit = new Some((Object)this.getFilterValue(equalTo.attribute(), String.valueOf(equalTo.value()), baseSchema));
                                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                            break block6;
                                                        }
                                                        if (!(filter2 instanceof EqualNullSafe)) break block7;
                                                        EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
                                                        attr = new Some((Object)equalNullSafe.attribute());
                                                        crit = new Some((Object)this.getFilterValue(equalNullSafe.attribute(), String.valueOf(equalNullSafe.value()), baseSchema));
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        break block6;
                                                    }
                                                    if (!(filter2 instanceof GreaterThan)) break block8;
                                                    GreaterThan greaterThan = (GreaterThan)filter2;
                                                    attr = new Some((Object)greaterThan.attribute());
                                                    crit = new Some((Object)new StringBuilder().append((Object)"{").append((Object)this.getFilterValue(greaterThan.attribute(), String.valueOf(greaterThan.value()), baseSchema)).append((Object)" TO *]").toString());
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block6;
                                                }
                                                if (!(filter2 instanceof GreaterThanOrEqual)) break block9;
                                                GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
                                                attr = new Some((Object)greaterThanOrEqual.attribute());
                                                crit = new Some((Object)new StringBuilder().append((Object)"[").append((Object)this.getFilterValue(greaterThanOrEqual.attribute(), String.valueOf(greaterThanOrEqual.value()), baseSchema)).append((Object)" TO *]").toString());
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block6;
                                            }
                                            if (!(filter2 instanceof LessThan)) break block10;
                                            LessThan lessThan = (LessThan)filter2;
                                            attr = new Some((Object)lessThan.attribute());
                                            crit = new Some((Object)new StringBuilder().append((Object)"[* TO ").append((Object)this.getFilterValue(lessThan.attribute(), String.valueOf(lessThan.value()), baseSchema)).append((Object)"}").toString());
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block6;
                                        }
                                        if (!(filter2 instanceof LessThanOrEqual)) break block11;
                                        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
                                        attr = new Some((Object)lessThanOrEqual.attribute());
                                        crit = new Some((Object)new StringBuilder().append((Object)"[* TO ").append((Object)this.getFilterValue(lessThanOrEqual.attribute(), String.valueOf(lessThanOrEqual.value()), baseSchema)).append((Object)"]").toString());
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block6;
                                    }
                                    if (!(filter2 instanceof In)) break block12;
                                    In in = (In)filter2;
                                    attr = new Some((Object)in.attribute());
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("(");
                                    Object[] values = in.values();
                                    Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)values).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(sb){
                                        public static final long serialVersionUID = 0L;
                                        private final StringBuilder sb$1;

                                        public final StringBuilder apply(Tuple2<Object, Object> x0$2) {
                                            Tuple2<Object, Object> tuple2 = x0$2;
                                            if (tuple2 != null) {
                                                Object value = tuple2._1();
                                                int i = tuple2._2$mcI$sp();
                                                Object object = i > 0 ? this.sb$1.append(" ") : BoxedUnit.UNIT;
                                                StringBuilder stringBuilder = this.sb$1.append(String.valueOf(value));
                                                return stringBuilder;
                                            }
                                            throw new MatchError(tuple2);
                                        }
                                        {
                                            this.sb$1 = sb$1;
                                        }
                                    });
                                    sb.append(")");
                                    crit = new Some((Object)sb.result());
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block6;
                                }
                                if (!(filter2 instanceof IsNotNull)) break block13;
                                IsNotNull isNotNull = (IsNotNull)filter2;
                                attr = new Some((Object)isNotNull.attribute());
                                crit = new Some((Object)"[* TO *]");
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block6;
                            }
                            if (!(filter2 instanceof IsNull)) break block14;
                            IsNull isNull = (IsNull)filter2;
                            attr = new Some((Object)isNull.attribute());
                            crit = new Some((Object)"[* TO *]");
                            negate = "-";
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block6;
                        }
                        if (!(filter2 instanceof StringContains)) break block15;
                        StringContains stringContains = (StringContains)filter2;
                        attr = new Some((Object)stringContains.attribute());
                        crit = new Some((Object)new StringBuilder().append((Object)"*").append((Object)stringContains.value()).append((Object)"*").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!(filter2 instanceof StringEndsWith)) break block16;
                    StringEndsWith stringEndsWith = (StringEndsWith)filter2;
                    attr = new Some((Object)stringEndsWith.attribute());
                    crit = new Some((Object)new StringBuilder().append((Object)stringEndsWith.value()).append((Object)"*").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                if (!(filter2 instanceof StringStartsWith)) break block17;
                StringStartsWith stringStartsWith = (StringStartsWith)filter2;
                attr = new Some((Object)stringStartsWith.attribute());
                crit = new Some((Object)new StringBuilder().append((Object)"*").append((Object)stringStartsWith.value()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (attr.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Could not get filter attribute for '").append((Object)filter).append((Object)" (").append((Object)filter.getClass().getName()).append((Object)")'").toString());
            }
            if (attr.isEmpty()) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Could not get filter criteria for '").append((Object)filter).append((Object)" (").append((Object)filter.getClass().getName()).append((Object)")'").toString());
            }
            return new StringBuilder().append((Object)negate).append((Object)this.attributeToFieldName((String)attr.get(), baseSchema)).append((Object)":").append(crit.get()).toString();
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"Filters of type '").append((Object)filter).append((Object)" (").append((Object)filter.getClass().getName()).append((Object)")' not supported!").toString());
    }

    public String attributeToFieldName(String attr, StructType baseSchema) {
        Metadata meta;
        Option structField;
        HashMap fieldMap = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])baseSchema.fields()).foreach((Function1)new Serializable(fieldMap){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldMap$2;

            public final Option<StructField> apply(StructField schemaField) {
                return this.fieldMap$2.put((Object)schemaField.name(), (Object)schemaField);
            }
            {
                this.fieldMap$2 = fieldMap$2;
            }
        });
        String string = fieldMap.contains((Object)attr) ? ((structField = fieldMap.get((Object)attr.replaceAll("`", ""))).isDefined() ? ((meta = ((StructField)structField.get()).metadata()).contains("name") ? meta.getString("name") : ((StructField)structField.get()).name()) : attr) : attr;
        return string;
    }

    public SolrQuery setAliases(String[] fields, SolrQuery solrQuery, StructType schema) {
        HashMap fieldMap = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])schema.fields()).foreach((Function1)new Serializable(fieldMap){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldMap$3;

            public final Option<StructField> apply(StructField structField) {
                return this.fieldMap$3.put((Object)structField.name(), (Object)structField);
            }
            {
                this.fieldMap$3 = fieldMap$3;
            }
        });
        ListBuffer fieldList = new ListBuffer();
        Predef$.MODULE$.refArrayOps((Object[])fields).foreach((Function1)new Serializable(fieldMap, fieldList){
            public static final long serialVersionUID = 0L;
            private final HashMap fieldMap$3;
            private final ListBuffer fieldList$2;

            public final Object apply(String field) {
                Object object;
                if (this.fieldMap$3.contains((Object)field)) {
                    if (this.fieldMap$3.get((Object)field).isDefined()) {
                        boolean isStored;
                        StructField structField = (StructField)this.fieldMap$3.get((Object)field).get();
                        Metadata metadata = structField.metadata();
                        String fieldName = metadata.contains("name") ? metadata.getString("name") : field;
                        boolean isMultiValued = metadata.contains("multiValued") ? metadata.getBoolean("multiValued") : false;
                        boolean isDocValues = metadata.contains("docValues") ? metadata.getBoolean("docValues") : false;
                        boolean bl = isStored = metadata.contains("stored") ? metadata.getBoolean("stored") : false;
                        object = !isStored && isDocValues && !isMultiValued ? BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.fieldList$2).add(new StringBuilder().append((Object)structField.name()).append((Object)":field(").append((Object)fieldName).append((Object)")").toString())) : BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.fieldList$2).add(new StringBuilder().append((Object)structField.name()).append((Object)":").append((Object)fieldName).toString()));
                    } else {
                        JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.fieldList$2).add(field);
                        if (SolrRelationUtil$.MODULE$.logger().underlying().isInfoEnabled()) {
                            SolrRelationUtil$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"StructField def. not found for field '").append((Object)field).append((Object)"' in the base schema").toString());
                            object = BoxedUnit.UNIT;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                    }
                } else {
                    JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.fieldList$2).add(field);
                    if (SolrRelationUtil$.MODULE$.logger().underlying().isInfoEnabled()) {
                        SolrRelationUtil$.MODULE$.logger().underlying().info(new StringBuilder().append((Object)"Field '").append((Object)field).append((Object)"' not found in the schema").toString());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                }
                return object;
            }
            {
                this.fieldMap$3 = fieldMap$3;
                this.fieldList$2 = fieldList$2;
            }
        });
        return solrQuery.setFields((String[])fieldList.toList().toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    public RDD<Row> toRows(StructType schema, RDD<SolrDocument> docs) {
        StructField[] fields = schema.fields();
        RDD rows = docs.map((Function1)new Serializable(schema, fields){
            public static final long serialVersionUID = 0L;
            public final StructType schema$1;
            private final StructField[] fields$1;

            public final Row apply(SolrDocument solrDocument) {
                ListBuffer values = new ListBuffer();
                Predef$.MODULE$.refArrayOps((Object[])this.fields$1).foreach((Function1)new Serializable(this, values, solrDocument){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;
                    private final ListBuffer values$1;
                    private final SolrDocument solrDocument$1;

                    public final Object apply(StructField field) {
                        Boolean bl;
                        boolean isMultiValued;
                        Metadata metadata = field.metadata();
                        DataType fieldType = ((StructField)JavaConversions$.MODULE$.seqAsJavaList((Seq)this.$outer.schema$1).get(this.$outer.schema$1.indexOf((Object)field))).dataType();
                        boolean bl2 = isMultiValued = metadata.contains("multiValued") ? metadata.getBoolean("multiValued") : false;
                        if (isMultiValued) {
                            Collection fieldValues = this.solrDocument$1.getFieldValues(field.name());
                            if (fieldValues == null) {
                                bl = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(null));
                            } else {
                                Iterator iterableValues = JavaConversions$.MODULE$.asScalaIterator(fieldValues.iterator()).map((Function1)new Serializable(this, fieldType){
                                    public static final long serialVersionUID = 0L;
                                    private final DataType fieldType$1;

                                    public final Object apply(Object x0$3) {
                                        Object object;
                                        Object object2 = x0$3;
                                        if (object2 instanceof Date) {
                                            Date date = (Date)object2;
                                            object = new Timestamp(date.getTime());
                                        } else if (object2 instanceof String) {
                                            ArrayType arrayType;
                                            String string = (String)object2;
                                            DataType dataType = this.fieldType$1;
                                            Object object3 = dataType instanceof ArrayType ? ((arrayType = (ArrayType)dataType).elementType() == TimestampType$.MODULE$ ? new Timestamp(DateTime.parse((String)string).getMillis()) : string) : string;
                                            object = object3;
                                        } else if (object2 instanceof Integer) {
                                            Integer n = (Integer)object2;
                                            object = new Long(n.longValue());
                                        } else if (object2 instanceof Float) {
                                            Float f = (Float)object2;
                                            object = new Double(f.doubleValue());
                                        } else {
                                            object = object2;
                                        }
                                        return object;
                                    }
                                    {
                                        this.fieldType$1 = fieldType$1;
                                    }
                                });
                                bl = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(iterableValues.toArray(ClassTag$.MODULE$.Object())));
                            }
                        } else {
                            Object object;
                            Object fieldValue = this.solrDocument$1.getFieldValue(field.name());
                            Object object2 = fieldValue;
                            if (object2 instanceof Date) {
                                Date date = (Date)object2;
                                object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(new Timestamp(date.getTime())));
                            } else if (object2 instanceof String) {
                                String string = (String)object2;
                                object = fieldType == TimestampType$.MODULE$ ? BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(new Timestamp(DateTime.parse((String)string).getMillis()))) : BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(string));
                            } else if (object2 instanceof Integer) {
                                Integer n = (Integer)object2;
                                object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(new Long(n.longValue())));
                            } else if (object2 instanceof Float) {
                                Float f = (Float)object2;
                                object = BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(new Double(f.doubleValue())));
                            } else {
                                Iterable iterable;
                                Iterator iterableValues;
                                Object[] arr;
                                ArrayList arrayList;
                                Iterator jlist;
                                Object[] arr2;
                                object = object2 instanceof ArrayList ? ((arr2 = (Object[])(jlist = JavaConversions$.MODULE$.asScalaIterator((arrayList = (ArrayList)object2).iterator()).map((Function1)new Serializable(this, fieldType){
                                    public static final long serialVersionUID = 0L;
                                    private final DataType fieldType$1;

                                    public final Object apply(Object x0$4) {
                                        Object object;
                                        block7: {
                                            Object object2;
                                            block3: {
                                                Object object3;
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                object = x0$4;
                                                                if (!(object instanceof Date)) break block2;
                                                                Date date = (Date)object;
                                                                object2 = new Timestamp(date.getTime());
                                                                break block3;
                                                            }
                                                            if (!(object instanceof String)) break block4;
                                                            String string = (String)object;
                                                            object2 = this.fieldType$1 == TimestampType$.MODULE$ ? new Timestamp(DateTime.parse((String)string).getMillis()) : string;
                                                            break block3;
                                                        }
                                                        if (!(object instanceof Integer)) break block5;
                                                        Integer n = (Integer)object;
                                                        object2 = new Long(n.longValue());
                                                        break block3;
                                                    }
                                                    if (!(object instanceof Float)) break block6;
                                                    Float f = (Float)object;
                                                    object2 = new Double(f.doubleValue());
                                                    break block3;
                                                }
                                                if (!(object instanceof Object)) break block7;
                                                object2 = object3 = object;
                                            }
                                            return object2;
                                        }
                                        throw new MatchError(object);
                                    }
                                    {
                                        this.fieldType$1 = fieldType$1;
                                    }
                                })).toArray(ClassTag$.MODULE$.Any())).length >= 1 ? BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(arr2[0])) : BoxedUnit.UNIT) : (object2 instanceof Iterable ? (Predef$.MODULE$.genericArrayOps((Object)(arr = (Object[])(iterableValues = (iterable = (Iterable)object2).iterator().map((Function1)new Serializable(this, fieldType){
                                    public static final long serialVersionUID = 0L;
                                    private final DataType fieldType$1;

                                    public final Object apply(Object x0$5) {
                                        Object object;
                                        block7: {
                                            Object object2;
                                            block3: {
                                                Object object3;
                                                block6: {
                                                    block5: {
                                                        block4: {
                                                            block2: {
                                                                object = x0$5;
                                                                if (!(object instanceof Date)) break block2;
                                                                Date date = (Date)object;
                                                                object2 = new Timestamp(date.getTime());
                                                                break block3;
                                                            }
                                                            if (!(object instanceof String)) break block4;
                                                            String string = (String)object;
                                                            object2 = this.fieldType$1 == TimestampType$.MODULE$ ? new Timestamp(DateTime.parse((String)string).getMillis()) : string;
                                                            break block3;
                                                        }
                                                        if (!(object instanceof Integer)) break block5;
                                                        Integer n = (Integer)object;
                                                        object2 = new Long(n.longValue());
                                                        break block3;
                                                    }
                                                    if (!(object instanceof Float)) break block6;
                                                    Float f = (Float)object;
                                                    object2 = new Double(f.doubleValue());
                                                    break block3;
                                                }
                                                if (!(object instanceof Object)) break block7;
                                                object2 = object3 = object;
                                            }
                                            return object2;
                                        }
                                        throw new MatchError(object);
                                    }
                                    {
                                        this.fieldType$1 = fieldType$1;
                                    }
                                })).toArray(ClassTag$.MODULE$.Any()))).isEmpty() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(arr[0]))) : BoxesRunTime.boxToBoolean((boolean)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)this.values$1).add(object2)));
                            }
                            bl = object;
                        }
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.values$1 = values$1;
                        this.solrDocument$1 = solrDocument$1;
                    }
                });
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)((Object[])values.toArray(ClassTag$.MODULE$.AnyRef()))));
            }
            {
                this.schema$1 = schema$1;
                this.fields$1 = fields$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        return rows;
    }

    private SolrRelationUtil$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

