/*
 * Decompiled with CFR 0.152.
 */
package com.lucidworks.spark.util;

import com.lucidworks.spark.SolrReplica;
import com.lucidworks.spark.SolrShard;
import com.lucidworks.spark.filter.DocFilterContext;
import com.lucidworks.spark.fusion.FusionPipelineClient;
import com.lucidworks.spark.query.NumberFieldShardSplitStrategy;
import com.lucidworks.spark.query.ShardSplit;
import com.lucidworks.spark.query.ShardSplitStrategy;
import com.lucidworks.spark.query.StringFieldShardSplitStrategy;
import com.lucidworks.spark.rdd.SolrRDD$;
import com.lucidworks.spark.util.CacheSolrClient$;
import com.lucidworks.spark.util.EmbeddedSolrServerFactory;
import com.lucidworks.spark.util.SolrFieldMeta;
import com.lucidworks.spark.util.SolrQuerySupport$;
import com.lucidworks.spark.util.SolrSupport$;
import com.lucidworks.spark.util.SolrSupport$$anonfun$buildShardList$2$;
import com.lucidworks.spark.util.SolrSupport$$anonfun$filterDocuments$1$;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.Krb5HttpClientConfigurer;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.SolrParams;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.streaming.dstream.DStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.control.Breaks$;

public final class SolrSupport$
implements LazyLogging {
    public static final SolrSupport$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SolrSupport$();
    }

    private Logger logger$lzycompute() {
        SolrSupport$ solrSupport$ = this;
        synchronized (solrSupport$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public synchronized void setupKerberosIfNeeded() {
        Some configurer;
        Some solrJaasAuthConfig = new Some((Object)System.getProperty("java.security.auth.login.config"));
        if (solrJaasAuthConfig.isDefined() && (configurer = new Some((Object)HttpClientUtil.getConfigurer())).isDefined() && !(configurer.get() instanceof Krb5HttpClientConfigurer)) {
            BoxedUnit boxedUnit;
            HttpClientUtil.setConfigurer((HttpClientConfigurer)new Krb5HttpClientConfigurer());
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"Installed the Krb5HttpClientConfigurer for Solr security using config: ").append((Object)solrJaasAuthConfig).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public HttpSolrClient getHttpSolrClient(String shardUrl) {
        this.setupKerberosIfNeeded();
        return new HttpSolrClient(shardUrl);
    }

    /*
     * WARNING - void declaration
     */
    private CloudSolrClient getSolrCloudClient(String zkHost) {
        void var2_2;
        this.setupKerberosIfNeeded();
        CloudSolrClient solrClient = new CloudSolrClient(zkHost);
        solrClient.connect();
        return var2_2;
    }

    public CloudSolrClient getNewSolrCloudClient(String zkHost) {
        return this.getSolrCloudClient(zkHost);
    }

    public CloudSolrClient getCachedCloudClient(String zkHost) {
        return (CloudSolrClient)CacheSolrClient$.MODULE$.cache().get((Object)zkHost);
    }

    public String getSolrBaseUrl(String zkHost) {
        CloudSolrClient solrClient = this.getCachedCloudClient(zkHost);
        Set liveNodes = solrClient.getZkStateReader().getClusterState().getLiveNodes();
        if (liveNodes.isEmpty()) {
            throw new RuntimeException(new StringBuilder().append((Object)"No live nodes found for cluster: ").append((Object)zkHost).toString());
        }
        String solrBaseUrl = solrClient.getZkStateReader().getBaseUrlForNodeName((String)liveNodes.iterator().next());
        if (!solrBaseUrl.endsWith("?")) {
            solrBaseUrl = new StringBuilder().append((Object)solrBaseUrl).append((Object)"/").toString();
        }
        return solrBaseUrl;
    }

    public void indexDStreamOfDocs(String zkHost, String collection, int batchSize, DStream<SolrInputDocument> docs) {
        docs.foreachRDD((Function1)new Serializable(zkHost, collection, batchSize){
            public static final long serialVersionUID = 0L;
            private final String zkHost$2;
            private final String collection$2;
            private final int batchSize$2;

            public final void apply(RDD<SolrInputDocument> rdd) {
                SolrSupport$.MODULE$.indexDocs(this.zkHost$2, this.collection$2, this.batchSize$2, rdd);
            }
            {
                this.zkHost$2 = zkHost$2;
                this.collection$2 = collection$2;
                this.batchSize$2 = batchSize$2;
            }
        });
    }

    public void sendDStreamOfDocsToFusion(String fusionUrl, String fusionCredentials, DStream<?> docs, int batchSize) {
        String[] urls = (String[])Predef$.MODULE$.refArrayOps((Object[])fusionUrl.split(",")).distinct();
        URL url = new URL(urls[0]);
        String pipelinePath = url.getPath();
        docs.foreachRDD((Function1)new Serializable(fusionUrl, fusionCredentials, batchSize, pipelinePath){
            public static final long serialVersionUID = 0L;
            public final String fusionUrl$1;
            public final String fusionCredentials$1;
            public final int batchSize$3;
            public final String pipelinePath$1;

            public final void apply(RDD<Object> rdd) {
                rdd.foreachPartition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.sendDStreamOfDocsToFusion.1 $outer;

                    public final void apply(Iterator<Object> docIter) {
                        String[] creds;
                        String[] stringArray = creds = this.$outer.fusionCredentials$1 == null ? null : this.$outer.fusionCredentials$1.split(":");
                        if (Predef$.MODULE$.refArrayOps((Object[])creds).size() != 3) {
                            throw new Exception("Not valid format for Fusion credentials. Except 3 objects separated by :");
                        }
                        FusionPipelineClient fusionClient = creds != null ? new FusionPipelineClient(this.$outer.fusionUrl$1, creds[0], creds[1], creds[2]) : new FusionPipelineClient(this.$outer.fusionUrl$1);
                        List batch = List$.MODULE$.empty();
                        Date indexedAt = new Date();
                        while (docIter.hasNext()) {
                            Object inputDoc = docIter.next();
                            JavaConversions$.MODULE$.seqAsJavaList((Seq)batch).add(inputDoc);
                            if (batch.size() < this.$outer.batchSize$3) continue;
                            fusionClient.postBatchToPipeline(this.$outer.pipelinePath$1, JavaConversions$.MODULE$.seqAsJavaList((Seq)batch));
                            batch = List$.MODULE$.empty();
                        }
                        if (batch.nonEmpty()) {
                            fusionClient.postBatchToPipeline(this.$outer.pipelinePath$1, JavaConversions$.MODULE$.seqAsJavaList((Seq)batch));
                            batch = List$.MODULE$.empty();
                        }
                        fusionClient.shutdown();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.fusionUrl$1 = fusionUrl$1;
                this.fusionCredentials$1 = fusionCredentials$1;
                this.batchSize$3 = batchSize$3;
                this.pipelinePath$1 = pipelinePath$1;
            }
        });
    }

    public void indexDocs(String zkHost, String collection, int batchSize, RDD<SolrInputDocument> rdd) {
        this.indexDocs(zkHost, collection, batchSize, rdd, (Option<Object>)None$.MODULE$);
    }

    public void indexDocs(String zkHost, String collection, int batchSize, RDD<SolrInputDocument> rdd, Option<Object> commitWithin) {
        rdd.foreachPartition((Function1)new Serializable(zkHost, collection, batchSize, commitWithin){
            public static final long serialVersionUID = 0L;
            private final String zkHost$1;
            private final String collection$1;
            private final int batchSize$1;
            private final Option commitWithin$1;

            public final void apply(Iterator<SolrInputDocument> solrInputDocumentIterator) {
                CloudSolrClient solrClient = SolrSupport$.MODULE$.getCachedCloudClient(this.zkHost$1);
                ArrayBuffer batch = new ArrayBuffer();
                Date indexedAt = new Date();
                int numDocs = 0;
                while (solrInputDocumentIterator.hasNext()) {
                    SolrInputDocument doc = (SolrInputDocument)solrInputDocumentIterator.next();
                    doc.setField("_indexed_at_tdt", (Object)indexedAt);
                    batch.$plus$eq((Object)doc);
                    if (batch.length() < this.batchSize$1) continue;
                    numDocs += batch.length();
                    SolrSupport$.MODULE$.sendBatchToSolr((SolrClient)solrClient, this.collection$1, (Iterable<SolrInputDocument>)batch, (Option<Object>)this.commitWithin$1);
                    batch.clear();
                }
                if (batch.nonEmpty()) {
                    numDocs += batch.length();
                    SolrSupport$.MODULE$.sendBatchToSolr((SolrClient)solrClient, this.collection$1, (Iterable<SolrInputDocument>)batch, (Option<Object>)this.commitWithin$1);
                    batch.clear();
                }
            }
            {
                this.zkHost$1 = zkHost$1;
                this.collection$1 = collection$1;
                this.batchSize$1 = batchSize$1;
                this.commitWithin$1 = commitWithin$1;
            }
        });
    }

    public void sendBatchToSolr(SolrClient solrClient, String collection, Iterable<SolrInputDocument> batch) {
        this.sendBatchToSolr(solrClient, collection, batch, (Option<Object>)None$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendBatchToSolr(SolrClient solrClient, String collection, Iterable<SolrInputDocument> batch, Option<Object> commitWithin) {
        BoxedUnit boxedUnit;
        UpdateRequest req = new UpdateRequest();
        req.setParam("collection", collection);
        long initialTime = System.currentTimeMillis();
        if (commitWithin.isDefined()) {
            req.setCommitWithin(BoxesRunTime.unboxToInt((Object)commitWithin.get()));
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringBuilder().append((Object)"Sending batch of ").append((Object)BoxesRunTime.boxToInteger((int)batch.size())).append((Object)" to collection ").append((Object)collection).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        req.add(JavaConversions$.MODULE$.asJavaCollection(batch));
        try {
            BoxedUnit boxedUnit2;
            solrClient.request((SolrRequest)req);
            double timeTaken = (double)(System.currentTimeMillis() - initialTime) / 1000.0;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info(new StringBuilder().append((Object)"Took '").append((Object)BoxesRunTime.boxToDouble((double)timeTaken)).append((Object)"' secs to index '").append((Object)BoxesRunTime.boxToInteger((int)batch.size())).append((Object)"' documents").toString());
                boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
            boxedUnit2 = BoxedUnit.UNIT;
            return;
        }
        catch (Exception exception) {
            if (this.shouldRetry(exception)) {
                Object object;
                BoxedUnit boxedUnit3;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Send batch to collection ").append((Object)collection).append((Object)" failed due to ").append((Object)exception).append((Object)" ; will retry ...").toString());
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                try {
                    Thread.sleep(2000L);
                    object = BoxedUnit.UNIT;
                }
                catch (InterruptedException interruptedException) {
                    object = BoxesRunTime.boxToBoolean((boolean)Thread.interrupted());
                }
            } else {
                BoxedUnit boxedUnit4;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Send batch to collection ").append((Object)collection).append((Object)" failed due to: ").append((Object)exception).toString(), (Throwable)exception);
                    boxedUnit4 = BoxedUnit.UNIT;
                } else {
                    boxedUnit4 = BoxedUnit.UNIT;
                }
                Exception exception2 = exception;
                if (exception2 instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)exception2;
                    throw runtimeException;
                }
                if (exception2 == null) throw new MatchError((Object)exception2);
                Exception exception3 = exception2;
                throw new RuntimeException(exception3);
            }
            try {
                solrClient.request((SolrRequest)req);
                return;
            }
            catch (Exception exception4) {
                BoxedUnit boxedUnit5;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder().append((Object)"Send batch to collection ").append((Object)collection).append((Object)" failed due to: ").append((Object)exception).toString(), (Throwable)exception);
                    boxedUnit5 = BoxedUnit.UNIT;
                } else {
                    boxedUnit5 = BoxedUnit.UNIT;
                }
                Exception exception5 = exception4;
                if (exception5 instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)exception5;
                    throw runtimeException;
                }
                if (exception5 == null) throw new MatchError((Object)exception5);
                Exception exception6 = exception5;
                throw new RuntimeException(exception6);
            }
        }
    }

    public boolean shouldRetry(Exception exc) {
        Throwable rootCause = SolrException.getRootCause((Throwable)exc);
        Throwable throwable = rootCause;
        boolean bl = throwable instanceof ConnectException ? true : (throwable instanceof NoHttpResponseException ? true : throwable instanceof SocketException);
        return bl;
    }

    public SolrInputDocument autoMapToSolrInputDoc(String docId, Object obj, scala.collection.immutable.Map<String, String> dynamicFieldOverrides) {
        return this.autoMapToSolrInputDoc("id", docId, obj, dynamicFieldOverrides);
    }

    public SolrInputDocument autoMapToSolrInputDoc(String idFieldName, String docId, Object obj, scala.collection.immutable.Map<String, String> dynamicFieldOverrides) {
        BoxedUnit boxedUnit;
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        doc.setField(idFieldName, (Object)docId);
        if (obj == null) {
            return doc;
        }
        Class<?> objClass = obj.getClass();
        HashSet fields = new HashSet();
        Field[] publicFields = objClass.getFields();
        if (publicFields != null) {
            Breaks$.MODULE$.breakable((Function0)new Serializable(obj, dynamicFieldOverrides, doc, fields, publicFields){
                public static final long serialVersionUID = 0L;
                public final Object obj$1;
                public final scala.collection.immutable.Map dynamicFieldOverrides$1;
                public final SolrInputDocument doc$1;
                public final HashSet fields$1;
                private final Field[] publicFields$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    Predef$.MODULE$.refArrayOps((Object[])this.publicFields$1).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.autoMapToSolrInputDoc.1 $outer;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final void apply(Field f) {
                            Option fieldOverride;
                            BoxedUnit boxedUnit;
                            if (Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers())) throw Breaks$.MODULE$.break();
                            None$ value = None$.MODULE$;
                            try {
                                value = new Some(f.get(this.$outer.obj$1));
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                if (SolrSupport$.MODULE$.logger().underlying().isErrorEnabled()) {
                                    SolrSupport$.MODULE$.logger().underlying().error("Exception during reflection ", (Throwable)illegalAccessException);
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            if (!value.isDefined()) return;
                            String fieldName = f.getName();
                            this.$outer.fields$1.add((Object)fieldName);
                            Option option = fieldOverride = this.$outer.dynamicFieldOverrides$1 == null ? null : this.$outer.dynamicFieldOverrides$1.get((Object)fieldName);
                            if (f.getType() == null) return;
                            SolrSupport$.MODULE$.addField(this.$outer.doc$1, fieldName, value, f.getType(), (Option<String>)fieldOverride);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.obj$1 = obj$1;
                    this.dynamicFieldOverrides$1 = dynamicFieldOverrides$1;
                    this.doc$1 = doc$1;
                    this.fields$1 = fields$1;
                    this.publicFields$1 = publicFields$1;
                }
            });
        }
        None$ props = None$.MODULE$;
        try {
            BeanInfo info = Introspector.getBeanInfo(objClass);
            props = new Some((Object)info.getPropertyDescriptors());
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (IntrospectionException introspectionException) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)"Can't get BeanInfo for class: ").append(objClass).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (props.isDefined()) {
            Predef$.MODULE$.refArrayOps((Object[])props.get()).foreach((Function1)new Serializable(obj, dynamicFieldOverrides, doc, objClass, fields){
                public static final long serialVersionUID = 0L;
                public final Object obj$1;
                public final scala.collection.immutable.Map dynamicFieldOverrides$1;
                public final SolrInputDocument doc$1;
                public final Class objClass$1;
                public final HashSet fields$1;

                public final void apply(PropertyDescriptor pd) {
                    String propName = pd.getName();
                    Breaks$.MODULE$.breakable((Function0)new Serializable(this, propName, pd){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.autoMapToSolrInputDoc.2 $outer;
                        private final String propName$1;
                        private final PropertyDescriptor pd$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            if ("class".equals(this.propName$1) || this.$outer.fields$1.contains((Object)this.propName$1)) {
                                throw Breaks$.MODULE$.break();
                            }
                            Method readMethod = this.pd$1.getReadMethod();
                            readMethod.setAccessible(true);
                            if (readMethod != null) {
                                BoxedUnit boxedUnit;
                                None$ value = None$.MODULE$;
                                try {
                                    value = new Some(readMethod.invoke(this.$outer.obj$1, new Object[0]));
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                catch (Exception exception) {
                                    if (SolrSupport$.MODULE$.logger().underlying().isWarnEnabled()) {
                                        SolrSupport$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"failed to invoke read method for property '").append((Object)this.pd$1.getName()).append((Object)"' on ").append((Object)"object of type '").append((Object)this.$outer.objClass$1.getName()).append((Object)"' due to: ").append((Object)exception).toString());
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                if (value.isDefined()) {
                                    None$ propOverride;
                                    this.$outer.fields$1.add((Object)this.propName$1);
                                    Object object = propOverride = this.$outer.dynamicFieldOverrides$1 == null ? None$.MODULE$ : this.$outer.dynamicFieldOverrides$1.get((Object)this.propName$1);
                                    if (this.pd$1.getPropertyType() != null) {
                                        SolrSupport$.MODULE$.addField(this.$outer.doc$1, this.propName$1, value.get(), this.pd$1.getPropertyType(), (Option<String>)propOverride);
                                    }
                                }
                            }
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.propName$1 = propName$1;
                            this.pd$1 = pd$1;
                        }
                    });
                }
                {
                    this.obj$1 = obj$1;
                    this.dynamicFieldOverrides$1 = dynamicFieldOverrides$1;
                    this.doc$1 = doc$1;
                    this.objClass$1 = objClass$1;
                    this.fields$1 = fields$1;
                }
            });
        }
        return doc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addField(SolrInputDocument doc, String fieldName, Object value, Class<?> classType, Option<String> dynamicFieldSuffix) {
        if (classType.isArray()) {
            return;
        }
        if (dynamicFieldSuffix.isDefined()) {
            doc.addField(new StringBuilder().append((Object)fieldName).append(dynamicFieldSuffix.get()).toString(), value);
            return;
        } else {
            Some suffix = this.getDefaultDynamicFieldMapping(classType);
            if (!suffix.isDefined()) return;
            if ("_s".equals(suffix.get())) {
                if (value == null) return;
                Object object = value;
                if (object instanceof String) {
                    String string = (String)object;
                    if (string.indexOf(" ") != -1) {
                        suffix = new Some((Object)"_t");
                    }
                    String key = new StringBuilder().append((Object)fieldName).append(suffix.get()).toString();
                    doc.addField(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                } else {
                    if (object == null) throw new MatchError(object);
                    Object object2 = object;
                    String v = String.valueOf(object2);
                    if (v.indexOf(" ") != -1) {
                        suffix = new Some((Object)"_t");
                    }
                    String key = new StringBuilder().append((Object)fieldName).append(suffix.get()).toString();
                    doc.addField(key, value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            } else {
                String key = new StringBuilder().append((Object)fieldName).append(suffix.get()).toString();
                doc.addField(key, value);
            }
        }
    }

    public Option<String> getDefaultDynamicFieldMapping(Class<?> clazz) {
        BoxedUnit boxedUnit;
        block28: {
            block27: {
                block26: {
                    block25: {
                        block24: {
                            block23: {
                                block22: {
                                    block21: {
                                        block20: {
                                            block19: {
                                                if (String.class.equals(clazz)) {
                                                    return new Some((Object)"_s");
                                                }
                                                if (Long.class.equals(clazz)) break block19;
                                                Class<Long> clazz2 = Long.TYPE;
                                                Class<?> clazz3 = clazz;
                                                if (clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null) break block20;
                                            }
                                            return new Some((Object)"_l");
                                        }
                                        if (Integer.class.equals(clazz)) break block21;
                                        Class<Integer> clazz4 = Integer.TYPE;
                                        Class<?> clazz5 = clazz;
                                        if (clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null) break block22;
                                    }
                                    return new Some((Object)"_i");
                                }
                                if (Double.class.equals(clazz)) break block23;
                                Class<Double> clazz6 = Double.TYPE;
                                Class<?> clazz7 = clazz;
                                if (clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null) break block24;
                            }
                            return new Some((Object)"_d");
                        }
                        if (Float.class.equals(clazz)) break block25;
                        Class<Float> clazz8 = Float.TYPE;
                        Class<?> clazz9 = clazz;
                        if (clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null) break block26;
                    }
                    return new Some((Object)"_f");
                }
                if (Boolean.class.equals(clazz)) break block27;
                Class<Boolean> clazz10 = Boolean.TYPE;
                Class<?> clazz11 = clazz;
                if (clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null) break block28;
            }
            return new Some((Object)"_b");
        }
        if (Date.class.equals(clazz)) {
            return new Some((Object)"_tdt");
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringBuilder().append((Object)"failed to map class '").append(clazz).append((Object)"' to a known dynamic type").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return None$.MODULE$;
    }

    public DStream<SolrInputDocument> filterDocuments(DocFilterContext filterContext, String zkHost, String collection, DStream<SolrInputDocument> docs) {
        AtomicInteger partitionIndex = new AtomicInteger(0);
        String idFieldName = filterContext.getDocIdFieldName();
        return docs.mapPartitions((Function1)new Serializable(filterContext, zkHost, collection, partitionIndex, idFieldName){
            public static final long serialVersionUID = 0L;
            public final DocFilterContext filterContext$1;
            private final String zkHost$3;
            private final String collection$3;
            private final AtomicInteger partitionIndex$1;
            public final String idFieldName$1;

            public final Iterator<SolrInputDocument> apply(Iterator<SolrInputDocument> solrInputDocumentIterator) {
                long startNano = System.nanoTime();
                int partitionId = this.partitionIndex$1.incrementAndGet();
                String partitionFq = new StringBuilder().append((Object)"docfilterid_i:").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).toString();
                EmbeddedSolrServer solr = EmbeddedSolrServerFactory.singleton.getEmbeddedSolrServer(this.zkHost$3, this.collection$3);
                IntRef numDocs = IntRef.create((int)0);
                HashMap inputDocs = new HashMap();
                while (solrInputDocumentIterator.hasNext()) {
                    ++numDocs.elem;
                    SolrInputDocument doc = (SolrInputDocument)solrInputDocumentIterator.next();
                    doc.setField("docfilterid_i", (Object)BoxesRunTime.boxToInteger((int)partitionId));
                    solr.add(doc);
                    inputDocs.put((Object)((String)doc.getFieldValue(this.idFieldName$1)), (Object)doc);
                }
                solr.commit();
                JavaConversions$.MODULE$.asScalaBuffer(this.filterContext$1.getQueries()).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(SolrQuery check$ifrefutable$1) {
                        SolrQuery solrQuery = check$ifrefutable$1;
                        boolean bl = solrQuery != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, startNano, partitionId, partitionFq, solr, numDocs, (Map)inputDocs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.filterDocuments.1 $outer;
                    private final long startNano$1;
                    private final int partitionId$1;
                    private final String partitionFq$1;
                    private final EmbeddedSolrServer solr$1;
                    private final IntRef numDocs$1;
                    public final Map inputDocs$1;

                    public final void apply(SolrQuery q) {
                        SolrQuery query = q.getCopy();
                        query.setFields(new String[]{this.$outer.idFieldName$1});
                        query.setRows(Predef$.MODULE$.int2Integer(this.inputDocs$1.size()));
                        query.addFilterQuery(new String[]{this.partitionFq$1});
                        None$ queryResponse = None$.MODULE$;
                        try {
                            queryResponse = new Some((Object)this.solr$1.query((SolrParams)query));
                        }
                        catch (SolrServerException solrServerException) {
                            throw new RuntimeException(solrServerException);
                        }
                        if (queryResponse.isDefined()) {
                            BoxedUnit boxedUnit;
                            JavaConversions$.MODULE$.asScalaBuffer((java.util.List)((QueryResponse)queryResponse.get()).getResults()).withFilter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(SolrDocument check$ifrefutable$2) {
                                    SolrDocument solrDocument = check$ifrefutable$2;
                                    boolean bl = solrDocument != null;
                                    return bl;
                                }
                            }).foreach((Function1)new Serializable(this, q){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$filterDocuments$1$$anonfun$apply$4 $outer;
                                private final SolrQuery q$1;

                                public final void apply(SolrDocument doc) {
                                    String docId = (String)doc.getFirstValue(this.$outer.com$lucidworks$spark$util$SolrSupport$$anonfun$$anonfun$$$outer().idFieldName$1);
                                    Option inputDoc = this.$outer.inputDocs$1.get((Object)docId);
                                    if (inputDoc.isDefined()) {
                                        this.$outer.com$lucidworks$spark$util$SolrSupport$$anonfun$$anonfun$$$outer().filterContext$1.onMatch(this.q$1, (SolrInputDocument)inputDoc.get());
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.q$1 = q$1;
                                }
                            });
                            this.solr$1.deleteByQuery(this.partitionFq$1, 100);
                            long durationNano = System.nanoTime() - this.startNano$1;
                            if (SolrSupport$.MODULE$.logger().underlying().isDebugEnabled()) {
                                SolrSupport$.MODULE$.logger().underlying().debug(new StringBuilder().append((Object)"Partition ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId$1)).append((Object)" took ").append((Object)BoxesRunTime.boxToLong((long)TimeUnit.MILLISECONDS.convert(durationNano, TimeUnit.NANOSECONDS))).append((Object)"ms to process ").append((Object)BoxesRunTime.boxToInteger((int)this.numDocs$1.elem)).append((Object)" docs").toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            this.inputDocs$1.values().foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final SolrInputField apply(SolrInputDocument inputDoc) {
                                    return inputDoc.removeField("docfilterid_i");
                                }
                            });
                        }
                    }

                    public /* synthetic */ anonfun.filterDocuments.1 com$lucidworks$spark$util$SolrSupport$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.startNano$1 = startNano$1;
                        this.partitionId$1 = partitionId$1;
                        this.partitionFq$1 = partitionFq$1;
                        this.solr$1 = solr$1;
                        this.numDocs$1 = numDocs$1;
                        this.inputDocs$1 = inputDocs$1;
                    }
                });
                return inputDocs.valuesIterator();
            }
            {
                this.filterContext$1 = filterContext$1;
                this.zkHost$3 = zkHost$3;
                this.collection$3 = collection$3;
                this.partitionIndex$1 = partitionIndex$1;
                this.idFieldName$1 = idFieldName$1;
            }
        }, docs.mapPartitions$default$2(), ClassTag$.MODULE$.apply(SolrInputDocument.class));
    }

    public List<SolrShard> buildShardList(String zkHost, String collection) {
        CloudSolrClient solrClient = this.getCachedCloudClient(zkHost);
        ZkStateReader zkStateReader = solrClient.getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        ObjectRef collections = ObjectRef.create((Object)((String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class))));
        Predef$.MODULE$.refArrayOps((Object[])collection.split(",")).foreach((Function1)new Serializable(zkStateReader, clusterState, collections){
            public static final long serialVersionUID = 0L;
            private final ZkStateReader zkStateReader$1;
            private final ClusterState clusterState$1;
            private final ObjectRef collections$1;

            public final void apply(String col) {
                if (this.clusterState$1.hasCollection(col)) {
                    this.collections$1.elem = (String[])Predef$.MODULE$.refArrayOps((Object[])((String[])this.collections$1.elem)).$colon$plus((Object)col, ClassTag$.MODULE$.apply(String.class));
                } else {
                    Aliases aliases = this.zkStateReader$1.getAliases();
                    String aliasedCollections = aliases.getCollectionAlias(col);
                    if (aliasedCollections == null) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)"Collection ").append((Object)col).append((Object)" not found!").toString());
                    }
                    this.collections$1.elem = aliasedCollections.split(",");
                }
            }
            {
                this.zkStateReader$1 = zkStateReader$1;
                this.clusterState$1 = clusterState$1;
                this.collections$1 = collections$1;
            }
        });
        Set liveNodes = clusterState.getLiveNodes();
        ListBuffer shards = new ListBuffer();
        Predef$.MODULE$.refArrayOps((Object[])((String[])collections.elem)).foreach((Function1)new Serializable(clusterState, liveNodes, shards){
            public static final long serialVersionUID = 0L;
            private final ClusterState clusterState$1;
            public final Set liveNodes$1;
            public final ListBuffer shards$1;

            public final void apply(String coll) {
                JavaConversions$.MODULE$.collectionAsScalaIterable(this.clusterState$1.getSlices(coll)).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Slice check$ifrefutable$3) {
                        Slice slice = check$ifrefutable$3;
                        boolean bl = slice != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, coll){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.buildShardList.2 $outer;
                    private final String coll$1;

                    public final ListBuffer<SolrShard> apply(Slice slice) {
                        ObjectRef replicas = ObjectRef.create((Object)new ListBuffer());
                        JavaConversions$.MODULE$.collectionAsScalaIterable(slice.getReplicas()).withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Replica check$ifrefutable$4) {
                                Replica replica = check$ifrefutable$4;
                                boolean bl = replica != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this, replicas){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$buildShardList$2$$anonfun$apply$9 $outer;
                            private final ObjectRef replicas$1;

                            /*
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public final Object apply(Replica r) {
                                BoxedUnit boxedUnit;
                                Replica.State state = r.getState();
                                Replica.State state2 = Replica.State.ACTIVE;
                                if (!(state != null ? !state.equals(state2) : state2 != null)) {
                                    ZkCoreNodeProps replicaCoreProps = new ZkCoreNodeProps((ZkNodeProps)r);
                                    if (!this.$outer.com$lucidworks$spark$util$SolrSupport$$anonfun$$anonfun$$$outer().liveNodes$1.contains(replicaCoreProps.getNodeName())) {
                                        boxedUnit = BoxedUnit.UNIT;
                                        return boxedUnit;
                                    }
                                    try {
                                        InetAddress[] addresses = InetAddress.getAllByName(new URL(replicaCoreProps.getBaseUrl()).getHost());
                                        boxedUnit = ((ListBuffer)this.replicas$1.elem).$plus$eq((Object)new SolrReplica(0, replicaCoreProps.getCoreName(), replicaCoreProps.getCoreUrl(), replicaCoreProps.getNodeName(), addresses));
                                        return boxedUnit;
                                    }
                                    catch (Exception exception) {
                                        BoxedUnit boxedUnit2;
                                        if (SolrSupport$.MODULE$.logger().underlying().isWarnEnabled()) {
                                            SolrSupport$.MODULE$.logger().underlying().warn(new StringBuilder().append((Object)"Error resolving ip address ").append((Object)replicaCoreProps.getNodeName()).append((Object)" . Exception ").append((Object)exception).toString());
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        } else {
                                            boxedUnit2 = BoxedUnit.UNIT;
                                        }
                                        boxedUnit = ((ListBuffer)this.replicas$1.elem).$plus$eq((Object)new SolrReplica(0, replicaCoreProps.getCoreName(), replicaCoreProps.getCoreUrl(), replicaCoreProps.getNodeName(), (InetAddress[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InetAddress.class))));
                                        return boxedUnit;
                                    }
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                    return boxedUnit;
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.replicas$1 = replicas$1;
                            }
                        });
                        int numReplicas = ((ListBuffer)replicas.elem).size();
                        if (numReplicas == 0) {
                            throw new IllegalStateException(new StringBuilder().append((Object)"Shard ").append((Object)slice.getName()).append((Object)" in collection ").append((Object)this.coll$1).append((Object)" does not have any active replicas!").toString());
                        }
                        return this.$outer.shards$1.$plus$eq((Object)new SolrShard(slice.getName(), (List<SolrReplica>)((ListBuffer)replicas.elem).toList()));
                    }

                    public /* synthetic */ anonfun.buildShardList.2 com$lucidworks$spark$util$SolrSupport$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.coll$1 = coll$1;
                    }
                });
            }
            {
                this.clusterState$1 = clusterState$1;
                this.liveNodes$1 = liveNodes$1;
                this.shards$1 = shards$1;
            }
        });
        return shards.toList();
    }

    public List<ShardSplit<?>> splitShards(SolrQuery query, SolrShard solrShard, String splitFieldName, int splitsPerShard) {
        Object fieldDataType = None$.MODULE$;
        if ("_version_".equals(splitFieldName)) {
            fieldDataType = new Some((Object)DataTypes.LongType);
        } else {
            scala.collection.immutable.Map<String, SolrFieldMeta> fieldMetaMap = SolrQuerySupport$.MODULE$.getFieldTypes((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{splitFieldName}))), SolrRDD$.MODULE$.randomReplicaLocation(solrShard));
            Option solrFieldMeta = fieldMetaMap.get((Object)splitFieldName);
            if (solrFieldMeta.isDefined()) {
                Option<String> fieldTypeClass = ((SolrFieldMeta)solrFieldMeta.get()).fieldTypeClass();
                fieldDataType = fieldTypeClass.isDefined() ? SolrQuerySupport$.MODULE$.SOLR_DATA_TYPES().get(fieldTypeClass.get()) : new Some((Object)DataTypes.StringType);
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn(new StringBuilder().append((Object)"No field metadata found for ").append((Object)splitFieldName).append((Object)", assuming it is a String!").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                fieldDataType = new Some((Object)DataTypes.StringType);
            }
        }
        if (fieldDataType.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Cannot determine DataType for split field ").append((Object)splitFieldName).toString());
        }
        return this.getSplits((DataType)fieldDataType.get(), splitFieldName, splitsPerShard, query, solrShard);
    }

    public List<ShardSplit<?>> getSplits(DataType fd, String sF, int sPS, SolrQuery query, SolrShard shard) {
        block6: {
            None$ splitStrategy;
            block5: {
                block4: {
                    splitStrategy = None$.MODULE$;
                    if (!fd.equals(DataTypes.LongType) && !fd.equals(DataTypes.IntegerType)) break block4;
                    splitStrategy = new Some((Object)new NumberFieldShardSplitStrategy());
                    break block5;
                }
                if (!fd.equals(DataTypes.StringType)) break block6;
                splitStrategy = new Some((Object)new StringFieldShardSplitStrategy());
            }
            if (splitStrategy.isDefined()) {
                return JavaConversions$.MODULE$.asScalaBuffer(((ShardSplitStrategy)splitStrategy.get()).getSplits(SolrRDD$.MODULE$.randomReplicaLocation(shard), query, sF, sPS)).toList();
            }
            throw new IllegalArgumentException(new StringBuilder().append((Object)"No split strategy found for DataType '").append((Object)fd).append((Object)"'").toString());
        }
        throw new IllegalArgumentException("Can only split shards on fields of type: long, int or String!");
    }

    private SolrSupport$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

