/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.solr;

import com.lucidworks.spark.query.sql.SolrSQLSupport;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.spark.sql.solr.TablePermissionChecker;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class SolrSparkSession$
implements LazyLogging,
Serializable {
    public static final SolrSparkSession$ MODULE$;
    private final Pattern solrSubQueryPattern;
    private final Pattern solrQueryPattern;
    private final Pattern solrCollectionInSqlPattern;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SolrSparkSession$();
    }

    private Logger logger$lzycompute() {
        SolrSparkSession$ solrSparkSession$ = this;
        synchronized (solrSparkSession$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Pattern solrSubQueryPattern() {
        return this.solrSubQueryPattern;
    }

    public Pattern solrQueryPattern() {
        return this.solrQueryPattern;
    }

    public Pattern solrCollectionInSqlPattern() {
        return this.solrCollectionInSqlPattern;
    }

    public boolean hasSolrAlias(String sqlText) {
        return sqlText.toLowerCase().indexOf(") as solr") != -1;
    }

    public Option<scala.collection.immutable.Map<String, String>> parseColumns(String sqlText) {
        Some some;
        try {
            Map<String, String> cols = SolrSQLSupport.parseColumns(sqlText);
            if (cols.isEmpty()) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringBuilder().append((Object)"No columns found for sub-query [").append((Object)sqlText).append((Object)"], cannot push down into Solr").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return None$.MODULE$;
            }
            some = new Some((Object)JavaConversions$.MODULE$.mapAsScalaMap(cols).toMap(Predef$.MODULE$.$conforms()));
        }
        catch (Exception exception) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn(new StringBuilder().append((Object)"Failed to parse columns for sub-query [").append((Object)sqlText).append((Object)"] due to: ").append((Object)exception).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            some = None$.MODULE$;
        }
        return some;
    }

    public Option<String> findSolrCollectionNameInSql(String sqlText) {
        BoxedUnit boxedUnit;
        Matcher collectionIdMatcher = this.solrCollectionInSqlPattern().matcher(sqlText);
        if (collectionIdMatcher.find()) {
            return new Some((Object)collectionIdMatcher.group(1));
        }
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No push-down to Solr! Cannot determine collection name from Solr SQL query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sqlText})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return None$.MODULE$;
    }

    public String getTempTableName(String sqlText, String tableName) {
        String md5 = DigestUtils.md5Hex((String)sqlText);
        return new StringBuilder().append((Object)tableName).append((Object)"_sspd_").append((Object)md5).toString();
    }

    public Option<TablePermissionChecker> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SolrSparkSession$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.solrSubQueryPattern = Pattern.compile("\\((SELECT .*?\\)) as solr", 2);
        this.solrQueryPattern = Pattern.compile("\\s_query_\\s?=\\s?'.*?'\\s?");
        this.solrCollectionInSqlPattern = Pattern.compile("\\sfrom\\s([\\w\\-\\.]+)\\s?", 2);
    }
}

