/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.solr;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.solr.SecuredResource;
import org.apache.spark.sql.solr.SolrSessionCatalog;
import org.apache.spark.sql.solr.SolrSparkSession$;
import org.apache.spark.sql.solr.TablePermissionChecker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u0001\u0003\u00015\u0011\u0001cU8meN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u000b\u0005\r!\u0011\u0001B:pYJT!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0005\u0013\t\tBA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002\u001455\tAC\u0003\u0002\u0016-\u0005a1oY1mC2|wmZ5oO*\u0011q\u0003G\u0001\tif\u0004Xm]1gK*\t\u0011$A\u0002d_6L!a\u0007\u000b\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005a1\u000f]1sW\u000e{g\u000e^3yiB\u0011q\u0004I\u0007\u0002\r%\u0011\u0011E\u0002\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\tG\u0001\u0011)\u0019!C\u0001I\u000511m\u001c8gS\u001e,\u0012!\n\t\u0005M1zsF\u0004\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003&\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u00121!T1q\u0015\tY\u0003\u0006\u0005\u0002'a%\u0011\u0011G\f\u0002\u0007'R\u0014\u0018N\\4\t\u0011M\u0002!\u0011!Q\u0001\n\u0015\nqaY8oM&<\u0007\u0005\u0003\u00056\u0001\t\u0015\r\u0011\"\u00017\u0003Y!\u0018M\u00197f!\u0016\u0014X.[:tS>t7\t[3dW\u0016\u0014X#A\u001c\u0011\u0007\u001dB$(\u0003\u0002:Q\t1q\n\u001d;j_:\u0004\"a\u000f\u001f\u000e\u0003\tI!!\u0010\u0002\u0003-Q\u000b'\r\\3QKJl\u0017n]:j_:\u001c\u0005.Z2lKJD\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IaN\u0001\u0018i\u0006\u0014G.\u001a)fe6L7o]5p]\u000eCWmY6fe\u0002BQ!\u0011\u0001\u0005\u0002\t\u000ba\u0001P5oSRtD\u0003B\"E\u000b\u001a\u0003\"a\u000f\u0001\t\u000bu\u0001\u0005\u0019\u0001\u0010\t\u000b\r\u0002\u0005\u0019A\u0013\t\u000fU\u0002\u0005\u0013!a\u0001o!9\u0001\n\u0001a\u0001\n\u0003!\u0013\u0001E2bG\",GmU)M#V,'/[3t\u0011\u001dQ\u0005\u00011A\u0005\u0002-\u000bAcY1dQ\u0016$7+\u0015'Rk\u0016\u0014\u0018.Z:`I\u0015\fHC\u0001'P!\t9S*\u0003\u0002OQ\t!QK\\5u\u0011\u001d\u0001\u0016*!AA\u0002\u0015\n1\u0001\u001f\u00132\u0011\u0019\u0011\u0006\u0001)Q\u0005K\u0005\t2-Y2iK\u0012\u001c\u0016\u000bT)vKJLWm\u001d\u0011\t\u000fQ\u0003\u0001\u0019!C\u0001+\u0006yA/\u00192mKR{'+Z:pkJ\u001cW-F\u0001W!\u00111CfL,\u0011\u0005mB\u0016BA-\u0003\u0005=\u0019VmY;sK\u0012\u0014Vm]8ve\u000e,\u0007bB.\u0001\u0001\u0004%\t\u0001X\u0001\u0014i\u0006\u0014G.\u001a+p%\u0016\u001cx.\u001e:dK~#S-\u001d\u000b\u0003\u0019vCq\u0001\u0015.\u0002\u0002\u0003\u0007a\u000b\u0003\u0004`\u0001\u0001\u0006KAV\u0001\u0011i\u0006\u0014G.\u001a+p%\u0016\u001cx.\u001e:dK\u0002B\u0001\"\u0019\u0001\t\u0006\u0004%\tEY\u0001\bG\u0006$\u0018\r\\8h+\u0005\u0019\u0007CA\u001ee\u0013\t)'A\u0001\nT_2\u00148+Z:tS>t7)\u0019;bY><\u0007\u0002C4\u0001\u0011\u0003\u0005\u000b\u0015B2\u0002\u0011\r\fG/\u00197pO\u0002BQ!\u0002\u0001\u0005B%$\"A\u001b?\u0011\u0005-LhB\u00017x\u001d\tigO\u0004\u0002ok:\u0011q\u000e\u001e\b\u0003aNl\u0011!\u001d\u0006\u0003e2\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002y\t\u00059\u0001/Y2lC\u001e,\u0017B\u0001>|\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002y\t!)Q\u0010\u001ba\u0001_\u000591/\u001d7UKb$\bBB@\u0001\t\u0003\t\t!A\bdY\u0016\f'/U;fef\u001c\u0015m\u00195f)\u0005a\u0005bBA\u0003\u0001\u0011\u0005\u0011qA\u0001\u0010G\",7m\u001b*fC\u0012\f5mY3tgR)A*!\u0003\u0002\u000e!9\u00111BA\u0002\u0001\u0004y\u0013\u0001\u0003:fg>,(oY3\t\u000f\u0005=\u00111\u0001a\u0001_\u0005a!/Z:pkJ\u001cW\rV=qK\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011\u0001E2iK\u000e\\wK]5uK\u0006\u001b7-Z:t)\u0015a\u0015qCA\r\u0011\u001d\tY!!\u0005A\u0002=Bq!a\u0004\u0002\u0012\u0001\u0007q\u0006C\u0004\u0002\u001e\u0001!\t!a\b\u0002\u001dA\u0014xnY3tgN\u000bHn\u0015;niR\u0019q&!\t\t\ru\fY\u00021\u00010\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\t!\u0003\u001d:pG\u0016\u001c8\u000fU;tQ\u0012{wO\\*rYR)q&!\u000b\u0002,!1Q0a\tA\u0002=B\u0001\"!\f\u0002$\u0001\u0007\u0011qF\u0001\b[\u0006$8\r[3s!\u0011\t\t$a\u0010\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tQA]3hKbTA!!\u000f\u0002<\u0005!Q\u000f^5m\u0015\t\ti$\u0001\u0003kCZ\f\u0017\u0002BA!\u0003g\u0011q!T1uG\",'\u000fC\u0004\u0002F\u0001!\t!a\u0012\u0002\u0017%\u001c8k\u001c7s#V,'/\u001f\u000b\u0005\u0003\u0013\nY\u0005E\u0002(q=Ba!`A\"\u0001\u0004y\u0003bBA(\u0001\u0011\u0005\u0011\u0011K\u0001\u001ae\u0016<\u0017n\u001d;feN{GN\u001d)vg\"$wn\u001e8Rk\u0016\u0014\u0018\u0010F\u0004M\u0003'\n9&!\u0017\t\u000f\u0005U\u0013Q\na\u0001_\u0005iA/Z7q)\u0006\u0014G.\u001a(b[\u0016Da!`A'\u0001\u0004y\u0003bBA.\u0003\u001b\u0002\raL\u0001\ni\u0006\u0014G.\u001a(b[\u0016<q!a\u0018\u0003\u0011\u0003\t\t'\u0001\tT_2\u00148\u000b]1sWN+7o]5p]B\u00191(a\u0019\u0007\r\u0005\u0011\u0001\u0012AA3'\u001d\t\u0019'a\u001a\u0013\u0003[\u00022aJA5\u0013\r\tY\u0007\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0007\u001d\ny'C\u0002\u0002r!\u0012AbU3sS\u0006d\u0017N_1cY\u0016Dq!QA2\t\u0003\t)\b\u0006\u0002\u0002b!Q\u0011\u0011PA2\u0005\u0004%\t!a\u001f\u0002'M|GN]*vEF+XM]=QCR$XM\u001d8\u0016\u0005\u0005u\u0004\u0003BA\u0019\u0003\u007fJA!!!\u00024\t9\u0001+\u0019;uKJt\u0007\"CAC\u0003G\u0002\u000b\u0011BA?\u0003Q\u0019x\u000e\u001c:Tk\n\fV/\u001a:z!\u0006$H/\u001a:oA!Q\u0011\u0011RA2\u0005\u0004%\t!a\u001f\u0002!M|GN])vKJL\b+\u0019;uKJt\u0007\"CAG\u0003G\u0002\u000b\u0011BA?\u0003E\u0019x\u000e\u001c:Rk\u0016\u0014\u0018\u0010U1ui\u0016\u0014h\u000e\t\u0005\u000b\u0003#\u000b\u0019G1A\u0005\u0002\u0005m\u0014AG:pYJ\u001cu\u000e\u001c7fGRLwN\\%o'Fd\u0007+\u0019;uKJt\u0007\"CAK\u0003G\u0002\u000b\u0011BA?\u0003m\u0019x\u000e\u001c:D_2dWm\u0019;j_:LenU9m!\u0006$H/\u001a:oA!A\u0011\u0011TA2\t\u0003\tY*\u0001\u0007iCN\u001cv\u000e\u001c:BY&\f7\u000f\u0006\u0003\u0002\u001e\u0006\r\u0006cA\u0014\u0002 &\u0019\u0011\u0011\u0015\u0015\u0003\u000f\t{w\u000e\\3b]\"1Q0a&A\u0002=B\u0001\"a*\u0002d\u0011\u0005\u0011\u0011V\u0001\ra\u0006\u00148/Z\"pYVlgn\u001d\u000b\u0005\u0003W\u000bi\u000bE\u0002(q\u0015Ba!`AS\u0001\u0004y\u0003\u0002CAY\u0003G\"\t!a-\u00027\u0019Lg\u000eZ*pYJ\u001cu\u000e\u001c7fGRLwN\u001c(b[\u0016LenU9m)\u0011\tI%!.\t\ru\fy\u000b1\u00010\u0011!\tI,a\u0019\u0005\u0002\u0005m\u0016\u0001E4fiR+W\u000e\u001d+bE2,g*Y7f)\u0015y\u0013QXA`\u0011\u0019i\u0018q\u0017a\u0001_!9\u00111LA\\\u0001\u0004y\u0003BCAb\u0003G\n\n\u0011\"\u0001\u0002F\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a2+\u0007]\nIm\u000b\u0002\u0002LB!\u0011QZAl\u001b\t\tyM\u0003\u0003\u0002R\u0006M\u0017!C;oG\",7m[3e\u0015\r\t)\u000eK\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAm\u0003\u001f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\ti.a\u0019\u0002\u0002\u0013%\u0011q\\\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002bB!\u00111]Au\u001b\t\t)O\u0003\u0003\u0002h\u0006m\u0012\u0001\u00027b]\u001eLA!a;\u0002f\n1qJ\u00196fGR\u0004")
public class SolrSparkSession
extends SparkSession
implements LazyLogging {
    private final scala.collection.immutable.Map<String, String> config;
    private final Option<TablePermissionChecker> tablePermissionChecker;
    private scala.collection.immutable.Map<String, String> cachedSQLQueries;
    private scala.collection.immutable.Map<String, SecuredResource> tableToResource;
    private SolrSessionCatalog catalog;
    private final Logger logger;
    private volatile byte bitmap$0;

    public static Option<TablePermissionChecker> $lessinit$greater$default$3() {
        return SolrSparkSession$.MODULE$.$lessinit$greater$default$3();
    }

    public static String getTempTableName(String string, String string2) {
        return SolrSparkSession$.MODULE$.getTempTableName(string, string2);
    }

    public static Option<String> findSolrCollectionNameInSql(String string) {
        return SolrSparkSession$.MODULE$.findSolrCollectionNameInSql(string);
    }

    public static Option<scala.collection.immutable.Map<String, String>> parseColumns(String string) {
        return SolrSparkSession$.MODULE$.parseColumns(string);
    }

    public static boolean hasSolrAlias(String string) {
        return SolrSparkSession$.MODULE$.hasSolrAlias(string);
    }

    public static Pattern solrCollectionInSqlPattern() {
        return SolrSparkSession$.MODULE$.solrCollectionInSqlPattern();
    }

    public static Pattern solrQueryPattern() {
        return SolrSparkSession$.MODULE$.solrQueryPattern();
    }

    public static Pattern solrSubQueryPattern() {
        return SolrSparkSession$.MODULE$.solrSubQueryPattern();
    }

    private SolrSessionCatalog catalog$lzycompute() {
        SolrSparkSession solrSparkSession = this;
        synchronized (solrSparkSession) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.catalog = new SolrSessionCatalog(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.catalog;
        }
    }

    private Logger logger$lzycompute() {
        SolrSparkSession solrSparkSession = this;
        synchronized (solrSparkSession) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public scala.collection.immutable.Map<String, String> config() {
        return this.config;
    }

    public Option<TablePermissionChecker> tablePermissionChecker() {
        return this.tablePermissionChecker;
    }

    public scala.collection.immutable.Map<String, String> cachedSQLQueries() {
        return this.cachedSQLQueries;
    }

    public void cachedSQLQueries_$eq(scala.collection.immutable.Map<String, String> x$1) {
        this.cachedSQLQueries = x$1;
    }

    public scala.collection.immutable.Map<String, SecuredResource> tableToResource() {
        return this.tableToResource;
    }

    public void tableToResource_$eq(scala.collection.immutable.Map<String, SecuredResource> x$1) {
        this.tableToResource = x$1;
    }

    public SolrSessionCatalog catalog() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.catalog$lzycompute() : this.catalog;
    }

    public Dataset<Row> sql(String sqlText) {
        String modifiedSqlText = this.processSqlStmt(sqlText);
        return super.sql(modifiedSqlText);
    }

    public void clearQueryCache() {
        this.cachedSQLQueries_$eq((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void checkReadAccess(String resource, String resourceType) {
        if (this.tablePermissionChecker().isEmpty()) {
            return;
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        if (ugi == null) {
            throw new AccessControlException("No UserGroupInformation found for current user verify access!");
        }
        String cacheKey = new StringBuilder().append((Object)resourceType).append((Object)".").append((Object)resource).toString();
        SecuredResource securedResource = (SecuredResource)this.tableToResource().getOrElse((Object)cacheKey, (Function0)new Serializable(this, resource, resourceType){
            public static final long serialVersionUID = 0L;
            private final String resource$1;
            private final String resourceType$1;

            public final SecuredResource apply() {
                return new SecuredResource(this.resource$1, this.resourceType$1);
            }
            {
                this.resource$1 = resource$1;
                this.resourceType$1 = resourceType$1;
            }
        });
        ((TablePermissionChecker)this.tablePermissionChecker().get()).checkQueryAccess(this, ugi, securedResource);
        this.logInfo((Function0)new Serializable(this, resource, resourceType, ugi){
            public static final long serialVersionUID = 0L;
            private final String resource$1;
            private final String resourceType$1;
            private final UserGroupInformation ugi$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " has read access to ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ugi$1.getUserName(), this.resourceType$1, this.resource$1}));
            }
            {
                this.resource$1 = resource$1;
                this.resourceType$1 = resourceType$1;
                this.ugi$1 = ugi$1;
            }
        });
    }

    public void checkWriteAccess(String resource, String resourceType) {
        if (this.tablePermissionChecker().isEmpty()) {
            return;
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        if (ugi == null) {
            throw new AccessControlException("No UserGroupInformation found for current user verify access!");
        }
        String cacheKey = new StringBuilder().append((Object)resourceType).append((Object)".").append((Object)resource).toString();
        SecuredResource securedResource = (SecuredResource)this.tableToResource().getOrElse((Object)cacheKey, (Function0)new Serializable(this, resource, resourceType){
            public static final long serialVersionUID = 0L;
            private final String resource$2;
            private final String resourceType$2;

            public final SecuredResource apply() {
                return new SecuredResource(this.resource$2, this.resourceType$2);
            }
            {
                this.resource$2 = resource$2;
                this.resourceType$2 = resourceType$2;
            }
        });
        ((TablePermissionChecker)this.tablePermissionChecker().get()).checkWriteAccess(this, ugi, securedResource);
        this.logInfo((Function0)new Serializable(this, resource, resourceType, ugi){
            public static final long serialVersionUID = 0L;
            private final String resource$2;
            private final String resourceType$2;
            private final UserGroupInformation ugi$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User ", " has write access to ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ugi$2.getUserName(), this.resourceType$2, this.resource$2}));
            }
            {
                this.resource$2 = resource$2;
                this.resourceType$2 = resourceType$2;
                this.ugi$2 = ugi$2;
            }
        });
    }

    public String processSqlStmt(String sqlText) {
        Matcher matcher = SolrSparkSession$.MODULE$.solrSubQueryPattern().matcher(sqlText);
        if (matcher.find()) {
            return this.processPushDownSql(sqlText, matcher);
        }
        Option<String> maybeSolrCollectionId = this.isSolrQuery(sqlText);
        if (maybeSolrCollectionId.isDefined()) {
            String collectionId = (String)maybeSolrCollectionId.get();
            this.checkReadAccess(collectionId, "solr");
            String cacheKey = sqlText.toLowerCase(Locale.US);
            Option maybeCachedSqlQuery = this.cachedSQLQueries().get((Object)cacheKey);
            if (maybeCachedSqlQuery.isDefined()) {
                return (String)maybeCachedSqlQuery.get();
            }
            String tempTableName = SolrSparkSession$.MODULE$.getTempTableName(sqlText.toLowerCase(Locale.US), collectionId);
            this.logInfo((Function0)new Serializable(this, sqlText, collectionId, tempTableName){
                public static final long serialVersionUID = 0L;
                private final String sqlText$1;
                private final String collectionId$1;
                private final String tempTableName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending Solr SQL query [", "}] directly to Solr collection ", " and saving result into temp table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sqlText$1, this.collectionId$1, this.tempTableName$1}));
                }
                {
                    this.sqlText$1 = sqlText$1;
                    this.collectionId$1 = collectionId$1;
                    this.tempTableName$1 = tempTableName$1;
                }
            });
            scala.collection.immutable.Map solrSqlOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collection"), (Object)collectionId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sql"), (Object)sqlText)}));
            Dataset solrSqlDF = this.read().format("solr").options((Map)solrSqlOpts).load();
            solrSqlDF.registerTempTable(tempTableName);
            String selectAllFromTemp = new StringBuilder().append((Object)"select * from ").append((Object)tempTableName).toString();
            this.cachedSQLQueries_$eq((scala.collection.immutable.Map<String, String>)this.cachedSQLQueries().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cacheKey), (Object)selectAllFromTemp)));
            return selectAllFromTemp;
        }
        Matcher tableNameMatcher = SolrSparkSession$.MODULE$.solrCollectionInSqlPattern().matcher(sqlText);
        while (tableNameMatcher.find()) {
            this.checkReadAccess(tableNameMatcher.group(1), "table");
        }
        return sqlText;
    }

    public String processPushDownSql(String sqlText, Matcher matcher) {
        String string;
        Object object = new Object();
        try {
            String subQueryMatch = matcher.group();
            String solrQueryStmt = subQueryMatch.substring(1, subQueryMatch.length() - 9).trim();
            if (solrQueryStmt.isEmpty()) {
                return sqlText;
            }
            String cacheKey = subQueryMatch.toLowerCase(Locale.US);
            Option cachedPushdownQuery = this.cachedSQLQueries().get((Object)cacheKey);
            if (cachedPushdownQuery.isDefined()) {
                String replaceSql = matcher.replaceFirst((String)cachedPushdownQuery.get());
                this.logInfo((Function0)new Serializable(this, sqlText, replaceSql){
                    public static final long serialVersionUID = 0L;
                    private final String sqlText$2;
                    private final String replaceSql$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found push-down in cache, re-wrote SQL statement as [", "] to use cached push-down sub-query; original query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replaceSql$1, this.sqlText$2}));
                    }
                    {
                        this.sqlText$2 = sqlText$2;
                        this.replaceSql$1 = replaceSql$1;
                    }
                });
                return replaceSql;
            }
            scala.collection.immutable.Map cols = (scala.collection.immutable.Map)SolrSparkSession$.MODULE$.parseColumns(sqlText).getOrElse((Function0)new Serializable(this, sqlText, object){
                public static final long serialVersionUID = 0L;
                private final String sqlText$2;
                private final Object nonLocalReturnKey1$1;

                public final Nothing$ apply() {
                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)this.sqlText$2);
                }
                {
                    this.sqlText$2 = sqlText$2;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            this.logDebug((Function0)new Serializable(this, cols){
                public static final long serialVersionUID = 0L;
                private final scala.collection.immutable.Map cols$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Parsed columns: ").append((Object)this.cols$1).toString();
                }
                {
                    this.cols$1 = cols$1;
                }
            });
            this.logInfo((Function0)new Serializable(this, solrQueryStmt){
                public static final long serialVersionUID = 0L;
                private final String solrQueryStmt$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to push-down sub-query into Solr: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.solrQueryStmt$1}));
                }
                {
                    this.solrQueryStmt$1 = solrQueryStmt$1;
                }
            });
            String tableName = (String)SolrSparkSession$.MODULE$.findSolrCollectionNameInSql(solrQueryStmt.replaceAll("\\s+", " ")).getOrElse((Function0)new Serializable(this, sqlText, object){
                public static final long serialVersionUID = 0L;
                private final String sqlText$2;
                private final Object nonLocalReturnKey1$1;

                public final Nothing$ apply() {
                    throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)this.sqlText$2);
                }
                {
                    this.sqlText$2 = sqlText$2;
                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                }
            });
            this.checkReadAccess(tableName, "solr");
            this.logInfo((Function0)new Serializable(this, solrQueryStmt, tableName){
                public static final long serialVersionUID = 0L;
                private final String solrQueryStmt$1;
                private final String tableName$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Extracted table name '", "' from sub-query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableName$1, this.solrQueryStmt$1}));
                }
                {
                    this.solrQueryStmt$1 = solrQueryStmt$1;
                    this.tableName$1 = tableName$1;
                }
            });
            String tempTableName = SolrSparkSession$.MODULE$.getTempTableName(cacheKey, tableName);
            try {
                this.registerSolrPushdownQuery(tempTableName, solrQueryStmt, tableName);
                String newCachedPushdownQuery = new StringBuilder().append((Object)"(SELECT * FROM ").append((Object)tempTableName).append((Object)") as solr").toString();
                this.cachedSQLQueries_$eq((scala.collection.immutable.Map<String, String>)this.cachedSQLQueries().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)cacheKey), (Object)newCachedPushdownQuery)));
                String rewrittenSql = matcher.replaceFirst(newCachedPushdownQuery);
                this.logInfo((Function0)new Serializable(this, sqlText, rewrittenSql){
                    public static final long serialVersionUID = 0L;
                    private final String sqlText$2;
                    private final String rewrittenSql$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Re-wrote SQL statement as [", "] to use cached push-down sub-query; original query: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rewrittenSql$1, this.sqlText$2}));
                    }
                    {
                        this.sqlText$2 = sqlText$2;
                        this.rewrittenSql$1 = rewrittenSql$1;
                    }
                });
                return rewrittenSql;
            }
            catch (Exception exception) {
                this.logError((Function0)new Serializable(this, solrQueryStmt, exception){
                    public static final long serialVersionUID = 0L;
                    private final String solrQueryStmt$1;
                    private final Exception exc$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Failed to push-down sub-query [").append((Object)this.solrQueryStmt$1).append((Object)"] to Solr due to: ").append((Object)this.exc$1).toString();
                    }
                    {
                        this.solrQueryStmt$1 = solrQueryStmt$1;
                        this.exc$1 = exc$1;
                    }
                });
                string = sqlText;
            }
        }
        catch (NonLocalReturnControl nonLocalReturnControl) {
            if (nonLocalReturnControl.key() == object) {
                string = (String)nonLocalReturnControl.value();
            }
            throw nonLocalReturnControl;
        }
        return string;
    }

    public Option<String> isSolrQuery(String sqlText) {
        String sqlTextWs = sqlText.replaceAll("\\s+", " ");
        Matcher solrQueryMatcher = SolrSparkSession$.MODULE$.solrQueryPattern().matcher(sqlTextWs);
        if (solrQueryMatcher.find()) {
            return SolrSparkSession$.MODULE$.findSolrCollectionNameInSql(sqlTextWs);
        }
        return None$.MODULE$;
    }

    public void registerSolrPushdownQuery(String tempTableName, String sqlText, String tableName) {
        ObjectRef opts = ObjectRef.create((Object)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"request_handler"), (Object)"/sql"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sql"), (Object)sqlText), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"collection"), (Object)tableName)}))));
        Option zkhost = this.config().get((Object)"zkhost");
        if (zkhost.isDefined()) {
            opts.elem = ((scala.collection.immutable.Map)opts.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zkhost"), zkhost.get()));
        }
        this.logInfo((Function0)new Serializable(this, tempTableName, opts){
            public static final long serialVersionUID = 0L;
            private final String tempTableName$2;
            private final ObjectRef opts$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registering temp table '", "' for Solr push-down SQL using options ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tempTableName$2, (scala.collection.immutable.Map)this.opts$1.elem}));
            }
            {
                this.tempTableName$2 = tempTableName$2;
                this.opts$1 = opts$1;
            }
        });
        this.read().format("solr").options((Map)((scala.collection.immutable.Map)opts.elem)).load().registerTempTable(tempTableName);
    }

    public SolrSparkSession(SparkContext sparkContext, scala.collection.immutable.Map<String, String> config, Option<TablePermissionChecker> tablePermissionChecker) {
        this.config = config;
        this.tablePermissionChecker = tablePermissionChecker;
        super(sparkContext);
        LazyLogging.class.$init$((LazyLogging)this);
        this.cachedSQLQueries = Predef$.MODULE$.Map().empty();
        this.tableToResource = Predef$.MODULE$.Map().empty();
    }
}

