/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.InputStreamPacket;
import org.spongycastle.bcpg.SymmetricEncIntegrityPacket;
import org.spongycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.spongycastle.openpgp.PGPDataValidationException;
import org.spongycastle.openpgp.PGPEncryptedData;
import org.spongycastle.openpgp.PGPException;
import org.spongycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.spongycastle.openpgp.operator.PGPDataDecryptor;
import org.spongycastle.util.io.TeeInputStream;

public class PGPPBEEncryptedData
extends PGPEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    public int getSymmetricAlgorithm(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] key = dataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), key, this.keyData.getSecKeyData());
        return sessionData[0];
    }

    public InputStream getDataStream(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        try {
            boolean zeroesCheckPassed;
            int keyAlgorithm = this.keyData.getEncAlgorithm();
            byte[] key = dataDecryptorFactory.makeKeyFromPassPhrase(keyAlgorithm, this.keyData.getS2K());
            boolean withIntegrityPacket = this.encData instanceof SymmetricEncIntegrityPacket;
            byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), key, this.keyData.getSecKeyData());
            byte[] sessionKey = new byte[sessionData.length - 1];
            System.arraycopy(sessionData, 1, sessionKey, 0, sessionKey.length);
            PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(withIntegrityPacket, sessionData[0] & 0xFF, sessionKey);
            this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(this.encData.getInputStream()));
            if (withIntegrityPacket) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                this.integrityCalculator = dataDecryptor.getIntegrityCalculator();
                this.encStream = new TeeInputStream((InputStream)this.truncStream, this.integrityCalculator.getOutputStream());
            }
            byte[] iv = new byte[dataDecryptor.getBlockSize()];
            for (int i = 0; i != iv.length; ++i) {
                int ch = this.encStream.read();
                if (ch < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                iv[i] = (byte)ch;
            }
            int v1 = this.encStream.read();
            int v2 = this.encStream.read();
            if (v1 < 0 || v2 < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean repeatCheckPassed = iv[iv.length - 2] == (byte)v1 && iv[iv.length - 1] == (byte)v2;
            boolean bl = zeroesCheckPassed = v1 == 0 && v2 == 0;
            if (!repeatCheckPassed && !zeroesCheckPassed) {
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }
}

