/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.BCPGKey;
import org.spongycastle.bcpg.BCPGObject;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.bcpg.MPInteger;

public class DSAPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger p;
    MPInteger q;
    MPInteger g;
    MPInteger y;

    public DSAPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.p = new MPInteger(in);
        this.q = new MPInteger(in);
        this.g = new MPInteger(in);
        this.y = new MPInteger(in);
    }

    public DSAPublicBCPGKey(BigInteger p, BigInteger q, BigInteger g, BigInteger y) {
        this.p = new MPInteger(p);
        this.q = new MPInteger(q);
        this.g = new MPInteger(g);
        this.y = new MPInteger(y);
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.p);
        out.writeObject(this.q);
        out.writeObject(this.g);
        out.writeObject(this.y);
    }

    public BigInteger getG() {
        return this.g.getValue();
    }

    public BigInteger getP() {
        return this.p.getValue();
    }

    public BigInteger getQ() {
        return this.q.getValue();
    }

    public BigInteger getY() {
        return this.y.getValue();
    }
}

