/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import org.spongycastle.bcpg.BCPGInputStream;
import org.spongycastle.bcpg.BCPGKey;
import org.spongycastle.bcpg.BCPGObject;
import org.spongycastle.bcpg.BCPGOutputStream;
import org.spongycastle.bcpg.MPInteger;

public class RSAPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger n;
    MPInteger e;

    public RSAPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.n = new MPInteger(in);
        this.e = new MPInteger(in);
    }

    public RSAPublicBCPGKey(BigInteger n, BigInteger e) {
        this.n = new MPInteger(n);
        this.e = new MPInteger(e);
    }

    public BigInteger getPublicExponent() {
        return this.e.getValue();
    }

    public BigInteger getModulus() {
        return this.n.getValue();
    }

    public String getFormat() {
        return "PGP";
    }

    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.n);
        out.writeObject(this.e);
    }
}

