/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.spongycastle.bcpg.SignatureSubpacket;
import org.spongycastle.bcpg.sig.EmbeddedSignature;
import org.spongycastle.bcpg.sig.Exportable;
import org.spongycastle.bcpg.sig.Features;
import org.spongycastle.bcpg.sig.IssuerKeyID;
import org.spongycastle.bcpg.sig.KeyExpirationTime;
import org.spongycastle.bcpg.sig.KeyFlags;
import org.spongycastle.bcpg.sig.NotationData;
import org.spongycastle.bcpg.sig.PreferredAlgorithms;
import org.spongycastle.bcpg.sig.PrimaryUserID;
import org.spongycastle.bcpg.sig.Revocable;
import org.spongycastle.bcpg.sig.RevocationKey;
import org.spongycastle.bcpg.sig.RevocationReason;
import org.spongycastle.bcpg.sig.SignatureCreationTime;
import org.spongycastle.bcpg.sig.SignatureExpirationTime;
import org.spongycastle.bcpg.sig.SignerUserID;
import org.spongycastle.bcpg.sig.TrustSignature;
import org.spongycastle.openpgp.PGPSignature;
import org.spongycastle.openpgp.PGPSignatureSubpacketVector;

public class PGPSignatureSubpacketGenerator {
    List list = new ArrayList();

    public void setRevocable(boolean isCritical, boolean isRevocable) {
        this.list.add(new Revocable(isCritical, isRevocable));
    }

    public void setExportable(boolean isCritical, boolean isExportable) {
        this.list.add(new Exportable(isCritical, isExportable));
    }

    public void setFeature(boolean isCritical, byte feature) {
        this.list.add(new Features(isCritical, feature));
    }

    public void setTrust(boolean isCritical, int depth, int trustAmount) {
        this.list.add(new TrustSignature(isCritical, depth, trustAmount));
    }

    public void setKeyExpirationTime(boolean isCritical, long seconds) {
        this.list.add(new KeyExpirationTime(isCritical, seconds));
    }

    public void setSignatureExpirationTime(boolean isCritical, long seconds) {
        this.list.add(new SignatureExpirationTime(isCritical, seconds));
    }

    public void setSignatureCreationTime(boolean isCritical, Date date) {
        this.list.add(new SignatureCreationTime(isCritical, date));
    }

    public void setPreferredHashAlgorithms(boolean isCritical, int[] algorithms) {
        this.list.add(new PreferredAlgorithms(21, isCritical, algorithms));
    }

    public void setPreferredSymmetricAlgorithms(boolean isCritical, int[] algorithms) {
        this.list.add(new PreferredAlgorithms(11, isCritical, algorithms));
    }

    public void setPreferredCompressionAlgorithms(boolean isCritical, int[] algorithms) {
        this.list.add(new PreferredAlgorithms(22, isCritical, algorithms));
    }

    public void setKeyFlags(boolean isCritical, int flags) {
        this.list.add(new KeyFlags(isCritical, flags));
    }

    public void setSignerUserID(boolean isCritical, String userID) {
        if (userID == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.list.add(new SignerUserID(isCritical, userID));
    }

    public void setSignerUserID(boolean isCritical, byte[] rawUserID) {
        if (rawUserID == null) {
            throw new IllegalArgumentException("attempt to set null SignerUserID");
        }
        this.list.add(new SignerUserID(isCritical, false, rawUserID));
    }

    public void setEmbeddedSignature(boolean isCritical, PGPSignature pgpSignature) throws IOException {
        byte[] sig = pgpSignature.getEncoded();
        byte[] data = sig.length - 1 > 256 ? new byte[sig.length - 3] : new byte[sig.length - 2];
        System.arraycopy(sig, sig.length - data.length, data, 0, data.length);
        this.list.add(new EmbeddedSignature(isCritical, false, data));
    }

    public void setPrimaryUserID(boolean isCritical, boolean isPrimaryUserID) {
        this.list.add(new PrimaryUserID(isCritical, isPrimaryUserID));
    }

    public void setNotationData(boolean isCritical, boolean isHumanReadable, String notationName, String notationValue) {
        this.list.add(new NotationData(isCritical, isHumanReadable, notationName, notationValue));
    }

    public void setRevocationReason(boolean isCritical, byte reason, String description) {
        this.list.add(new RevocationReason(isCritical, reason, description));
    }

    public void setRevocationKey(boolean isCritical, int keyAlgorithm, byte[] fingerprint) {
        this.list.add(new RevocationKey(isCritical, -128, keyAlgorithm, fingerprint));
    }

    public void setIssuerKeyID(boolean isCritical, long keyID) {
        this.list.add(new IssuerKeyID(isCritical, keyID));
    }

    public PGPSignatureSubpacketVector generate() {
        return new PGPSignatureSubpacketVector(this.list.toArray(new SignatureSubpacket[this.list.size()]));
    }
}

