/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.FakeLoad;
import com.martensigwart.fakeload.FakeLoadExecutor;
import com.martensigwart.fakeload.MaximumLoadExceededException;
import com.martensigwart.fakeload.SimulationInfrastructure;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultFakeLoadExecutor
implements FakeLoadExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultFakeLoadExecutor.class);
    private final SimulationInfrastructure infrastructure;

    public DefaultFakeLoadExecutor(SimulationInfrastructure infrastructure) {
        this.infrastructure = infrastructure;
    }

    @Override
    public void execute(FakeLoad load) {
        try {
            Future<Void> execution = this.executeAsync(load);
            execution.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Future<Void> executeAsync(FakeLoad fakeLoad) {
        log.info("FakeLoad execution started");
        log.debug("Executing {}", (Object)fakeLoad);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        return executor.submit(() -> {
            FakeLoad lastStartedLoad = null;
            try {
                for (FakeLoad load : fakeLoad) {
                    log.trace("Increasing system load by {}", (Object)load);
                    lastStartedLoad = load;
                    this.infrastructure.increaseSystemLoadBy(load);
                    Thread.sleep(load.getTimeUnit().toMillis(load.getDuration()));
                    log.trace("Decreasing system load by {}", (Object)load);
                    this.infrastructure.decreaseSystemLoadBy(load);
                }
                lastStartedLoad = null;
                log.info("FakeLoad execution finished");
                Iterator<FakeLoad> iterator = null;
                return iterator;
            }
            catch (MaximumLoadExceededException e) {
                log.warn(e.getMessage());
                throw new RuntimeException(e.getMessage());
            }
            catch (InterruptedException e) {
                log.info("FakeLoad execution cancelled");
                this.infrastructure.decreaseSystemLoadBy(lastStartedLoad);
                Void void_ = null;
                return void_;
            }
            finally {
                executor.shutdown();
            }
        });
    }

    @Override
    public void shutdown() {
        this.infrastructure.shutdown();
    }
}

