/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.AbstractLoadSimulator;
import com.martensigwart.fakeload.MemoryUnit;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiskInputSimulator
extends AbstractLoadSimulator {
    private static final Logger log = LoggerFactory.getLogger(DiskInputSimulator.class);

    protected DiskInputSimulator() {
        this("DiskInputSim");
    }

    protected DiskInputSimulator(String name) {
        super(-1L, name);
    }

    protected abstract int read(byte[] var1) throws IOException;

    @Override
    public void simulateLoad(long load) throws InterruptedException {
        byte[] bytes = new byte[load > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)load];
        try {
            long startRead = System.nanoTime();
            int bytesRead = this.read(bytes);
            long endRead = System.nanoTime();
            long duration = endRead - startRead;
            log.trace("Read {} in {} ms", (Object)MemoryUnit.mbString(bytesRead), (Object)TimeUnit.NANOSECONDS.toMillis(duration));
            long toSleep = TimeUnit.SECONDS.toMillis(1L) - TimeUnit.NANOSECONDS.toMillis(duration);
            if (toSleep > 0L) {
                log.trace("Sleeping {} ms", (Object)toSleep);
                Thread.sleep(toSleep);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
            e.printStackTrace();
            this.setLoad(0L);
        }
    }

    @Override
    public boolean waitConditionFulfilled() {
        return this.isZeroLoad();
    }

    @Override
    protected String prettyFormat(long load) {
        return MemoryUnit.mbString(load) + " per second";
    }
}

