/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.CompositeFakeLoad;
import com.martensigwart.fakeload.FakeLoad;
import com.martensigwart.fakeload.MemoryUnit;
import com.martensigwart.fakeload.SimpleFakeLoad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class FakeLoadBuilder {
    private long duration = 0L;
    private TimeUnit unit = TimeUnit.MILLISECONDS;
    private int repetitions = 1;
    private int cpuLoad = 0;
    private long memoryLoad = 0L;
    private long diskInputLoad = 0L;
    private long diskOutputLoad = 0L;
    private List<FakeLoad> innerLoads = new ArrayList<FakeLoad>();

    public FakeLoadBuilder(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = unit;
    }

    public FakeLoadBuilder() {
    }

    public FakeLoadBuilder lasting(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = unit;
        return this;
    }

    public FakeLoadBuilder repeat(int repetitions) {
        this.repetitions = repetitions;
        return this;
    }

    public FakeLoadBuilder withCpu(int cpuLoad) {
        this.cpuLoad = cpuLoad;
        return this;
    }

    public FakeLoadBuilder withMemory(long memoryLoad, MemoryUnit unit) {
        this.memoryLoad = unit.toBytes(memoryLoad);
        return this;
    }

    public FakeLoadBuilder withDiskInput(long diskInput, MemoryUnit unit) {
        this.diskInputLoad = unit.toBytes(diskInput);
        return this;
    }

    public FakeLoadBuilder withDiskOutput(long diskOutput, MemoryUnit unit) {
        this.diskOutputLoad = unit.toBytes(diskOutput);
        return this;
    }

    public FakeLoadBuilder addLoad(FakeLoad load) {
        this.innerLoads.add(load);
        return this;
    }

    public FakeLoadBuilder addLoads(Collection<FakeLoad> loads) {
        this.innerLoads.addAll(loads);
        return this;
    }

    public FakeLoad build() {
        if (this.innerLoads.isEmpty()) {
            return new SimpleFakeLoad(this.duration, this.unit, this.repetitions, this.cpuLoad, this.memoryLoad, this.diskInputLoad, this.diskOutputLoad);
        }
        return new CompositeFakeLoad(new SimpleFakeLoad(this.duration, this.unit, 1, this.cpuLoad, this.memoryLoad, this.diskInputLoad, this.diskOutputLoad), this.innerLoads, this.repetitions);
    }
}

