/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.CpuSimulator;
import com.martensigwart.fakeload.DefaultFakeLoadExecutor;
import com.martensigwart.fakeload.DefaultSimulationInfrastructure;
import com.martensigwart.fakeload.FakeLoadExecutor;
import com.martensigwart.fakeload.FibonacciCpuSimulator;
import com.martensigwart.fakeload.LoadController;
import com.martensigwart.fakeload.MemorySimulator;
import com.martensigwart.fakeload.RandomAccessDiskInputSimulator;
import com.martensigwart.fakeload.RandomAccessDiskOutputSimulator;
import com.martensigwart.fakeload.SimulationInfrastructure;
import com.martensigwart.fakeload.SystemLoad;
import com.martensigwart.fakeload.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FakeLoadExecutors {
    private static final Logger log = LoggerFactory.getLogger(FakeLoadExecutors.class);
    private static final String DISK_INPUT_FILE = "input.tmp";
    private static final String DISK_OUTPUT_FILE = "output.tmp";
    private static final String DEFAULT_DISK_INPUT_PATH = System.getProperty("java.io.tmpdir") + "/" + "input.tmp";
    private static final String DEFAULT_DISK_OUTPUT_PATH = System.getProperty("java.io.tmpdir") + "/" + "output.tmp";
    private static SimulationInfrastructure defaultInfrastructure;

    public static synchronized FakeLoadExecutor newDefaultExecutor() {
        if (defaultInfrastructure == null) {
            try {
                int noOfCores = Runtime.getRuntime().availableProcessors();
                RandomAccessDiskInputSimulator diskInputSimulator = new RandomAccessDiskInputSimulator(DEFAULT_DISK_INPUT_PATH);
                RandomAccessDiskOutputSimulator diskOutputSimulator = new RandomAccessDiskOutputSimulator(DEFAULT_DISK_OUTPUT_PATH);
                MemorySimulator memorySimulator = new MemorySimulator();
                ArrayList<CpuSimulator> cpuSimulators = new ArrayList<CpuSimulator>();
                for (int i = 0; i < noOfCores; ++i) {
                    cpuSimulators.add(new FibonacciCpuSimulator());
                }
                LoadController controller = new LoadController(new SystemLoad(), cpuSimulators, memorySimulator, diskInputSimulator, diskOutputSimulator);
                ExecutorService executorService = Executors.newFixedThreadPool(noOfCores + 4, new ThreadFactoryBuilder().setDaemon(true).build());
                defaultInfrastructure = new DefaultSimulationInfrastructure(executorService, controller);
            }
            catch (IOException e) {
                log.error("File {} used for simulating disk output could not be created.", (Object)DEFAULT_DISK_OUTPUT_PATH);
                throw new IllegalArgumentException(e);
            }
        }
        return new DefaultFakeLoadExecutor(defaultInfrastructure);
    }

    private FakeLoadExecutors() {
        throw new AssertionError();
    }
}

