/*
 * Decompiled with CFR 0.152.
 */
package com.martensigwart.fakeload;

import com.martensigwart.fakeload.DiskOutputSimulator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RandomAccessDiskOutputSimulator
extends DiskOutputSimulator {
    private static final Logger log = LoggerFactory.getLogger(RandomAccessDiskOutputSimulator.class);
    private final String filePath;
    private RandomAccessFile file;

    public RandomAccessDiskOutputSimulator(String filePath) throws IOException {
        this.filePath = filePath;
    }

    @Override
    protected void write(byte[] bytes) throws IOException {
        if (this.file == null) {
            File f = new File(this.filePath);
            if (!f.exists()) {
                f.getParentFile().mkdirs();
                f.createNewFile();
                log.trace("Created file {}", (Object)this.filePath);
            }
            this.file = new RandomAccessFile(this.filePath, "rws");
        }
        this.file.seek(0L);
        this.file.write(bytes);
    }

    @Override
    protected void cleanUp() {
        if (this.file != null) {
            try {
                this.file.close();
                File f = new File(this.filePath);
                if (f.delete()) {
                    log.trace("File {} successfully deleted", (Object)this.filePath);
                } else {
                    log.warn("File {} could not be deleted", (Object)this.filePath);
                }
            }
            catch (IOException e) {
                log.error("Failed to close file: {}", (Object)e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

