/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batchai.WorkspaceCreateParameters;
import com.microsoft.azure.management.batchai.WorkspaceUpdateParameters;
import com.microsoft.azure.management.batchai.WorkspacesListByResourceGroupOptions;
import com.microsoft.azure.management.batchai.WorkspacesListOptions;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.PageImpl;
import com.microsoft.azure.management.batchai.implementation.WorkspaceInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class WorkspacesInner
implements InnerSupportsGet<WorkspaceInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<WorkspaceInner> {
    private WorkspacesService service;
    private BatchAIManagementClientImpl client;

    public WorkspacesInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = (WorkspacesService)retrofit.create(WorkspacesService.class);
        this.client = client;
    }

    public PagedList<WorkspaceInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<WorkspaceInner>((Page)response.body()){

            public Page<WorkspaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WorkspacesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WorkspaceInner>> listAsync(ListOperationCallback<WorkspaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(String nextPageLink) {
                return WorkspacesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WorkspaceInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Page<WorkspaceInner>>(){

            public Page<WorkspaceInner> call(ServiceResponse<Page<WorkspaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(ServiceResponse<Page<WorkspaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WorkspacesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object workspacesListOptions = null;
        Integer maxResults = null;
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkspacesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<WorkspaceInner> list(WorkspacesListOptions workspacesListOptions) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(workspacesListOptions).toBlocking().single();
        return new PagedList<WorkspaceInner>((Page)response.body()){

            public Page<WorkspaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WorkspacesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WorkspaceInner>> listAsync(WorkspacesListOptions workspacesListOptions, ListOperationCallback<WorkspaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(workspacesListOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(String nextPageLink) {
                return WorkspacesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WorkspaceInner>> listAsync(WorkspacesListOptions workspacesListOptions) {
        return this.listWithServiceResponseAsync(workspacesListOptions).map((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Page<WorkspaceInner>>(){

            public Page<WorkspaceInner> call(ServiceResponse<Page<WorkspaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listWithServiceResponseAsync(WorkspacesListOptions workspacesListOptions) {
        return this.listSinglePageAsync(workspacesListOptions).concatMap((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(ServiceResponse<Page<WorkspaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WorkspacesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listSinglePageAsync(WorkspacesListOptions workspacesListOptions) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)workspacesListOptions);
        Integer maxResults = null;
        if (workspacesListOptions != null) {
            maxResults = workspacesListOptions.maxResults();
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkspacesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WorkspaceInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WorkspaceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WorkspaceInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<WorkspaceInner>((Page)response.body()){

            public Page<WorkspaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WorkspacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WorkspaceInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<WorkspaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(String nextPageLink) {
                return WorkspacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WorkspaceInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Page<WorkspaceInner>>(){

            public Page<WorkspaceInner> call(ServiceResponse<Page<WorkspaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(ServiceResponse<Page<WorkspaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WorkspacesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object workspacesListByResourceGroupOptions = null;
        Integer maxResults = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkspacesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<WorkspaceInner> listByResourceGroup(String resourceGroupName, WorkspacesListByResourceGroupOptions workspacesListByResourceGroupOptions) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, workspacesListByResourceGroupOptions).toBlocking().single();
        return new PagedList<WorkspaceInner>((Page)response.body()){

            public Page<WorkspaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WorkspacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WorkspaceInner>> listByResourceGroupAsync(String resourceGroupName, WorkspacesListByResourceGroupOptions workspacesListByResourceGroupOptions, ListOperationCallback<WorkspaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, workspacesListByResourceGroupOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(String nextPageLink) {
                return WorkspacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WorkspaceInner>> listByResourceGroupAsync(String resourceGroupName, WorkspacesListByResourceGroupOptions workspacesListByResourceGroupOptions) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, workspacesListByResourceGroupOptions).map((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Page<WorkspaceInner>>(){

            public Page<WorkspaceInner> call(ServiceResponse<Page<WorkspaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, WorkspacesListByResourceGroupOptions workspacesListByResourceGroupOptions) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, workspacesListByResourceGroupOptions).concatMap((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(ServiceResponse<Page<WorkspaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WorkspacesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, WorkspacesListByResourceGroupOptions workspacesListByResourceGroupOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)workspacesListByResourceGroupOptions);
        Integer maxResults = null;
        if (workspacesListByResourceGroupOptions != null) {
            maxResults = workspacesListByResourceGroupOptions.maxResults();
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkspacesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WorkspaceInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WorkspaceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WorkspaceInner create(String resourceGroupName, String workspaceName, WorkspaceCreateParameters parameters) {
        return (WorkspaceInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, workspaceName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<WorkspaceInner> createAsync(String resourceGroupName, String workspaceName, WorkspaceCreateParameters parameters, ServiceCallback<WorkspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, workspaceName, parameters), serviceCallback);
    }

    public Observable<WorkspaceInner> createAsync(String resourceGroupName, String workspaceName, WorkspaceCreateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, workspaceName, parameters).map((Func1)new Func1<ServiceResponse<WorkspaceInner>, WorkspaceInner>(){

            public WorkspaceInner call(ServiceResponse<WorkspaceInner> response) {
                return (WorkspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WorkspaceInner>> createWithServiceResponseAsync(String resourceGroupName, String workspaceName, WorkspaceCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, workspaceName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<WorkspaceInner>(){}.getType());
    }

    public WorkspaceInner beginCreate(String resourceGroupName, String workspaceName, WorkspaceCreateParameters parameters) {
        return (WorkspaceInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<WorkspaceInner> beginCreateAsync(String resourceGroupName, String workspaceName, WorkspaceCreateParameters parameters, ServiceCallback<WorkspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, parameters), serviceCallback);
    }

    public Observable<WorkspaceInner> beginCreateAsync(String resourceGroupName, String workspaceName, WorkspaceCreateParameters parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, parameters).map((Func1)new Func1<ServiceResponse<WorkspaceInner>, WorkspaceInner>(){

            public WorkspaceInner call(ServiceResponse<WorkspaceInner> response) {
                return (WorkspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WorkspaceInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String workspaceName, WorkspaceCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, workspaceName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkspaceInner>>>(){

            public Observable<ServiceResponse<WorkspaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkspacesInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WorkspaceInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WorkspaceInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WorkspaceInner update(String resourceGroupName, String workspaceName) {
        return (WorkspaceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, workspaceName).toBlocking().single()).body());
    }

    public ServiceFuture<WorkspaceInner> updateAsync(String resourceGroupName, String workspaceName, ServiceCallback<WorkspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, workspaceName), serviceCallback);
    }

    public Observable<WorkspaceInner> updateAsync(String resourceGroupName, String workspaceName) {
        return this.updateWithServiceResponseAsync(resourceGroupName, workspaceName).map((Func1)new Func1<ServiceResponse<WorkspaceInner>, WorkspaceInner>(){

            public WorkspaceInner call(ServiceResponse<WorkspaceInner> response) {
                return (WorkspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WorkspaceInner>> updateWithServiceResponseAsync(String resourceGroupName, String workspaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object tags = null;
        WorkspaceUpdateParameters parameters = new WorkspaceUpdateParameters();
        parameters.withTags(null);
        return this.service.update(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkspaceInner>>>(){

            public Observable<ServiceResponse<WorkspaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkspacesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public WorkspaceInner update(String resourceGroupName, String workspaceName, Map<String, String> tags) {
        return (WorkspaceInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<WorkspaceInner> updateAsync(String resourceGroupName, String workspaceName, Map<String, String> tags, ServiceCallback<WorkspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, tags), serviceCallback);
    }

    public Observable<WorkspaceInner> updateAsync(String resourceGroupName, String workspaceName, Map<String, String> tags) {
        return this.updateWithServiceResponseAsync(resourceGroupName, workspaceName, tags).map((Func1)new Func1<ServiceResponse<WorkspaceInner>, WorkspaceInner>(){

            public WorkspaceInner call(ServiceResponse<WorkspaceInner> response) {
                return (WorkspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WorkspaceInner>> updateWithServiceResponseAsync(String resourceGroupName, String workspaceName, Map<String, String> tags) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(tags);
        WorkspaceUpdateParameters parameters = new WorkspaceUpdateParameters();
        parameters.withTags(tags);
        return this.service.update(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), parameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkspaceInner>>>(){

            public Observable<ServiceResponse<WorkspaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkspacesInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WorkspaceInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WorkspaceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String workspaceName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String workspaceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String workspaceName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, workspaceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String workspaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String workspaceName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String workspaceName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String workspaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkspacesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public WorkspaceInner getByResourceGroup(String resourceGroupName, String workspaceName) {
        return (WorkspaceInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, workspaceName).toBlocking().single()).body());
    }

    public ServiceFuture<WorkspaceInner> getByResourceGroupAsync(String resourceGroupName, String workspaceName, ServiceCallback<WorkspaceInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, workspaceName), serviceCallback);
    }

    public Observable<WorkspaceInner> getByResourceGroupAsync(String resourceGroupName, String workspaceName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, workspaceName).map((Func1)new Func1<ServiceResponse<WorkspaceInner>, WorkspaceInner>(){

            public WorkspaceInner call(ServiceResponse<WorkspaceInner> response) {
                return (WorkspaceInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<WorkspaceInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String workspaceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, workspaceName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<WorkspaceInner>>>(){

            public Observable<ServiceResponse<WorkspaceInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = WorkspacesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<WorkspaceInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<WorkspaceInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WorkspaceInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WorkspaceInner>((Page)response.body()){

            public Page<WorkspaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WorkspacesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WorkspaceInner>> listNextAsync(String nextPageLink, ServiceFuture<List<WorkspaceInner>> serviceFuture, ListOperationCallback<WorkspaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(String nextPageLink) {
                return WorkspacesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WorkspaceInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Page<WorkspaceInner>>(){

            public Page<WorkspaceInner> call(ServiceResponse<Page<WorkspaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(ServiceResponse<Page<WorkspaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WorkspacesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkspacesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WorkspaceInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WorkspaceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<WorkspaceInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<WorkspaceInner>((Page)response.body()){

            public Page<WorkspaceInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)WorkspacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<WorkspaceInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<WorkspaceInner>> serviceFuture, ListOperationCallback<WorkspaceInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(String nextPageLink) {
                return WorkspacesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<WorkspaceInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Page<WorkspaceInner>>(){

            public Page<WorkspaceInner> call(ServiceResponse<Page<WorkspaceInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<WorkspaceInner>>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(ServiceResponse<Page<WorkspaceInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(WorkspacesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<WorkspaceInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<WorkspaceInner>>>>(){

            public Observable<ServiceResponse<Page<WorkspaceInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = WorkspacesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<WorkspaceInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<WorkspaceInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface WorkspacesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/workspaces")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="maxresults") Integer var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="maxresults") Integer var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Body WorkspaceCreateParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Body WorkspaceCreateParameters var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body WorkspaceUpdateParameters var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="workspaceName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Workspaces listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

