/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.graphrbac.implementation.ClassicAdministratorsInner;
import com.microsoft.azure.management.graphrbac.implementation.PermissionsInner;
import com.microsoft.azure.management.graphrbac.implementation.ProviderOperationsMetadatasInner;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentsInner;
import com.microsoft.azure.management.graphrbac.implementation.RoleDefinitionsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class AuthorizationManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ClassicAdministratorsInner classicAdministrators;
    private ProviderOperationsMetadatasInner providerOperationsMetadatas;
    private PermissionsInner permissions;
    private RoleAssignmentsInner roleAssignments;
    private RoleDefinitionsInner roleDefinitions;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public AuthorizationManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public AuthorizationManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public AuthorizationManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public AuthorizationManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ClassicAdministratorsInner classicAdministrators() {
        return this.classicAdministrators;
    }

    public ProviderOperationsMetadatasInner providerOperationsMetadatas() {
        return this.providerOperationsMetadatas;
    }

    public PermissionsInner permissions() {
        return this.permissions;
    }

    public RoleAssignmentsInner roleAssignments() {
        return this.roleAssignments;
    }

    public RoleDefinitionsInner roleDefinitions() {
        return this.roleDefinitions;
    }

    public AuthorizationManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public AuthorizationManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public AuthorizationManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.classicAdministrators = new ClassicAdministratorsInner(this.restClient().retrofit(), this);
        this.providerOperationsMetadatas = new ProviderOperationsMetadatasInner(this.restClient().retrofit(), this);
        this.permissions = new PermissionsInner(this.restClient().retrofit(), this);
        this.roleAssignments = new RoleAssignmentsInner(this.restClient().retrofit(), this);
        this.roleDefinitions = new RoleDefinitionsInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "AuthorizationManagementClient");
    }
}

