/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.ExpressRouteGatewayInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl1;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class ExpressRouteGatewaysInner
implements InnerSupportsGet<ExpressRouteGatewayInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ExpressRouteGatewayInner> {
    private ExpressRouteGatewaysService service;
    private NetworkManagementClientImpl client;

    public ExpressRouteGatewaysInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (ExpressRouteGatewaysService)retrofit.create(ExpressRouteGatewaysService.class);
        this.client = client;
    }

    public PagedList<ExpressRouteGatewayInner> list() {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listWithServiceResponseAsync().toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<ExpressRouteGatewayInner>(page){

            public Page<ExpressRouteGatewayInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<ExpressRouteGatewayInner>> listAsync(ServiceCallback<List<ExpressRouteGatewayInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<Page<ExpressRouteGatewayInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<ExpressRouteGatewayInner>>, Page<ExpressRouteGatewayInner>>(){

            public Page<ExpressRouteGatewayInner> call(ServiceResponse<List<ExpressRouteGatewayInner>> response) {
                PageImpl1<ExpressRouteGatewayInner> page = new PageImpl1<ExpressRouteGatewayInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<ExpressRouteGatewayInner>>> listWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ExpressRouteGatewayInner>>>>(){

            public Observable<ServiceResponse<List<ExpressRouteGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteGatewaysInner.this.listDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ExpressRouteGatewayInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ExpressRouteGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ExpressRouteGatewayInner> listByResourceGroup(String resourceGroupName) {
        PageImpl1 page = new PageImpl1();
        page.setItems((List)((ServiceResponse)this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
        page.setNextPageLink(null);
        return new PagedList<ExpressRouteGatewayInner>(page){

            public Page<ExpressRouteGatewayInner> nextPage(String nextPageLink) {
                return null;
            }
        };
    }

    public ServiceFuture<List<ExpressRouteGatewayInner>> listByResourceGroupAsync(String resourceGroupName, ServiceCallback<List<ExpressRouteGatewayInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listByResourceGroupWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Page<ExpressRouteGatewayInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<List<ExpressRouteGatewayInner>>, Page<ExpressRouteGatewayInner>>(){

            public Page<ExpressRouteGatewayInner> call(ServiceResponse<List<ExpressRouteGatewayInner>> response) {
                PageImpl1<ExpressRouteGatewayInner> page = new PageImpl1<ExpressRouteGatewayInner>();
                page.setItems((List)response.body());
                return page;
            }
        });
    }

    public Observable<ServiceResponse<List<ExpressRouteGatewayInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ExpressRouteGatewayInner>>>>(){

            public Observable<ServiceResponse<List<ExpressRouteGatewayInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ExpressRouteGatewaysInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    List items = null;
                    if (result.body() != null) {
                        items = ((PageImpl1)result.body()).items();
                    }
                    ServiceResponse clientResponse = new ServiceResponse(items, result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<ExpressRouteGatewayInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<ExpressRouteGatewayInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteGatewayInner createOrUpdate(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return (ExpressRouteGatewayInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).toBlocking().last()).body());
    }

    public ServiceFuture<ExpressRouteGatewayInner> createOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, ServiceCallback<ExpressRouteGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters), serviceCallback);
    }

    public Observable<ExpressRouteGatewayInner> createOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).map((Func1)new Func1<ServiceResponse<ExpressRouteGatewayInner>, ExpressRouteGatewayInner>(){

            public ExpressRouteGatewayInner call(ServiceResponse<ExpressRouteGatewayInner> response) {
                return (ExpressRouteGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteGatewayInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (putExpressRouteGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter putExpressRouteGatewayParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)putExpressRouteGatewayParameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), putExpressRouteGatewayParameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ExpressRouteGatewayInner>(){}.getType());
    }

    public ExpressRouteGatewayInner beginCreateOrUpdate(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return (ExpressRouteGatewayInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters, ServiceCallback<ExpressRouteGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters), serviceCallback);
    }

    public Observable<ExpressRouteGatewayInner> beginCreateOrUpdateAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName, putExpressRouteGatewayParameters).map((Func1)new Func1<ServiceResponse<ExpressRouteGatewayInner>, ExpressRouteGatewayInner>(){

            public ExpressRouteGatewayInner call(ServiceResponse<ExpressRouteGatewayInner> response) {
                return (ExpressRouteGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteGatewayInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName, ExpressRouteGatewayInner putExpressRouteGatewayParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (putExpressRouteGatewayParameters == null) {
            throw new IllegalArgumentException("Parameter putExpressRouteGatewayParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)putExpressRouteGatewayParameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), putExpressRouteGatewayParameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteGatewayInner>>>(){

            public Observable<ServiceResponse<ExpressRouteGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteGatewaysInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteGatewayInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteGatewayInner>(){}.getType()).register(201, new TypeToken<ExpressRouteGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ExpressRouteGatewayInner getByResourceGroup(String resourceGroupName, String expressRouteGatewayName) {
        return (ExpressRouteGatewayInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).toBlocking().single()).body());
    }

    public ServiceFuture<ExpressRouteGatewayInner> getByResourceGroupAsync(String resourceGroupName, String expressRouteGatewayName, ServiceCallback<ExpressRouteGatewayInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName), serviceCallback);
    }

    public Observable<ExpressRouteGatewayInner> getByResourceGroupAsync(String resourceGroupName, String expressRouteGatewayName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).map((Func1)new Func1<ServiceResponse<ExpressRouteGatewayInner>, ExpressRouteGatewayInner>(){

            public ExpressRouteGatewayInner call(ServiceResponse<ExpressRouteGatewayInner> response) {
                return (ExpressRouteGatewayInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ExpressRouteGatewayInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ExpressRouteGatewayInner>>>(){

            public Observable<ServiceResponse<ExpressRouteGatewayInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteGatewaysInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ExpressRouteGatewayInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ExpressRouteGatewayInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String expressRouteGatewayName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String expressRouteGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String expressRouteGatewayName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String expressRouteGatewayName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String expressRouteGatewayName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String expressRouteGatewayName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, expressRouteGatewayName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String expressRouteGatewayName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (expressRouteGatewayName == null) {
            throw new IllegalArgumentException("Parameter expressRouteGatewayName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, expressRouteGatewayName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ExpressRouteGatewaysInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ExpressRouteGatewaysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/expressRouteGateways")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body ExpressRouteGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="subscriptionId") String var3, @Body ExpressRouteGatewayInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.ExpressRouteGateways beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/expressRouteGateways/{expressRouteGatewayName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="expressRouteGatewayName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);
    }
}

