/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.ErrorException;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VirtualRouterPeeringInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VirtualRouterPeeringsInner {
    private VirtualRouterPeeringsService service;
    private NetworkManagementClientImpl client;

    public VirtualRouterPeeringsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VirtualRouterPeeringsService)retrofit.create(VirtualRouterPeeringsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String virtualRouterName, String peeringName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualRouterName, String peeringName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualRouterName, String peeringName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualRouterName, String peeringName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualRouterPeeringsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VirtualRouterPeeringInner get(String resourceGroupName, String virtualRouterName, String peeringName) {
        return (VirtualRouterPeeringInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualRouterPeeringInner> getAsync(String resourceGroupName, String virtualRouterName, String peeringName, ServiceCallback<VirtualRouterPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName), serviceCallback);
    }

    public Observable<VirtualRouterPeeringInner> getAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        return this.getWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName).map((Func1)new Func1<ServiceResponse<VirtualRouterPeeringInner>, VirtualRouterPeeringInner>(){

            public VirtualRouterPeeringInner call(ServiceResponse<VirtualRouterPeeringInner> response) {
                return (VirtualRouterPeeringInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualRouterPeeringInner>> getWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterPeeringInner>>>(){

            public Observable<ServiceResponse<VirtualRouterPeeringInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualRouterPeeringsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualRouterPeeringInner> getDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualRouterPeeringInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public VirtualRouterPeeringInner createOrUpdate(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        return (VirtualRouterPeeringInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<VirtualRouterPeeringInner> createOrUpdateAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters, ServiceCallback<VirtualRouterPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters), serviceCallback);
    }

    public Observable<VirtualRouterPeeringInner> createOrUpdateAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters).map((Func1)new Func1<ServiceResponse<VirtualRouterPeeringInner>, VirtualRouterPeeringInner>(){

            public VirtualRouterPeeringInner call(ServiceResponse<VirtualRouterPeeringInner> response) {
                return (VirtualRouterPeeringInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualRouterPeeringInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VirtualRouterPeeringInner>(){}.getType());
    }

    public VirtualRouterPeeringInner beginCreateOrUpdate(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        return (VirtualRouterPeeringInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<VirtualRouterPeeringInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters, ServiceCallback<VirtualRouterPeeringInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters), serviceCallback);
    }

    public Observable<VirtualRouterPeeringInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualRouterName, peeringName, parameters).map((Func1)new Func1<ServiceResponse<VirtualRouterPeeringInner>, VirtualRouterPeeringInner>(){

            public VirtualRouterPeeringInner call(ServiceResponse<VirtualRouterPeeringInner> response) {
                return (VirtualRouterPeeringInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VirtualRouterPeeringInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualRouterName, String peeringName, VirtualRouterPeeringInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (peeringName == null) {
            throw new IllegalArgumentException("Parameter peeringName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, virtualRouterName, peeringName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VirtualRouterPeeringInner>>>(){

            public Observable<ServiceResponse<VirtualRouterPeeringInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VirtualRouterPeeringsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VirtualRouterPeeringInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VirtualRouterPeeringInner>(){}.getType()).register(201, new TypeToken<VirtualRouterPeeringInner>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualRouterPeeringInner> list(String resourceGroupName, String virtualRouterName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, virtualRouterName).toBlocking().single();
        return new PagedList<VirtualRouterPeeringInner>((Page)response.body()){

            public Page<VirtualRouterPeeringInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualRouterPeeringsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualRouterPeeringInner>> listAsync(String resourceGroupName, String virtualRouterName, ListOperationCallback<VirtualRouterPeeringInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, virtualRouterName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(String nextPageLink) {
                return VirtualRouterPeeringsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualRouterPeeringInner>> listAsync(String resourceGroupName, String virtualRouterName) {
        return this.listWithServiceResponseAsync(resourceGroupName, virtualRouterName).map((Func1)new Func1<ServiceResponse<Page<VirtualRouterPeeringInner>>, Page<VirtualRouterPeeringInner>>(){

            public Page<VirtualRouterPeeringInner> call(ServiceResponse<Page<VirtualRouterPeeringInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> listWithServiceResponseAsync(String resourceGroupName, String virtualRouterName) {
        return this.listSinglePageAsync(resourceGroupName, virtualRouterName).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualRouterPeeringInner>>, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(ServiceResponse<Page<VirtualRouterPeeringInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualRouterPeeringsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> listSinglePageAsync(String resourceGroupName, String virtualRouterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualRouterName == null) {
            throw new IllegalArgumentException("Parameter virtualRouterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, virtualRouterName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualRouterPeeringsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualRouterPeeringInner>> listDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualRouterPeeringInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    public PagedList<VirtualRouterPeeringInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VirtualRouterPeeringInner>((Page)response.body()){

            public Page<VirtualRouterPeeringInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VirtualRouterPeeringsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VirtualRouterPeeringInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VirtualRouterPeeringInner>> serviceFuture, ListOperationCallback<VirtualRouterPeeringInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(String nextPageLink) {
                return VirtualRouterPeeringsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VirtualRouterPeeringInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VirtualRouterPeeringInner>>, Page<VirtualRouterPeeringInner>>(){

            public Page<VirtualRouterPeeringInner> call(ServiceResponse<Page<VirtualRouterPeeringInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VirtualRouterPeeringInner>>, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(ServiceResponse<Page<VirtualRouterPeeringInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VirtualRouterPeeringsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>>>(){

            public Observable<ServiceResponse<Page<VirtualRouterPeeringInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VirtualRouterPeeringsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VirtualRouterPeeringInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VirtualRouterPeeringInner>>(){}.getType()).registerError(ErrorException.class).build(response);
    }

    static interface VirtualRouterPeeringsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Body VirtualRouterPeeringInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings/{peeringName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="peeringName") String var3, @Path(value="subscriptionId") String var4, @Body VirtualRouterPeeringInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualRouters/{virtualRouterName}/peerings")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="virtualRouterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VirtualRouterPeerings listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

