/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.TagsObject;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.VpnServerConfigurationInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class VpnServerConfigurationsInner
implements InnerSupportsGet<VpnServerConfigurationInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<VpnServerConfigurationInner> {
    private VpnServerConfigurationsService service;
    private NetworkManagementClientImpl client;

    public VpnServerConfigurationsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (VpnServerConfigurationsService)retrofit.create(VpnServerConfigurationsService.class);
        this.client = client;
    }

    public VpnServerConfigurationInner getByResourceGroup(String resourceGroupName, String vpnServerConfigurationName) {
        return (VpnServerConfigurationInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnServerConfigurationInner> getByResourceGroupAsync(String resourceGroupName, String vpnServerConfigurationName, ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName), serviceCallback);
    }

    public Observable<VpnServerConfigurationInner> getByResourceGroupAsync(String resourceGroupName, String vpnServerConfigurationName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).map((Func1)new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>(){

            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return (VpnServerConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnServerConfigurationInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationInner>>>(){

            public Observable<ServiceResponse<VpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnServerConfigurationsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnServerConfigurationInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnServerConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VpnServerConfigurationInner createOrUpdate(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        return (VpnServerConfigurationInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters).toBlocking().last()).body());
    }

    public ServiceFuture<VpnServerConfigurationInner> createOrUpdateAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters, ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters), serviceCallback);
    }

    public Observable<VpnServerConfigurationInner> createOrUpdateAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters).map((Func1)new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>(){

            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return (VpnServerConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnServerConfigurationInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        if (vpnServerConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)vpnServerConfigurationParameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, "2019-11-01", vpnServerConfigurationParameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<VpnServerConfigurationInner>(){}.getType());
    }

    public VpnServerConfigurationInner beginCreateOrUpdate(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        return (VpnServerConfigurationInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters).toBlocking().single()).body());
    }

    public ServiceFuture<VpnServerConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters, ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters), serviceCallback);
    }

    public Observable<VpnServerConfigurationInner> beginCreateOrUpdateAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, vpnServerConfigurationParameters).map((Func1)new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>(){

            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return (VpnServerConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnServerConfigurationInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName, VpnServerConfigurationInner vpnServerConfigurationParameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        if (vpnServerConfigurationParameters == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)vpnServerConfigurationParameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, "2019-11-01", vpnServerConfigurationParameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationInner>>>(){

            public Observable<ServiceResponse<VpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnServerConfigurationsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnServerConfigurationInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnServerConfigurationInner>(){}.getType()).register(201, new TypeToken<VpnServerConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public VpnServerConfigurationInner updateTags(String resourceGroupName, String vpnServerConfigurationName) {
        return (VpnServerConfigurationInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).toBlocking().single()).body());
    }

    public ServiceFuture<VpnServerConfigurationInner> updateTagsAsync(String resourceGroupName, String vpnServerConfigurationName, ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName), serviceCallback);
    }

    public Observable<VpnServerConfigurationInner> updateTagsAsync(String resourceGroupName, String vpnServerConfigurationName) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).map((Func1)new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>(){

            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return (VpnServerConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnServerConfigurationInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object tags = null;
        TagsObject vpnServerConfigurationParameters = new TagsObject();
        vpnServerConfigurationParameters.withTags(null);
        return this.service.updateTags(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, "2019-11-01", this.client.acceptLanguage(), vpnServerConfigurationParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationInner>>>(){

            public Observable<ServiceResponse<VpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnServerConfigurationsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public VpnServerConfigurationInner updateTags(String resourceGroupName, String vpnServerConfigurationName, Map<String, String> tags) {
        return (VpnServerConfigurationInner)((Object)((ServiceResponse)this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, tags).toBlocking().single()).body());
    }

    public ServiceFuture<VpnServerConfigurationInner> updateTagsAsync(String resourceGroupName, String vpnServerConfigurationName, Map<String, String> tags, ServiceCallback<VpnServerConfigurationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, tags), serviceCallback);
    }

    public Observable<VpnServerConfigurationInner> updateTagsAsync(String resourceGroupName, String vpnServerConfigurationName, Map<String, String> tags) {
        return this.updateTagsWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName, tags).map((Func1)new Func1<ServiceResponse<VpnServerConfigurationInner>, VpnServerConfigurationInner>(){

            public VpnServerConfigurationInner call(ServiceResponse<VpnServerConfigurationInner> response) {
                return (VpnServerConfigurationInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<VpnServerConfigurationInner>> updateTagsWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName, Map<String, String> tags) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        Validator.validate(tags);
        String apiVersion = "2019-11-01";
        TagsObject vpnServerConfigurationParameters = new TagsObject();
        vpnServerConfigurationParameters.withTags(tags);
        return this.service.updateTags(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, "2019-11-01", this.client.acceptLanguage(), vpnServerConfigurationParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<VpnServerConfigurationInner>>>(){

            public Observable<ServiceResponse<VpnServerConfigurationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnServerConfigurationsInner.this.updateTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<VpnServerConfigurationInner> updateTagsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<VpnServerConfigurationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String vpnServerConfigurationName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String vpnServerConfigurationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String vpnServerConfigurationName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String vpnServerConfigurationName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String vpnServerConfigurationName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String vpnServerConfigurationName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, vpnServerConfigurationName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String vpnServerConfigurationName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (vpnServerConfigurationName == null) {
            throw new IllegalArgumentException("Parameter vpnServerConfigurationName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(this.client.subscriptionId(), resourceGroupName, vpnServerConfigurationName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = VpnServerConfigurationsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VpnServerConfigurationInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<VpnServerConfigurationInner>((Page)response.body()){

            public Page<VpnServerConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnServerConfigurationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnServerConfigurationInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<VpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(String nextPageLink) {
                return VpnServerConfigurationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnServerConfigurationInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Page<VpnServerConfigurationInner>>(){

            public Page<VpnServerConfigurationInner> call(ServiceResponse<Page<VpnServerConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(ServiceResponse<Page<VpnServerConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnServerConfigurationsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(this.client.subscriptionId(), resourceGroupName, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnServerConfigurationsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnServerConfigurationInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnServerConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VpnServerConfigurationInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<VpnServerConfigurationInner>((Page)response.body()){

            public Page<VpnServerConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnServerConfigurationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnServerConfigurationInner>> listAsync(ListOperationCallback<VpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(String nextPageLink) {
                return VpnServerConfigurationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnServerConfigurationInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Page<VpnServerConfigurationInner>>(){

            public Page<VpnServerConfigurationInner> call(ServiceResponse<Page<VpnServerConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(ServiceResponse<Page<VpnServerConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnServerConfigurationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnServerConfigurationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnServerConfigurationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnServerConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VpnServerConfigurationInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnServerConfigurationInner>((Page)response.body()){

            public Page<VpnServerConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnServerConfigurationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnServerConfigurationInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<VpnServerConfigurationInner>> serviceFuture, ListOperationCallback<VpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(String nextPageLink) {
                return VpnServerConfigurationsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnServerConfigurationInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Page<VpnServerConfigurationInner>>(){

            public Page<VpnServerConfigurationInner> call(ServiceResponse<Page<VpnServerConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(ServiceResponse<Page<VpnServerConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnServerConfigurationsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnServerConfigurationsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnServerConfigurationInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnServerConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<VpnServerConfigurationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<VpnServerConfigurationInner>((Page)response.body()){

            public Page<VpnServerConfigurationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)VpnServerConfigurationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<VpnServerConfigurationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<VpnServerConfigurationInner>> serviceFuture, ListOperationCallback<VpnServerConfigurationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(String nextPageLink) {
                return VpnServerConfigurationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<VpnServerConfigurationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Page<VpnServerConfigurationInner>>(){

            public Page<VpnServerConfigurationInner> call(ServiceResponse<Page<VpnServerConfigurationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<VpnServerConfigurationInner>>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(ServiceResponse<Page<VpnServerConfigurationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(VpnServerConfigurationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<VpnServerConfigurationInner>>>>(){

            public Observable<ServiceResponse<Page<VpnServerConfigurationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = VpnServerConfigurationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<VpnServerConfigurationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<VpnServerConfigurationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface VpnServerConfigurationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnServerConfigurationName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnServerConfigurationName") String var3, @Query(value="api-version") String var4, @Body VpnServerConfigurationInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnServerConfigurationName") String var3, @Query(value="api-version") String var4, @Body VpnServerConfigurationInner var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations updateTags"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}")
        public Observable<Response<ResponseBody>> updateTags(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnServerConfigurationName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Body TagsObject var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnServerConfigurationName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations/{vpnServerConfigurationName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="vpnServerConfigurationName") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/vpnServerConfigurations")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/vpnServerConfigurations")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.VpnServerConfigurations listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

