/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.primitives;

import com.microsoft.azure.servicebus.amqp.AmqpErrorCode;
import com.microsoft.azure.servicebus.amqp.AmqpException;
import com.microsoft.azure.servicebus.primitives.AsyncUtil;
import com.microsoft.azure.servicebus.primitives.AuthorizationFailedException;
import com.microsoft.azure.servicebus.primitives.ClientConstants;
import com.microsoft.azure.servicebus.primitives.ErrorContext;
import com.microsoft.azure.servicebus.primitives.IErrorContextProvider;
import com.microsoft.azure.servicebus.primitives.MessageLockLostException;
import com.microsoft.azure.servicebus.primitives.MessageNotFoundException;
import com.microsoft.azure.servicebus.primitives.MessagingEntityAlreadyExistsException;
import com.microsoft.azure.servicebus.primitives.MessagingEntityDisabledException;
import com.microsoft.azure.servicebus.primitives.MessagingEntityNotFoundException;
import com.microsoft.azure.servicebus.primitives.PayloadSizeExceededException;
import com.microsoft.azure.servicebus.primitives.QuotaExceededException;
import com.microsoft.azure.servicebus.primitives.ReceiverDisconnectedException;
import com.microsoft.azure.servicebus.primitives.ServerBusyException;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.servicebus.primitives.SessionCannotBeLockedException;
import com.microsoft.azure.servicebus.primitives.SessionLockLostException;
import com.microsoft.azure.servicebus.primitives.StringUtil;
import com.microsoft.azure.servicebus.primitives.TimeoutException;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public final class ExceptionUtil {
    static Exception toException(ErrorCondition errorCondition) {
        if (errorCondition == null) {
            throw new IllegalArgumentException("'null' errorCondition cannot be translated to ServiceBusException");
        }
        if (errorCondition.getCondition() == ClientConstants.TIMEOUT_ERROR) {
            return new TimeoutException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.SERVER_BUSY_ERROR) {
            return new ServerBusyException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.NotFound) {
            return new MessagingEntityNotFoundException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.ENTITY_DISABLED_ERROR) {
            return new MessagingEntityDisabledException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.Stolen) {
            return new ReceiverDisconnectedException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.UnauthorizedAccess) {
            return new AuthorizationFailedException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.PayloadSizeExceeded) {
            return new PayloadSizeExceededException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.InternalError) {
            return new ServiceBusException(true, (Throwable)new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == ClientConstants.ARGUMENT_ERROR) {
            return new ServiceBusException(false, errorCondition.getDescription(), new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == ClientConstants.ARGUMENT_OUT_OF_RANGE_ERROR) {
            return new ServiceBusException(false, errorCondition.getDescription(), new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == AmqpErrorCode.NotImplemented) {
            return new UnsupportedOperationException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.NotAllowed) {
            return new UnsupportedOperationException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.PARTITION_NOT_OWNED_ERROR) {
            return new ServiceBusException(false, errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.STORE_LOCK_LOST_ERROR) {
            return new ServiceBusException(false, errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == AmqpErrorCode.AmqpLinkDetachForced) {
            return new ServiceBusException(true, (Throwable)new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == AmqpErrorCode.ConnectionForced) {
            return new ServiceBusException(true, (Throwable)new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == AmqpErrorCode.FramingError) {
            return new ServiceBusException(true, (Throwable)new AmqpException(errorCondition));
        }
        if (errorCondition.getCondition() == AmqpErrorCode.ResourceLimitExceeded) {
            return new QuotaExceededException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.MESSAGE_LOCK_LOST_ERROR) {
            return new MessageLockLostException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.SESSION_LOCK_LOST_ERROR) {
            return new SessionLockLostException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.SESSIONS_CANNOT_BE_LOCKED_ERROR) {
            return new SessionCannotBeLockedException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.MESSAGE_NOT_FOUND_ERROR) {
            return new MessageNotFoundException(errorCondition.getDescription());
        }
        if (errorCondition.getCondition() == ClientConstants.ENTITY_ALREADY_EXISTS_ERROR) {
            return new MessagingEntityAlreadyExistsException(errorCondition.getDescription());
        }
        return new ServiceBusException(true, errorCondition.toString());
    }

    static <T> void completeExceptionally(CompletableFuture<T> future, Throwable exception, IErrorContextProvider contextProvider, boolean completeAsynchronously) {
        if (exception != null && exception instanceof ServiceBusException) {
            ErrorContext errorContext = contextProvider.getContext();
            ((ServiceBusException)exception).setContext(errorContext);
        }
        if (completeAsynchronously) {
            AsyncUtil.completeFutureExceptionally(future, exception);
        } else {
            future.completeExceptionally(exception);
        }
    }

    static boolean isGeneralError(Symbol amqpError) {
        return amqpError == ClientConstants.SERVER_BUSY_ERROR || amqpError == ClientConstants.TIMEOUT_ERROR || amqpError == AmqpErrorCode.ResourceLimitExceeded;
    }

    static String getTrackingIDAndTimeToLog() {
        return String.format(Locale.US, "TrackingId: %s, at: %s", UUID.randomUUID().toString(), ZonedDateTime.now());
    }

    static String toStackTraceString(Throwable exception, String customErrorMessage) {
        Throwable innerException;
        StringBuilder builder = new StringBuilder();
        if (!StringUtil.isNullOrEmpty(customErrorMessage)) {
            builder.append(customErrorMessage);
            builder.append(System.lineSeparator());
        }
        builder.append(exception.getMessage());
        if (exception.getStackTrace() != null) {
            for (StackTraceElement ste : exception.getStackTrace()) {
                builder.append(System.lineSeparator());
                builder.append(ste.toString());
            }
        }
        if ((innerException = exception.getCause()) != null) {
            builder.append("Cause: " + innerException.getMessage());
            if (innerException.getStackTrace() != null) {
                for (StackTraceElement ste : innerException.getStackTrace()) {
                    builder.append(System.lineSeparator());
                    builder.append(ste.toString());
                }
            }
        }
        return builder.toString();
    }

    public static Throwable extractAsyncCompletionCause(Throwable completionEx) {
        if (completionEx instanceof CompletionException || completionEx instanceof ExecutionException) {
            return completionEx.getCause();
        }
        return completionEx;
    }
}

