/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.AuthenticationErrorCode;
import com.microsoft.aad.msal4j.AuthenticationException;
import com.microsoft.aad.msal4j.HttpEvent;
import com.microsoft.aad.msal4j.HttpMethod;
import com.microsoft.aad.msal4j.LogHelper;
import com.microsoft.aad.msal4j.RequestContext;
import com.microsoft.aad.msal4j.ServiceBundle;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TelemetryHelper;
import com.microsoft.aad.msal4j.XmsClientTelemetryInfo;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;

class HttpHelper {
    HttpHelper() {
    }

    static String executeHttpRequest(Logger log, HttpMethod httpMethod, String url, Map<String, String> headers, String postData, RequestContext requestContext, ServiceBundle serviceBundle) throws Exception {
        HttpEvent httpEvent = new HttpEvent();
        String response = null;
        try (TelemetryHelper telemetryHelper = serviceBundle.getTelemetryManager().createTelemetryHelper(requestContext.getTelemetryRequestId(), requestContext.getClientId(), httpEvent, false);){
            URL endpointUrl = new URL(url);
            httpEvent.setHttpPath(endpointUrl.toURI());
            if (!StringHelper.isBlank(endpointUrl.getQuery())) {
                httpEvent.setQueryParameters(endpointUrl.getQuery());
            }
            if (httpMethod == HttpMethod.GET) {
                httpEvent.setHttpMethod("GET");
                response = HttpHelper.executeHttpGet(log, endpointUrl, headers, serviceBundle, httpEvent);
            } else if (httpMethod == HttpMethod.POST) {
                httpEvent.setHttpMethod("POST");
                response = HttpHelper.executeHttpPost(log, endpointUrl, postData, headers, serviceBundle, httpEvent);
            }
        }
        return response;
    }

    private static String executeHttpGet(Logger log, URL url, Map<String, String> headers, ServiceBundle serviceBundle, HttpEvent httpEvent) throws Exception {
        HttpsURLConnection conn = HttpHelper.openConnection(url, serviceBundle);
        HttpHelper.configureAdditionalHeaders(conn, headers);
        return HttpHelper.getResponse(log, headers, conn, httpEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeHttpPost(Logger log, URL url, String postData, Map<String, String> headers, ServiceBundle serviceBundle, HttpEvent httpEvent) throws Exception {
        HttpsURLConnection conn = HttpHelper.openConnection(url, serviceBundle);
        HttpHelper.configureAdditionalHeaders(conn, headers);
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        try (DataOutputStream wr = null;){
            wr = new DataOutputStream(conn.getOutputStream());
            wr.writeBytes(postData);
            wr.flush();
            String string = HttpHelper.getResponse(log, headers, conn, httpEvent);
            return string;
        }
    }

    private static String getResponse(Logger log, Map<String, String> headers, HttpsURLConnection conn, HttpEvent httpEvent) throws IOException {
        String response = HttpHelper.readResponseFromConnection(conn, httpEvent);
        if (headers != null) {
            HttpHelper.verifyReturnedCorrelationId(log, conn, headers.get("client-request-id"));
        }
        if (!StringHelper.isBlank(conn.getHeaderField("User-Agent"))) {
            httpEvent.setUserAgent(conn.getHeaderField("User-Agent"));
        }
        HttpHelper.setXmsClientTelemetryInfo(conn, httpEvent);
        return response;
    }

    static HttpsURLConnection openConnection(URL finalURL, ServiceBundle serviceBundle) throws IOException {
        HttpsURLConnection connection = serviceBundle.getProxy() != null ? (HttpsURLConnection)finalURL.openConnection(serviceBundle.getProxy()) : (HttpsURLConnection)finalURL.openConnection();
        if (serviceBundle.getSslSocketFactory() != null) {
            connection.setSSLSocketFactory(serviceBundle.getSslSocketFactory());
        }
        return connection;
    }

    static void configureAdditionalHeaders(HttpsURLConnection conn, Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    static void verifyReturnedCorrelationId(Logger log, HttpsURLConnection conn, String sentCorrelationId) {
        if (StringHelper.isBlank(conn.getHeaderField("client-request-id")) || !conn.getHeaderField("client-request-id").equals(sentCorrelationId)) {
            String msg = LogHelper.createMessage(String.format("Sent (%s) Correlation Id is not same as received (%s).", sentCorrelationId, conn.getHeaderField("client-request-id")), sentCorrelationId);
            log.info(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readResponseFromConnection(HttpsURLConnection conn, HttpEvent httpEvent) throws AuthenticationException, IOException {
        try (InputStream is = null;){
            int responseCode = conn.getResponseCode();
            httpEvent.setHttpResponseStatus(responseCode);
            if (responseCode != 200) {
                String msg = "Server returned HTTP response code: " + responseCode + " for URL : " + conn.getURL();
                is = conn.getErrorStream();
                if (is != null) {
                    msg = msg + ", Error details : " + HttpHelper.inputStreamToString(is);
                }
                httpEvent.setOauthErrorCode(AuthenticationErrorCode.UNKNOWN.toString());
                throw new AuthenticationException(msg);
            }
            is = conn.getInputStream();
            String string = HttpHelper.inputStreamToString(is);
            return string;
        }
    }

    private static String inputStreamToString(InputStream is) {
        Scanner s = new Scanner(is, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    private static void setXmsClientTelemetryInfo(HttpsURLConnection conn, HttpEvent httpEvent) {
        XmsClientTelemetryInfo xmsClientTelemetryInfo;
        if (!StringHelper.isBlank(conn.getHeaderField("x-ms-request-id"))) {
            httpEvent.setRequestIdHeader(conn.getHeaderField("x-ms-request-id"));
        }
        if (!StringHelper.isBlank(conn.getHeaderField("x-ms-clitelem")) && (xmsClientTelemetryInfo = XmsClientTelemetryInfo.parseXmsTelemetryInfo(conn.getHeaderField("x-ms-clitelem"))) != null) {
            httpEvent.setXmsClientTelemetryInfo(xmsClientTelemetryInfo);
        }
    }
}

