/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.util.Set;
import lombok.NonNull;

public class IntegratedWindowsAuthenticationParameters {
    @NonNull
    private Set<String> scopes;
    @NonNull
    private String username;

    private static IntegratedWindowsAuthenticationParametersBuilder builder() {
        return new IntegratedWindowsAuthenticationParametersBuilder();
    }

    public static IntegratedWindowsAuthenticationParametersBuilder builder(Set<String> scopes, String username) {
        ParameterValidationUtils.validateNotEmpty("scopes", scopes);
        ParameterValidationUtils.validateNotBlank("username", username);
        return IntegratedWindowsAuthenticationParameters.builder().scopes(scopes).username(username);
    }

    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    @NonNull
    public String username() {
        return this.username;
    }

    private IntegratedWindowsAuthenticationParameters(@NonNull Set<String> scopes, @NonNull String username) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked @NonNull but is null");
        }
        this.scopes = scopes;
        this.username = username;
    }

    public static class IntegratedWindowsAuthenticationParametersBuilder {
        private Set<String> scopes;
        private String username;

        IntegratedWindowsAuthenticationParametersBuilder() {
        }

        public IntegratedWindowsAuthenticationParametersBuilder scopes(@NonNull Set<String> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes is marked @NonNull but is null");
            }
            this.scopes = scopes;
            return this;
        }

        public IntegratedWindowsAuthenticationParametersBuilder username(@NonNull String username) {
            if (username == null) {
                throw new NullPointerException("username is marked @NonNull but is null");
            }
            this.username = username;
            return this;
        }

        public IntegratedWindowsAuthenticationParameters build() {
            return new IntegratedWindowsAuthenticationParameters(this.scopes, this.username);
        }

        public String toString() {
            return "IntegratedWindowsAuthenticationParameters.IntegratedWindowsAuthenticationParametersBuilder(scopes=" + this.scopes + ", username=" + this.username + ")";
        }
    }
}

