/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.LinkedTreeMap;
import com.microsoft.aad.msal4j.AadInstanceDiscovery;
import com.microsoft.aad.msal4j.AccessTokenCacheEntity;
import com.microsoft.aad.msal4j.AccountCacheEntity;
import com.microsoft.aad.msal4j.AppMetadataCacheEntity;
import com.microsoft.aad.msal4j.AuthenticationResult;
import com.microsoft.aad.msal4j.Authority;
import com.microsoft.aad.msal4j.Credential;
import com.microsoft.aad.msal4j.CredentialTypeEnum;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.ITokenCache;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.IdToken;
import com.microsoft.aad.msal4j.IdTokenCacheEntity;
import com.microsoft.aad.msal4j.RefreshTokenCacheEntity;
import com.microsoft.aad.msal4j.StringHelper;
import com.microsoft.aad.msal4j.TokenCacheAccessContext;
import com.microsoft.aad.msal4j.TokenRequest;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TokenCache
implements ITokenCache {
    protected static final int MIN_ACCESS_TOKEN_EXPIRE_IN_SEC = 300;
    @SerializedName(value="AccessToken")
    Map<String, AccessTokenCacheEntity> accessTokens = new LinkedTreeMap();
    @SerializedName(value="RefreshToken")
    Map<String, RefreshTokenCacheEntity> refreshTokens = new LinkedTreeMap();
    @SerializedName(value="IdToken")
    Map<String, IdTokenCacheEntity> idTokens = new LinkedTreeMap();
    @SerializedName(value="Account")
    Map<String, AccountCacheEntity> accounts = new LinkedTreeMap();
    @SerializedName(value="AppMetadata")
    Map<String, AppMetadataCacheEntity> appMetadata = new LinkedTreeMap();
    transient ITokenCacheAccessAspect tokenCacheAccessAspect;
    private transient String serializedCachedData;

    public TokenCache(ITokenCacheAccessAspect tokenCacheAccessAspect) {
        this();
        this.tokenCacheAccessAspect = tokenCacheAccessAspect;
    }

    public TokenCache() {
    }

    @Override
    public void deserialize(String data) {
        if (StringHelper.isBlank(data)) {
            return;
        }
        this.serializedCachedData = data;
        Gson gson = new GsonBuilder().create();
        TokenCache deserializedCache = (TokenCache)gson.fromJson(data, TokenCache.class);
        this.accounts = deserializedCache.accounts;
        this.accessTokens = deserializedCache.accessTokens;
        this.refreshTokens = deserializedCache.refreshTokens;
        this.idTokens = deserializedCache.idTokens;
        this.appMetadata = deserializedCache.appMetadata;
    }

    private static void mergeJsonObjects(JsonObject old, JsonObject update) {
        TokenCache.mergeRemovals(old, update);
        TokenCache.mergeUpdates(old, update);
    }

    private static void mergeUpdates(JsonObject old, JsonObject update) {
        for (Map.Entry uEntry : update.entrySet()) {
            String key = (String)uEntry.getKey();
            JsonElement uValue = (JsonElement)uEntry.getValue();
            if (!old.has(key)) {
                if (uValue.isJsonNull() || uValue.isJsonObject() && uValue.getAsJsonObject().size() == 0) continue;
                old.add(key, uValue);
                continue;
            }
            JsonElement oValue = old.get(key);
            if (uValue.isJsonObject()) {
                TokenCache.mergeUpdates(oValue.getAsJsonObject(), uValue.getAsJsonObject());
                continue;
            }
            old.add(key, uValue);
        }
    }

    private static void mergeRemovals(JsonObject old, JsonObject update) {
        HashSet<String> msalEntities = new HashSet<String>(Arrays.asList("Account", "AccessToken", "RefreshToken", "IdToken", "AppMetadata"));
        for (String msalEntity : msalEntities) {
            JsonObject oldEntries = old.getAsJsonObject(msalEntity);
            JsonObject newEntries = update.getAsJsonObject(msalEntity);
            if (oldEntries == null) continue;
            for (Map.Entry oEntry : oldEntries.entrySet()) {
                String key = (String)oEntry.getKey();
                if (newEntries != null && newEntries.has(key)) continue;
                oldEntries.remove(key);
            }
        }
    }

    @Override
    public String serialize() {
        if (!StringHelper.isBlank(this.serializedCachedData)) {
            JsonObject cache = new JsonParser().parse(this.serializedCachedData).getAsJsonObject();
            JsonObject update = new Gson().toJsonTree((Object)this).getAsJsonObject();
            TokenCache.mergeJsonObjects(cache, update);
            return cache.toString();
        }
        return new GsonBuilder().create().toJson((Object)this);
    }

    protected void saveTokens(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environment) {
        TokenCacheAccessContext context;
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(tokenRequest.getMsalRequest().application().clientId()).tokenCache(this).build();
            this.tokenCacheAccessAspect.beforeCacheAccess(context);
        }
        if (!StringHelper.isBlank(authenticationResult.accessToken())) {
            AccessTokenCacheEntity atEntity = TokenCache.createAccessTokenCacheEntity(tokenRequest, authenticationResult, environment);
            this.accessTokens.put(atEntity.getKey(), atEntity);
        }
        if (!StringHelper.isBlank(authenticationResult.familyId())) {
            AppMetadataCacheEntity appMetadataCacheEntity = TokenCache.createAppMetadataCacheEntity(tokenRequest, authenticationResult, environment);
            this.appMetadata.put(appMetadataCacheEntity.getKey(), appMetadataCacheEntity);
        }
        if (!StringHelper.isBlank(authenticationResult.refreshToken())) {
            RefreshTokenCacheEntity rtEntity = TokenCache.createRefreshTokenCacheEntity(tokenRequest, authenticationResult, environment);
            rtEntity.family_id(authenticationResult.familyId());
            this.refreshTokens.put(rtEntity.getKey(), rtEntity);
        }
        if (!StringHelper.isBlank(authenticationResult.idToken())) {
            IdTokenCacheEntity idTokenEntity = TokenCache.createIdTokenCacheEntity(tokenRequest, authenticationResult, environment);
            this.idTokens.put(idTokenEntity.getKey(), idTokenEntity);
            AccountCacheEntity accountCacheEntity = authenticationResult.accountCacheEntity();
            accountCacheEntity.environment(environment);
            this.accounts.put(accountCacheEntity.getKey(), accountCacheEntity);
        }
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(tokenRequest.getMsalRequest().application().clientId()).tokenCache(this).hasCacheChanged(true).build();
            this.tokenCacheAccessAspect.afterCacheAccess(context);
        }
    }

    static RefreshTokenCacheEntity createRefreshTokenCacheEntity(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environmentAlias) {
        RefreshTokenCacheEntity rt = new RefreshTokenCacheEntity();
        rt.credentialType(CredentialTypeEnum.REFRESH_TOKEN.value());
        if (authenticationResult.account() != null) {
            rt.homeAccountId(authenticationResult.account().homeAccountId());
        }
        rt.environment(environmentAlias);
        rt.clientId(tokenRequest.getMsalRequest().application().clientId());
        rt.secret(authenticationResult.refreshToken());
        return rt;
    }

    static AccessTokenCacheEntity createAccessTokenCacheEntity(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environmentAlias) {
        AccessTokenCacheEntity at = new AccessTokenCacheEntity();
        at.credentialType(CredentialTypeEnum.ACCESS_TOKEN.value());
        if (authenticationResult.account() != null) {
            at.homeAccountId(authenticationResult.account().homeAccountId());
        }
        at.environment(environmentAlias);
        at.clientId(tokenRequest.getMsalRequest().application().clientId());
        at.secret(authenticationResult.accessToken());
        IdToken idTokenObj = authenticationResult.idTokenObject();
        if (idTokenObj != null) {
            at.realm(idTokenObj.tenantIdentifier);
        }
        String scopes = !StringHelper.isBlank(authenticationResult.scopes()) ? authenticationResult.scopes() : tokenRequest.getMsalRequest().msalAuthorizationGrant().getScopes();
        at.target(scopes);
        long currTimestampSec = System.currentTimeMillis() / 1000L;
        at.cachedAt(Long.toString(currTimestampSec));
        at.expiresOn(Long.toString(authenticationResult.expiresOn()));
        if (authenticationResult.extExpiresOn() > 0L) {
            at.extExpiresOn(Long.toString(authenticationResult.extExpiresOn()));
        }
        return at;
    }

    static IdTokenCacheEntity createIdTokenCacheEntity(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environmentAlias) {
        IdTokenCacheEntity idToken = new IdTokenCacheEntity();
        idToken.credentialType(CredentialTypeEnum.ID_TOKEN.value());
        if (authenticationResult.account() != null) {
            idToken.homeAccountId(authenticationResult.account().homeAccountId());
        }
        idToken.environment(environmentAlias);
        idToken.clientId(tokenRequest.getMsalRequest().application().clientId());
        idToken.secret(authenticationResult.idToken());
        IdToken idTokenObj = authenticationResult.idTokenObject();
        if (idTokenObj != null) {
            idToken.realm(idTokenObj.tenantIdentifier);
        }
        return idToken;
    }

    static AppMetadataCacheEntity createAppMetadataCacheEntity(TokenRequest tokenRequest, AuthenticationResult authenticationResult, String environmentAlias) {
        AppMetadataCacheEntity appMetadataCacheEntity = new AppMetadataCacheEntity();
        appMetadataCacheEntity.clientId(tokenRequest.getMsalRequest().application().clientId());
        appMetadataCacheEntity.environment(environmentAlias);
        appMetadataCacheEntity.familyId(authenticationResult.familyId());
        return appMetadataCacheEntity;
    }

    protected Set<IAccount> getAccounts(String clientId, Set<String> environmentAliases) {
        TokenCacheAccessContext context = null;
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(clientId).tokenCache(this).build();
            this.tokenCacheAccessAspect.beforeCacheAccess(context);
        }
        Set<IAccount> result = this.accounts.values().stream().filter(acc -> environmentAliases.contains(acc.environment())).collect(Collectors.mapping(AccountCacheEntity::toAccount, Collectors.toSet()));
        if (this.tokenCacheAccessAspect != null) {
            this.tokenCacheAccessAspect.afterCacheAccess(context);
        }
        return result;
    }

    String getApplicationFamilyId(String clientId, Set<String> environmentAliases) {
        for (AppMetadataCacheEntity data : this.appMetadata.values()) {
            if (!data.clientId().equals(clientId) || !environmentAliases.contains(data.environment()) || StringHelper.isBlank(data.familyId())) continue;
            return data.familyId();
        }
        return null;
    }

    Set<String> getFamilyClientIds(String familyId, Set<String> environmentAliases) {
        return this.appMetadata.values().stream().filter(appMetadata -> environmentAliases.contains(appMetadata.environment()) && familyId.equals(appMetadata.familyId())).map(AppMetadataCacheEntity::clientId).collect(Collectors.toSet());
    }

    protected void removeAccount(String clientId, IAccount account, Set<String> environmentAliases) {
        TokenCacheAccessContext context = null;
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(clientId).tokenCache(this).build();
            this.tokenCacheAccessAspect.beforeCacheAccess(context);
        }
        this.removeAccount(account, environmentAliases);
        if (this.tokenCacheAccessAspect != null) {
            this.tokenCacheAccessAspect.afterCacheAccess(context);
        }
    }

    private void removeAccount(IAccount account, Set<String> environmentAliases) {
        Predicate<Map.Entry> credentialToRemovePredicate = e -> !StringHelper.isBlank(((Credential)e.getValue()).homeAccountId()) && !StringHelper.isBlank(((Credential)e.getValue()).environment()) && ((Credential)e.getValue()).homeAccountId().equals(account.homeAccountId()) && environmentAliases.contains(((Credential)e.getValue()).environment());
        this.accessTokens.entrySet().removeIf(credentialToRemovePredicate);
        this.refreshTokens.entrySet().removeIf(credentialToRemovePredicate);
        this.idTokens.entrySet().removeIf(credentialToRemovePredicate);
        this.accounts.entrySet().removeIf(e -> !StringHelper.isBlank(((AccountCacheEntity)e.getValue()).homeAccountId()) && !StringHelper.isBlank(((AccountCacheEntity)e.getValue()).environment()) && ((AccountCacheEntity)e.getValue()).homeAccountId().equals(account.homeAccountId()) && environmentAliases.contains(((AccountCacheEntity)e.getValue()).environment));
    }

    boolean isMatchingScopes(AccessTokenCacheEntity accessTokenCacheEntity, Set<String> scopes) {
        TreeSet<String> accessTokenCacheEntityScopes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        accessTokenCacheEntityScopes.addAll(Arrays.asList(accessTokenCacheEntity.target().split(" ")));
        return accessTokenCacheEntityScopes.containsAll(scopes);
    }

    Optional<AccessTokenCacheEntity> getAccessTokenCacheEntity(IAccount account, Authority authority, Set<String> scopes, String clientId, Set<String> environmentAliases) {
        long currTimeStampSec = new Date().getTime() / 1000L;
        return this.accessTokens.values().stream().filter(accessToken -> accessToken.homeAccountId.equals(account.homeAccountId()) && environmentAliases.contains(accessToken.environment) && Long.parseLong(accessToken.expiresOn()) > currTimeStampSec + 300L && accessToken.realm.equals(authority.tenant()) && accessToken.clientId.equals(clientId) && this.isMatchingScopes((AccessTokenCacheEntity)accessToken, scopes)).findAny();
    }

    Optional<IdTokenCacheEntity> getIdTokenCacheEntity(IAccount account, Authority authority, String clientId, Set<String> environmentAliases) {
        return this.idTokens.values().stream().filter(idToken -> idToken.homeAccountId.equals(account.homeAccountId()) && environmentAliases.contains(idToken.environment) && idToken.realm.equals(authority.tenant()) && idToken.clientId.equals(clientId)).findAny();
    }

    Optional<RefreshTokenCacheEntity> getRefreshTokenCacheEntity(IAccount account, String clientId, Set<String> environmentAliases) {
        return this.refreshTokens.values().stream().filter(refreshToken -> refreshToken.homeAccountId.equals(account.homeAccountId()) && environmentAliases.contains(refreshToken.environment) && refreshToken.clientId.equals(clientId)).findAny();
    }

    Optional<AccountCacheEntity> getAccountCacheEntity(IAccount account, Set<String> environmentAliases) {
        return this.accounts.values().stream().filter(acc -> acc.homeAccountId.equals(account.homeAccountId()) && environmentAliases.contains(acc.environment)).findAny();
    }

    Optional<RefreshTokenCacheEntity> getAnyFamilyRefreshTokenCacheEntity(IAccount account, Set<String> environmentAliases) {
        return this.refreshTokens.values().stream().filter(refreshToken -> refreshToken.homeAccountId.equals(account.homeAccountId()) && environmentAliases.contains(refreshToken.environment) && refreshToken.isFamilyRT()).findAny();
    }

    AuthenticationResult getAuthenticationResult(IAccount account, Authority authority, Set<String> scopes, String clientId) {
        Optional<RefreshTokenCacheEntity> rtCacheEntity;
        TokenCacheAccessContext context = null;
        if (this.tokenCacheAccessAspect != null) {
            context = TokenCacheAccessContext.builder().clientId(clientId).tokenCache(this).account(account).build();
            this.tokenCacheAccessAspect.beforeCacheAccess(context);
        }
        Set<String> environmentAliases = AadInstanceDiscovery.cache.get(account.environment()).aliases();
        Optional<AccountCacheEntity> accountCacheEntity = this.getAccountCacheEntity(account, environmentAliases);
        Optional<AccessTokenCacheEntity> atCacheEntity = this.getAccessTokenCacheEntity(account, authority, scopes, clientId, environmentAliases);
        Optional<IdTokenCacheEntity> idTokenCacheEntity = this.getIdTokenCacheEntity(account, authority, clientId, environmentAliases);
        if (!StringHelper.isBlank(this.getApplicationFamilyId(clientId, environmentAliases))) {
            rtCacheEntity = this.getAnyFamilyRefreshTokenCacheEntity(account, environmentAliases);
            if (!rtCacheEntity.isPresent()) {
                rtCacheEntity = this.getRefreshTokenCacheEntity(account, clientId, environmentAliases);
            }
        } else {
            rtCacheEntity = this.getRefreshTokenCacheEntity(account, clientId, environmentAliases);
            if (!rtCacheEntity.isPresent()) {
                rtCacheEntity = this.getAnyFamilyRefreshTokenCacheEntity(account, environmentAliases);
            }
        }
        if (this.tokenCacheAccessAspect != null) {
            this.tokenCacheAccessAspect.afterCacheAccess(context);
        }
        AuthenticationResult.AuthenticationResultBuilder builder = AuthenticationResult.builder();
        if (atCacheEntity.isPresent()) {
            builder.accessToken(atCacheEntity.get().secret).expiresOn(Long.parseLong(atCacheEntity.get().expiresOn()));
        }
        if (idTokenCacheEntity.isPresent()) {
            builder.idToken(idTokenCacheEntity.get().secret);
        }
        if (rtCacheEntity.isPresent()) {
            builder.refreshToken(rtCacheEntity.get().secret);
        }
        if (accountCacheEntity.isPresent()) {
            builder.accountCacheEntity(accountCacheEntity.get());
        }
        builder.environment(authority.host());
        return builder.build();
    }
}

