/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;

public class FileUploadResponseParser {
    private static final String CORRELATION_ID_TAG = "correlationId";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="correlationId")
    private String correlationId = null;
    private static final String HOST_NAME_TAG = "hostName";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="hostName")
    private String hostName = null;
    private static final String CONTAINER_NAME_TAG = "containerName";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="containerName")
    private String containerName = null;
    private static final String BLOB_NAME_TAG = "blobName";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="blobName")
    private String blobName = null;
    private static final String SAS_TOKEN_TAG = "sasToken";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="sasToken")
    private String sasToken = null;

    public FileUploadResponseParser(String json) throws IllegalArgumentException {
        FileUploadResponseParser newFileUploadResponseParser;
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        ParserUtility.validateStringUTF8(json);
        try {
            newFileUploadResponseParser = (FileUploadResponseParser)gson.fromJson(json, FileUploadResponseParser.class);
        }
        catch (JsonSyntaxException malformed) {
            throw new IllegalArgumentException("Malformed json:" + (Object)((Object)malformed));
        }
        ParserUtility.validateStringUTF8(newFileUploadResponseParser.hostName);
        ParserUtility.validateStringUTF8(newFileUploadResponseParser.containerName);
        ParserUtility.validateStringUTF8(newFileUploadResponseParser.correlationId);
        ParserUtility.validateBlobName(newFileUploadResponseParser.blobName);
        ParserUtility.validateStringUTF8(newFileUploadResponseParser.sasToken);
        this.hostName = newFileUploadResponseParser.hostName;
        this.containerName = newFileUploadResponseParser.containerName;
        this.correlationId = newFileUploadResponseParser.correlationId;
        this.blobName = newFileUploadResponseParser.blobName;
        this.sasToken = newFileUploadResponseParser.sasToken;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getBlobName() {
        return this.blobName;
    }

    public String getSasToken() {
        return this.sasToken;
    }

    protected FileUploadResponseParser() {
    }
}

