/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinConnectionState;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinStatus;

public class RegisterManagerParser {
    @SerializedName(value="deviceId")
    protected String deviceId = null;
    @SerializedName(value="generationId")
    protected String generationId = null;
    @SerializedName(value="etag")
    protected String eTag = null;
    @SerializedName(value="version")
    protected Integer version = null;
    @SerializedName(value="status")
    protected TwinStatus status = null;
    @SerializedName(value="statusReason")
    protected String statusReason = null;
    @SerializedName(value="statusUpdatedTime")
    protected String statusUpdatedTime = null;
    @SerializedName(value="connectionState")
    protected TwinConnectionState connectionState = null;
    @SerializedName(value="connectionStateUpdatedTime")
    protected String connectionStateUpdatedTime = null;
    @SerializedName(value="lastActivityTime")
    protected String lastActivityTime = null;

    protected boolean setDeviceId(String deviceId) throws IllegalArgumentException {
        this.validateDeviceManager(deviceId, null, null);
        if (this.deviceId == null || deviceId == null || !this.deviceId.equals(deviceId)) {
            this.deviceId = deviceId;
            if (this.deviceId != null) {
                return true;
            }
        }
        return false;
    }

    protected boolean setStatus(TwinStatus status, String statusReason) throws IllegalArgumentException {
        this.validateDeviceManager(null, status, statusReason);
        if (status == null) {
            if (this.status != null) {
                return true;
            }
            this.status = null;
            this.statusReason = null;
            this.statusUpdatedTime = null;
        } else {
            if (statusReason == null) {
                throw new IllegalArgumentException("Change status without statusReason");
            }
            if (this.status == null || !this.status.equals((Object)status)) {
                this.status = status;
                this.statusReason = statusReason;
                return true;
            }
        }
        return false;
    }

    protected void validateDeviceManager(String deviceId, TwinStatus status, String statusReason) throws IllegalArgumentException {
        if (deviceId != null && deviceId.length() > 128) {
            throw new IllegalArgumentException("DeviceId bigger than 128 chars");
        }
        if (status != null && statusReason == null) {
            throw new IllegalArgumentException("Change status without statusReason");
        }
        if (statusReason != null && statusReason.length() > 128) {
            throw new IllegalArgumentException("StatusReason bigger than 128 chars");
        }
    }
}

