/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinChangedCallback;
import java.util.HashMap;
import java.util.Map;

public class TwinTags {
    private static final String VERSION_TAG = "$version";
    private static final String METADATA_TAG = "$metadata";
    private static final int MAX_PROPERTY_LEVEL = 5;
    private static final int MAX_METADATA_LEVEL = 7;
    private Map<String, Object> tags = new HashMap<String, Object>();

    protected TwinTags() {
    }

    protected synchronized JsonElement update(Map<String, Object> tagsMap) throws IllegalArgumentException {
        JsonElement innerDiff = this.updateFromMap(tagsMap, this.tags);
        if (innerDiff == null || innerDiff.toString().equals("{}")) {
            return null;
        }
        return innerDiff;
    }

    private synchronized JsonElement updateFromMap(Map<String, Object> newMap, Map<String, Object> oldMap) throws IllegalArgumentException {
        JsonObject diffJson = new JsonObject();
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            String key = entry.getKey();
            Object newValue = entry.getValue();
            Object oldValue = oldMap.get(key);
            if (newValue == null) {
                oldMap.remove(key);
                diffJson.add(key, null);
                continue;
            }
            if (!oldMap.containsKey(key)) {
                if (newValue instanceof Map) {
                    oldMap.put(key, new HashMap());
                    diffJson.add(key, this.updateFromMap((Map)newValue, (Map)oldMap.get(key)));
                    continue;
                }
                oldMap.put(key, newValue);
                this.addProperty(diffJson, key, newValue);
                continue;
            }
            if (newValue instanceof Map) {
                JsonElement innerDiff;
                if (!(oldValue instanceof Map)) {
                    oldMap.put(key, new HashMap());
                }
                if ((innerDiff = this.updateFromMap((Map)newValue, (Map)oldMap.get(key))) == null || innerDiff.toString().equals("{}")) continue;
                diffJson.add(key, innerDiff);
                continue;
            }
            if (newValue.equals(oldValue)) continue;
            oldMap.put(key, newValue);
            this.addProperty(diffJson, key, newValue);
        }
        return diffJson;
    }

    private void addProperty(JsonObject diffJson, String key, Object newValue) throws IllegalArgumentException {
        if (newValue instanceof Number) {
            diffJson.addProperty(key, (Number)newValue);
        } else if (newValue instanceof Boolean) {
            diffJson.addProperty(key, (Boolean)newValue);
        } else if (newValue instanceof Character) {
            diffJson.addProperty(key, (Character)newValue);
        } else {
            if (newValue.getClass().isLocalClass() || newValue.getClass().isArray()) {
                throw new IllegalArgumentException("Type not supported");
            }
            diffJson.addProperty(key, newValue.toString());
        }
    }

    protected synchronized Map<String, Object> getMap() {
        return this.tags;
    }

    protected String toJson() {
        Gson gson = new GsonBuilder().create();
        return gson.toJson(this.tags);
    }

    protected JsonElement toJsonElement() {
        Gson gson = new GsonBuilder().create();
        return gson.toJsonTree(this.tags);
    }

    protected void update(Map<String, Object> tagsMap, TwinChangedCallback onTagsCallback) {
        Map<String, Object> diffMap = this.updateFromJson(tagsMap, this.tags);
        if (diffMap != null && onTagsCallback != null) {
            onTagsCallback.execute(diffMap);
        }
    }

    protected void validate(Map<String, Object> tagsMap) {
        if (tagsMap == null) {
            throw new IllegalArgumentException("property cannot be null");
        }
        for (Map.Entry<String, Object> entry : tagsMap.entrySet()) {
            if (entry.getKey().equals(METADATA_TAG)) {
                if (!(entry.getValue() instanceof Map)) continue;
                ParserUtility.validateMap((Map)entry.getValue(), 7, true);
                continue;
            }
            if (entry.getKey().equals(VERSION_TAG) || !(entry.getValue() instanceof Map)) continue;
            ParserUtility.validateMap((Map)entry.getValue(), 5, false);
        }
    }

    private synchronized Map<String, Object> updateFromJson(Map<String, Object> newMap, Map<String, Object> oldMap) throws IllegalArgumentException {
        HashMap<String, Object> diffMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : newMap.entrySet()) {
            String key = entry.getKey();
            Object newValue = entry.getValue();
            Object oldValue = oldMap.get(key);
            if (!oldMap.containsKey(key)) {
                if (newValue == null) continue;
                oldMap.put(key, newValue);
                diffMap.put(key, newValue);
                continue;
            }
            if (newValue == null) {
                oldMap.remove(key);
                diffMap.put(key, null);
                continue;
            }
            if (newValue instanceof Map) {
                if (oldValue instanceof Map) {
                    Map<String, Object> innerDiffMap = this.updateFromJson((Map)newValue, (Map)oldValue);
                    if (innerDiffMap == null) continue;
                    diffMap.put(key, innerDiffMap);
                    continue;
                }
                oldMap.put(key, newValue);
                diffMap.put(key, newValue);
                continue;
            }
            oldMap.put(key, newValue);
            diffMap.put(key, newValue);
        }
        if (diffMap.size() == 0) {
            diffMap = null;
        }
        return diffMap;
    }
}

