/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinChangedCallback;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinProperty;
import java.util.Map;

public class TwinProperties {
    private TwinProperty desired = new TwinProperty();
    private TwinProperty reported = new TwinProperty();
    private static final String DESIRED_TAG = "desired";
    private static final String REPORTED_TAG = "reported";

    protected void enableDesiredMetadata() {
        this.desired.enableMetadata();
    }

    protected void enableReportedMetadata() {
        this.reported.enableMetadata();
    }

    protected JsonElement updateDesired(Map<String, Object> property) {
        return this.desired.update(property);
    }

    protected JsonElement updateReported(Map<String, Object> property) {
        return this.reported.update(property);
    }

    protected JsonElement resetDesired(Map<String, Object> property) {
        this.desired = new TwinProperty();
        return this.desired.update(property);
    }

    protected JsonElement resetReported(Map<String, Object> property) {
        this.reported = new TwinProperty();
        return this.reported.update(property);
    }

    protected void clearDesired() {
        this.desired = new TwinProperty();
    }

    protected void clearReported() {
        this.reported = new TwinProperty();
    }

    protected void updateDesired(String json, TwinChangedCallback onDesiredCallback) {
        this.desired.update(json, onDesiredCallback);
    }

    protected void updateReported(String json, TwinChangedCallback onDesiredCallback) {
        this.reported.update(json, onDesiredCallback);
    }

    protected Integer getDesiredVersion() {
        return this.desired.getVersion();
    }

    protected Integer getReportedVersion() {
        return this.reported.getVersion();
    }

    protected Map<String, Object> getDesiredPropertyMap() {
        return this.desired.getPropertyMap();
    }

    protected Map<String, Object> getReportedPropertyMap() {
        return this.reported.getPropertyMap();
    }

    protected String toJson() {
        return this.toJsonElement().toString();
    }

    protected JsonElement toJsonElement() {
        JsonObject propertiesJson = new JsonObject();
        JsonElement desiredElement = this.desired.toJsonElement();
        propertiesJson.add(DESIRED_TAG, desiredElement);
        JsonElement reportedElement = this.reported.toJsonElement();
        propertiesJson.add(REPORTED_TAG, reportedElement);
        return propertiesJson;
    }

    protected void update(Map<String, Object> jsonTree, TwinChangedCallback onDesiredCallback, TwinChangedCallback onReportedCallback) throws IllegalArgumentException {
        for (Map.Entry<String, Object> entry : jsonTree.entrySet()) {
            if (entry.getKey().equals(DESIRED_TAG)) {
                this.desired.update((Map)entry.getValue(), onDesiredCallback);
                continue;
            }
            if (entry.getKey().equals(REPORTED_TAG)) {
                this.reported.update((Map)entry.getValue(), onReportedCallback);
                continue;
            }
            throw new IllegalArgumentException("Invalid Property");
        }
    }

    protected void validate(Map<String, Object> jsonTree) throws IllegalArgumentException {
        for (Map.Entry<String, Object> entry : jsonTree.entrySet()) {
            if (entry.getKey().equals(DESIRED_TAG)) {
                this.desired.validate((Map)entry.getValue());
                continue;
            }
            if (entry.getKey().equals(REPORTED_TAG)) {
                this.reported.validate((Map)entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Invalid Property");
        }
    }
}

