/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import java.util.LinkedList;
import java.util.List;

public class QueryResponseParser {
    private Gson gson;
    private JsonObject[] jsonItems = null;

    public QueryResponseParser(String json) throws IllegalArgumentException {
        this.gson = new GsonBuilder().disableHtmlEscaping().create();
        ParserUtility.validateStringUTF8(json);
        try {
            this.jsonItems = (JsonObject[])this.gson.fromJson(json, JsonObject[].class);
        }
        catch (JsonSyntaxException malformed) {
            throw new IllegalArgumentException("Malformed json:" + (Object)((Object)malformed));
        }
    }

    public List<String> getJsonItems() {
        LinkedList<String> jsonElements = new LinkedList<String>();
        for (JsonObject json : this.jsonItems) {
            jsonElements.add(this.gson.toJson((JsonElement)json));
        }
        return jsonElements;
    }

    protected QueryResponseParser() {
    }
}

