/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.transport.http;

import com.microsoft.azure.sdk.iot.deps.transport.http.HttpMethod;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpConnection {
    protected final HttpsURLConnection connection;
    protected byte[] body;

    public HttpConnection(URL url, HttpMethod method) throws IOException {
        String protocol = url.getProtocol();
        if (!protocol.equalsIgnoreCase("HTTPS")) {
            String errMsg = String.format("Expected URL that uses iotHubServiceClientProtocol HTTPS but received one that uses iotHubServiceClientProtocol '%s'.\n", protocol);
            throw new IllegalArgumentException(errMsg);
        }
        this.connection = (HttpsURLConnection)url.openConnection();
        if (method == HttpMethod.PATCH) {
            this.setUnsupportedMethod(method);
            method = HttpMethod.POST;
        }
        this.connection.setRequestMethod(method.name());
        this.body = new byte[0];
    }

    private void setUnsupportedMethod(HttpMethod method) throws IOException {
        if (method != HttpMethod.PATCH) {
            throw new IOException("Unexpected Http Method " + (Object)((Object)method));
        }
        this.setRequestHeader("X-HTTP-Method-Override", "PATCH");
    }

    public void connect() throws IOException {
        if (this.body.length > 0) {
            this.connection.setDoOutput(true);
            this.connection.getOutputStream().write(this.body);
        }
        this.connection.connect();
    }

    public void setRequestMethod(HttpMethod method) {
        if (method != HttpMethod.POST && method != HttpMethod.PUT && this.body.length > 0) {
            throw new IllegalArgumentException("Cannot change the request method from POST or PUT when the request body is non-empty.");
        }
        try {
            this.connection.setRequestMethod(method.name());
        }
        catch (ProtocolException protocolException) {
            // empty catch block
        }
    }

    public void setRequestHeader(String field, String value) {
        this.connection.setRequestProperty(field, value);
    }

    public void setReadTimeoutMillis(int timeout) {
        this.connection.setReadTimeout(timeout);
    }

    public void writeOutput(byte[] body) {
        HttpMethod method = HttpMethod.valueOf(this.connection.getRequestMethod());
        if (method != HttpMethod.POST && method != HttpMethod.PUT) {
            if (body.length > 0) {
                throw new IllegalArgumentException("Cannot write a body to a request that is not a POST or a PUT request.");
            }
        } else {
            this.body = Arrays.copyOf(body, body.length);
        }
    }

    public byte[] readInput() throws IOException {
        InputStream inputStream = this.connection.getInputStream();
        byte[] input = HttpConnection.readInputStream(inputStream);
        inputStream.close();
        return input;
    }

    public byte[] readError() throws IOException {
        InputStream errorStream = this.connection.getErrorStream();
        byte[] error = new byte[]{};
        if (errorStream != null) {
            error = HttpConnection.readInputStream(errorStream);
            errorStream.close();
        }
        return error;
    }

    public int getResponseStatus() throws IOException {
        return this.connection.getResponseCode();
    }

    public Map<String, List<String>> getResponseHeaders() throws IOException {
        return this.connection.getHeaderFields();
    }

    protected static byte[] readInputStream(InputStream stream) throws IOException {
        ArrayList<Byte> byteBuffer = new ArrayList<Byte>();
        int nextByte = -1;
        while ((nextByte = stream.read()) > -1) {
            byteBuffer.add((byte)nextByte);
        }
        int bufferSize = byteBuffer.size();
        byte[] byteArray = new byte[bufferSize];
        for (int i = 0; i < bufferSize; ++i) {
            byteArray[i] = (Byte)byteBuffer.get(i);
        }
        return byteArray;
    }

    void setSSLContext(SSLContext sslContext) throws IllegalArgumentException {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSL context cannot be null");
        }
        this.connection.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    protected HttpConnection() {
        this.connection = null;
    }
}

