/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.auth;

import com.microsoft.azure.sdk.iot.deps.auth.IotHubCertificateManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class IotHubSSLContext {
    private SSLContext sslContext = null;
    private static final String SSL_CONTEXT_INSTANCE = "TLSv1.2";
    private static final String CERTIFICATE_ALIAS = "cert-alias";
    private static final String PRIVATE_KEY_ALIAS = "key-alias";
    private static final String TRUSTED_IOT_HUB_CERT_PREFIX = "trustedIotHubCert-";

    public IotHubSSLContext() throws KeyStoreException, KeyManagementException, IOException, CertificateException, NoSuchAlgorithmException {
        IotHubCertificateManager defaultCert = new IotHubCertificateManager();
        this.generateDefaultSSLContext(defaultCert);
    }

    public IotHubSSLContext(SSLContext sslContext) {
        if (sslContext == null) {
            throw new IllegalArgumentException("sslContext cannot be null");
        }
        this.sslContext = sslContext;
    }

    public IotHubSSLContext(String trustedCert, boolean isPath) throws KeyStoreException, KeyManagementException, IOException, CertificateException, NoSuchAlgorithmException {
        IotHubCertificateManager defaultCert = new IotHubCertificateManager();
        if (isPath) {
            defaultCert.setValidCertPath(trustedCert);
        } else {
            defaultCert.setValidCert(trustedCert);
        }
        this.generateDefaultSSLContext(defaultCert);
    }

    public IotHubSSLContext(String publicKeyCertificateString, String privateKeyString, String cert, boolean isPath) throws KeyStoreException, KeyManagementException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        IotHubCertificateManager defaultCert = new IotHubCertificateManager();
        if (isPath) {
            defaultCert.setValidCertPath(cert);
        } else {
            defaultCert.setValidCert(cert);
        }
        this.generateSSLContextWithKeys(publicKeyCertificateString, privateKeyString, defaultCert);
    }

    public IotHubSSLContext(String publicKeyCertificateString, String privateKeyString) throws KeyManagementException, IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.generateSSLContextWithKeys(publicKeyCertificateString, privateKeyString, new IotHubCertificateManager());
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    private void generateSSLContextWithKeys(String publicKeyCertificateString, String privateKeyString, IotHubCertificateManager certificateManager) throws KeyManagementException, IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Key privateKey = IotHubSSLContext.parsePrivateKey(privateKeyString);
        Collection<X509Certificate> certChain = IotHubSSLContext.parsePublicKeyCertificate(publicKeyCertificateString);
        Certificate[] certs = certChain.toArray(new X509Certificate[certChain.size()]);
        char[] temporaryPassword = this.generateTemporaryPassword();
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(null);
        keystore.setCertificateEntry(CERTIFICATE_ALIAS, certs[0]);
        keystore.setKeyEntry(PRIVATE_KEY_ALIAS, privateKey, temporaryPassword, certs);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keystore, temporaryPassword);
        TrustManagerFactory trustManagerFactory = this.generateTrustManagerFactory(certificateManager, keystore);
        this.sslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE);
        this.sslContext.init(kmf.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
    }

    private void generateDefaultSSLContext(IotHubCertificateManager certificateManager) throws KeyStoreException, IOException, CertificateException, KeyManagementException, NoSuchAlgorithmException {
        this.sslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE);
        TrustManagerFactory trustManagerFactory = this.generateTrustManagerFactory(certificateManager, null);
        this.sslContext.init(null, trustManagerFactory.getTrustManagers(), new SecureRandom());
    }

    private TrustManagerFactory generateTrustManagerFactory(IotHubCertificateManager certificateManager, KeyStore trustKeyStore) throws NoSuchAlgorithmException, KeyStoreException, IOException, CertificateException {
        if (trustKeyStore == null) {
            trustKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustKeyStore.load(null);
        }
        for (Certificate certificate : certificateManager.getCertificateCollection()) {
            trustKeyStore.setCertificateEntry(TRUSTED_IOT_HUB_CERT_PREFIX + UUID.randomUUID(), certificate);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustKeyStore);
        return trustManagerFactory;
    }

    private char[] generateTemporaryPassword() {
        return UUID.randomUUID().toString().toCharArray();
    }

    private static Key parsePrivateKey(String privateKeyString) throws CertificateException {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMParser privateKeyParser = new PEMParser((Reader)new StringReader(privateKeyString));
            Object possiblePrivateKey = privateKeyParser.readObject();
            return IotHubSSLContext.getPrivateKey(possiblePrivateKey);
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<X509Certificate> parsePublicKeyCertificate(String publicKeyCertificateString) throws CertificateException {
        try {
            ArrayList<X509Certificate> certChain = new ArrayList<X509Certificate>();
            Security.addProvider((Provider)new BouncyCastleProvider());
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            try (PemReader publicKeyCertificateReader = new PemReader((Reader)new StringReader(publicKeyCertificateString));){
                byte[] content;
                PemObject possiblePublicKeyCertificate;
                while ((possiblePublicKeyCertificate = publicKeyCertificateReader.readPemObject()) != null && (content = possiblePublicKeyCertificate.getContent()).length > 0) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(content);
                    while (bais.available() > 0) {
                        Certificate cert = certFactory.generateCertificate(bais);
                        if (!(cert instanceof X509Certificate)) continue;
                        certChain.add((X509Certificate)cert);
                    }
                }
            }
            return certChain;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
    }

    private static Key getPrivateKey(Object possiblePrivateKey) throws IOException {
        if (possiblePrivateKey instanceof PEMKeyPair) {
            return new JcaPEMKeyConverter().setProvider("BC").getKeyPair((PEMKeyPair)possiblePrivateKey).getPrivate();
        }
        if (possiblePrivateKey instanceof PrivateKeyInfo) {
            return new JcaPEMKeyConverter().setProvider("BC").getPrivateKey((PrivateKeyInfo)possiblePrivateKey);
        }
        throw new IOException("Unable to parse private key, type unknown");
    }
}

