/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;

public class X509ThumbprintParser {
    private static final String PRIMARY_THUMBPRINT_SERIALIZED_NAME = "primaryThumbprint";
    @SerializedName(value="primaryThumbprint")
    private String primaryThumbprint;
    private static final String SECONDARY_THUMBPRINT_SERIALIZED_NAME = "secondaryThumbprint";
    @SerializedName(value="secondaryThumbprint")
    private String secondaryThumbprint;
    private transient Gson gson = new Gson();

    public X509ThumbprintParser() {
    }

    public X509ThumbprintParser(String primaryThumbprint, String secondaryThumbprint) {
        this.primaryThumbprint = primaryThumbprint;
        this.secondaryThumbprint = secondaryThumbprint;
    }

    public X509ThumbprintParser(String json) throws IllegalArgumentException {
        if (json == null || json.isEmpty()) {
            throw new IllegalArgumentException("The provided Json must not be null or empty");
        }
        X509ThumbprintParser parser = null;
        try {
            parser = (X509ThumbprintParser)this.gson.fromJson(json, X509ThumbprintParser.class);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("The provided json could not be parsed");
        }
        this.primaryThumbprint = parser.getPrimaryThumbprint();
        this.secondaryThumbprint = parser.getSecondaryThumbprint();
    }

    public String toJson() {
        return this.gson.toJson((Object)this);
    }

    public String getPrimaryThumbprint() {
        return this.primaryThumbprint;
    }

    public void setPrimaryThumbprint(String primaryThumbprint) throws IllegalArgumentException {
        if (primaryThumbprint == null) {
            throw new IllegalArgumentException("Primary thumbprint cannot be null or empty");
        }
        this.primaryThumbprint = primaryThumbprint;
    }

    public String getSecondaryThumbprint() {
        return this.secondaryThumbprint;
    }

    public void setSecondaryThumbprint(String secondaryThumbprint) throws IllegalArgumentException {
        if (secondaryThumbprint == null) {
            throw new IllegalArgumentException("Secondary thumbprint cannot be null or empty");
        }
        this.secondaryThumbprint = secondaryThumbprint;
    }
}

