/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.transport.http;

import com.microsoft.azure.sdk.iot.deps.transport.http.HttpConnection;
import com.microsoft.azure.sdk.iot.deps.transport.http.HttpMethod;
import com.microsoft.azure.sdk.iot.deps.transport.http.HttpResponse;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public class HttpRequest {
    protected final HttpConnection connection;

    public HttpRequest(URL url, HttpMethod method, byte[] body) throws IOException {
        this.connection = new HttpConnection(url, method);
        this.connection.writeOutput(body);
    }

    public HttpResponse send() throws IOException {
        Map<String, List<String>> headerFields;
        int responseStatus = -1;
        byte[] responseBody = new byte[]{};
        byte[] errorReason = new byte[]{};
        try {
            this.connection.connect();
            responseStatus = this.connection.getResponseStatus();
            headerFields = this.connection.getResponseHeaders();
            responseBody = this.connection.readInput();
        }
        catch (IOException e) {
            responseStatus = this.connection.getResponseStatus();
            headerFields = this.connection.getResponseHeaders();
            errorReason = this.connection.readError();
        }
        return new HttpResponse(responseStatus, responseBody, headerFields, errorReason);
    }

    public HttpRequest setHeaderField(String field, String value) {
        this.connection.setRequestHeader(field, value);
        return this;
    }

    public HttpRequest setReadTimeoutMillis(int timeout) {
        this.connection.setReadTimeoutMillis(timeout);
        return this;
    }

    public HttpRequest setSSLContext(SSLContext sslContext) {
        if (sslContext == null) {
            throw new IllegalArgumentException("Context cannot be null");
        }
        this.connection.setSSLContext(sslContext);
        return this;
    }

    protected HttpRequest() {
        this.connection = null;
    }
}

