/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.twin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.twin.TwinCollection;

public class TwinProperties {
    private static final String DESIRED_PROPERTIES_TAG = "desired";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="desired")
    private TwinCollection desired;
    private static final String REPORTED_PROPERTIES_TAG = "reported";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="reported")
    private TwinCollection reported;

    TwinProperties(TwinCollection desired, TwinCollection reported) {
        if (desired == null && reported == null) {
            throw new IllegalArgumentException("Desired property cannot be null.");
        }
        if (desired != null) {
            this.desired = TwinCollection.createFromRawCollection(desired);
        }
        if (reported != null) {
            this.reported = TwinCollection.createFromRawCollection(reported);
        }
    }

    protected JsonElement toJsonElement() {
        JsonObject twinJson = new JsonObject();
        if (this.desired != null) {
            twinJson.add(DESIRED_PROPERTIES_TAG, this.desired.toJsonElement());
        }
        if (this.reported != null) {
            twinJson.add(REPORTED_PROPERTIES_TAG, this.reported.toJsonElement());
        }
        return twinJson;
    }

    protected JsonElement toJsonElementWithMetadata() {
        JsonObject twinJson = new JsonObject();
        if (this.desired != null) {
            twinJson.add(DESIRED_PROPERTIES_TAG, this.desired.toJsonElementWithMetadata());
        }
        if (this.reported != null) {
            twinJson.add(REPORTED_PROPERTIES_TAG, this.reported.toJsonElementWithMetadata());
        }
        return twinJson;
    }

    public TwinCollection getDesired() {
        if (this.desired == null) {
            return null;
        }
        return new TwinCollection(this.desired);
    }

    public TwinCollection getReported() {
        if (this.reported == null) {
            return null;
        }
        return new TwinCollection(this.reported);
    }

    public String toString() {
        return this.toJsonElementWithMetadata().toString();
    }

    protected TwinProperties() {
    }
}

