/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.azure.sdk.iot.deps.serializer.MethodParser;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.serializer.TwinParser;
import com.microsoft.azure.sdk.iot.deps.twin.TwinState;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class JobsParser {
    private static final transient String DATEFORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final transient String TIMEZONE = "UTC";
    private static final transient String SCHEDULE_DEVICE_METHOD = "scheduleDeviceMethod";
    private static final transient String SCHEDULE_UPDATE_TWIN = "scheduleUpdateTwin";
    private static final String JOBID_TAG = "jobId";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="jobId")
    private String jobId;
    private static final String TYPE_TAG = "type";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="type")
    private String jobType;
    private static final String CLOUDTODEVICEMETHOD_TAG = "cloudToDeviceMethod";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="cloudToDeviceMethod")
    private JsonElement cloudToDeviceMethod = null;
    private static final String UPDATETWIN_TAG = "updateTwin";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="updateTwin")
    private JsonElement updateTwin = null;
    private static final String QUERYCONDITION_TAG = "queryCondition";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="queryCondition")
    private String queryCondition;
    private static final String STARTTIME_TAG = "startTime";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="startTime")
    private String startTime;
    private static final String MAXEXECUTIONTIMEINSECONDS_TAG = "maxExecutionTimeInSeconds";
    @Expose(serialize=true, deserialize=false)
    @SerializedName(value="maxExecutionTimeInSeconds")
    private long maxExecutionTimeInSeconds;

    public JobsParser(String jobId, MethodParser cloudToDeviceMethod, String queryCondition, Date startTime, long maxExecutionTimeInSeconds) throws IllegalArgumentException {
        if (cloudToDeviceMethod == null) {
            throw new IllegalArgumentException("Null cloudToDeviceMethod parameter");
        }
        this.validateCommonFields(jobId, queryCondition, startTime, maxExecutionTimeInSeconds);
        this.cloudToDeviceMethod = cloudToDeviceMethod.toJsonElement();
        this.jobType = SCHEDULE_DEVICE_METHOD;
        this.updateTwin = null;
    }

    @Deprecated
    public JobsParser(String jobId, TwinParser updateTwin, String queryCondition, Date startTime, long maxExecutionTimeInSeconds) throws IllegalArgumentException {
        if (updateTwin == null) {
            throw new IllegalArgumentException("Null TwinParser parameter");
        }
        this.validateCommonFields(jobId, queryCondition, startTime, maxExecutionTimeInSeconds);
        this.updateTwin = updateTwin.toJsonElement();
        this.jobType = SCHEDULE_UPDATE_TWIN;
        this.cloudToDeviceMethod = null;
    }

    public JobsParser(String jobId, TwinState updateTwin, String queryCondition, Date startTime, long maxExecutionTimeInSeconds) throws IllegalArgumentException {
        if (updateTwin == null) {
            throw new IllegalArgumentException("Null twinState parameter");
        }
        this.validateCommonFields(jobId, queryCondition, startTime, maxExecutionTimeInSeconds);
        this.updateTwin = updateTwin.toJsonElement();
        this.jobType = SCHEDULE_UPDATE_TWIN;
        this.cloudToDeviceMethod = null;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        return gson.toJson((Object)this);
    }

    private void validateCommonFields(String jobId, String queryCondition, Date startTime, long maxExecutionTimeInSeconds) throws IllegalArgumentException {
        ParserUtility.validateStringUTF8(jobId);
        if (startTime == null) {
            throw new IllegalArgumentException("Null start time");
        }
        if (maxExecutionTimeInSeconds < 0L) {
            throw new IllegalArgumentException("Negative max execution time in seconds");
        }
        this.jobId = jobId;
        this.queryCondition = queryCondition;
        this.maxExecutionTimeInSeconds = maxExecutionTimeInSeconds;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATEFORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone(TIMEZONE));
        this.startTime = dateFormat.format(startTime);
    }

    JobsParser() {
    }
}

