/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethodCallback;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.PropertyCallBack;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.TwinPropertyCallBack;
import com.microsoft.azure.sdk.iot.device.InternalClient;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStateCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.TransportClient;
import com.microsoft.azure.sdk.iot.device.fileupload.FileUpload;
import com.microsoft.azure.sdk.iot.device.transport.amqps.IoTHubConnectionType;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class DeviceClient
extends InternalClient
implements Closeable {
    @Deprecated
    public static final String HOSTNAME_ATTRIBUTE = "HostName=";
    @Deprecated
    public static final String DEVICE_ID_ATTRIBUTE = "DeviceId=";
    @Deprecated
    public static final String SHARED_ACCESS_KEY_ATTRIBUTE = "SharedAccessKey=";
    @Deprecated
    public static final String SHARED_ACCESS_TOKEN_ATTRIBUTE = "SharedAccessSignature=";
    @Deprecated
    public static final Charset CONNECTION_STRING_CHARSET = StandardCharsets.UTF_8;
    @Deprecated
    public static long SEND_PERIOD_MILLIS = 10L;
    @Deprecated
    public static long RECEIVE_PERIOD_MILLIS_AMQPS = 10L;
    @Deprecated
    public static long RECEIVE_PERIOD_MILLIS_MQTT = 10L;
    @Deprecated
    public static long RECEIVE_PERIOD_MILLIS_HTTPS = 1500000L;
    protected long RECEIVE_PERIOD_MILLIS;
    private IoTHubConnectionType ioTHubConnectionType = IoTHubConnectionType.UNKNOWN;
    private TransportClient transportClient;
    private FileUpload fileUpload;

    public DeviceClient(String connString, TransportClient transportClient) throws URISyntaxException, IllegalArgumentException, UnsupportedOperationException {
        this.config = new DeviceClientConfig(new IotHubConnectionString(connString));
        this.deviceIO = null;
        if (transportClient == null) {
            throw new IllegalArgumentException("Transport client cannot be null.");
        }
        this.ioTHubConnectionType = IoTHubConnectionType.USE_TRANSPORTCLIENT;
        this.transportClient = transportClient;
        String moduleId = this.getConfig().getModuleId();
        if (moduleId != null && !moduleId.isEmpty()) {
            throw new UnsupportedOperationException("Multiplexing with module connection strings is not supported");
        }
        this.getConfig().setProtocol(this.transportClient.getIotHubClientProtocol());
        this.transportClient.registerDeviceClient(this);
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClient object is created successfully, method name is %s ", this.logger.getMethodName());
    }

    public DeviceClient(String connString, IotHubClientProtocol protocol) throws URISyntaxException, IllegalArgumentException {
        super(new IotHubConnectionString(connString), protocol, SEND_PERIOD_MILLIS, DeviceClient.getReceivePeriod(protocol));
        this.commonConstructorVerifications();
        this.commonConstructorSetup();
    }

    public DeviceClient(String connString, IotHubClientProtocol protocol, String publicKeyCertificate, boolean isCertificatePath, String privateKey, boolean isPrivateKeyPath) throws URISyntaxException {
        super(new IotHubConnectionString(connString), protocol, publicKeyCertificate, isCertificatePath, privateKey, isPrivateKeyPath, SEND_PERIOD_MILLIS, DeviceClient.getReceivePeriod(protocol));
        this.commonConstructorVerifications();
        this.commonConstructorSetup();
    }

    public static DeviceClient createFromSecurityProvider(String uri, String deviceId, SecurityProvider securityProvider, IotHubClientProtocol protocol) throws URISyntaxException, IOException {
        return new DeviceClient(uri, deviceId, securityProvider, protocol);
    }

    public DeviceClient setMessageCallback(MessageCallback callback, Object context) throws IllegalArgumentException {
        this.setMessageCallbackInternal(callback, context);
        return this;
    }

    private DeviceClient(String uri, String deviceId, SecurityProvider securityProvider, IotHubClientProtocol protocol) throws URISyntaxException, IOException {
        super(uri, deviceId, securityProvider, protocol, SEND_PERIOD_MILLIS, DeviceClient.getReceivePeriod(protocol));
        this.commonConstructorSetup();
    }

    void closeFileUpload() throws IOException {
        if (this.fileUpload != null) {
            this.fileUpload.closeNow();
        }
    }

    private void commonConstructorSetup() {
        this.ioTHubConnectionType = IoTHubConnectionType.SINGLE_CLIENT;
        this.transportClient = null;
    }

    private void commonConstructorVerifications() throws UnsupportedOperationException {
        if (this.getConfig().getModuleId() != null && !this.getConfig().getModuleId().isEmpty()) {
            throw new UnsupportedOperationException("DeviceClient connection string cannot contain module id. Use ModuleClient instead.");
        }
    }

    @Override
    public void open() throws IOException {
        if (this.ioTHubConnectionType == IoTHubConnectionType.USE_TRANSPORTCLIENT) {
            if (this.transportClient.getTransportClientState() == TransportClient.TransportClientState.CLOSED) {
                throw new IOException("Calling open() when using the TransportClient is not supported. Use TransportClient.open() instead.");
            }
            this.logger.LogInfo("Connection already opened by TransportClient.", new Object[0]);
        } else {
            super.open();
        }
        this.logger.LogInfo("Connection opened with success, method name is %s ", this.logger.getMethodName());
    }

    @Override
    @Deprecated
    public void close() throws IOException {
        if (this.ioTHubConnectionType == IoTHubConnectionType.USE_TRANSPORTCLIENT) {
            if (this.transportClient.getTransportClientState() == TransportClient.TransportClientState.OPENED) {
                throw new IOException("Calling closeNow() when using TransportClient is not supported. Use TransportClient.closeNow() instead.");
            }
            this.logger.LogInfo("Connection already closed by TransportClient.", new Object[0]);
        } else {
            super.close();
        }
        this.logger.LogInfo("Connection closed with success, method name is %s ", this.logger.getMethodName());
    }

    @Override
    public void closeNow() throws IOException {
        if (this.ioTHubConnectionType == IoTHubConnectionType.USE_TRANSPORTCLIENT) {
            if (this.transportClient.getTransportClientState() == TransportClient.TransportClientState.OPENED) {
                throw new IOException("Calling closeNow() when using TransportClient is not supported. Use TransportClient.closeNow() instead.");
            }
            this.logger.LogInfo("Connection already closed by TransportClient.", new Object[0]);
        } else {
            super.closeNow();
            this.closeFileUpload();
        }
        this.logger.LogInfo("Connection closed with success, method name is %s ", this.logger.getMethodName());
    }

    public void uploadToBlobAsync(String destinationBlobName, InputStream inputStream, long streamLength, IotHubEventCallback callback, Object callbackContext) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        if (callback == null) {
            throw new IllegalArgumentException("Callback is null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("The input stream cannot be null.");
        }
        if (streamLength < 0L) {
            throw new IllegalArgumentException("Invalid stream size.");
        }
        ParserUtility.validateBlobName((String)destinationBlobName);
        if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
            throw new UnsupportedOperationException("File Upload does not support x509 authentication");
        }
        if (this.fileUpload == null) {
            this.fileUpload = new FileUpload(this.config);
        }
        this.fileUpload.uploadToBlobAsync(destinationBlobName, inputStream, streamLength, callback, callbackContext);
    }

    public void getDeviceTwin() throws IOException {
        this.getTwinInternal();
    }

    public void startDeviceTwin(IotHubEventCallback deviceTwinStatusCallback, Object deviceTwinStatusCallbackContext, PropertyCallBack genericPropertyCallBack, Object genericPropertyCallBackContext) throws IOException, IllegalArgumentException, UnsupportedOperationException {
        this.startTwinInternal(deviceTwinStatusCallback, deviceTwinStatusCallbackContext, genericPropertyCallBack, genericPropertyCallBackContext);
    }

    public void startDeviceTwin(IotHubEventCallback deviceTwinStatusCallback, Object deviceTwinStatusCallbackContext, TwinPropertyCallBack genericPropertyCallBack, Object genericPropertyCallBackContext) throws IOException, IllegalArgumentException, UnsupportedOperationException {
        this.startTwinInternal(deviceTwinStatusCallback, deviceTwinStatusCallbackContext, genericPropertyCallBack, genericPropertyCallBackContext);
    }

    @Deprecated
    public void registerConnectionStateCallback(IotHubConnectionStateCallback callback, Object callbackContext) throws IllegalArgumentException {
        if (null == callback) {
            throw new IllegalArgumentException("Callback object cannot be null");
        }
        this.deviceIO.registerConnectionStateCallback(callback, callbackContext);
    }

    public void subscribeToDeviceMethod(DeviceMethodCallback deviceMethodCallback, Object deviceMethodCallbackContext, IotHubEventCallback deviceMethodStatusCallback, Object deviceMethodStatusCallbackContext) throws IOException, IllegalArgumentException {
        this.subscribeToMethodsInternal(deviceMethodCallback, deviceMethodCallbackContext, deviceMethodStatusCallback, deviceMethodStatusCallbackContext);
    }

    @Override
    public void setOption(String optionName, Object value) throws IllegalArgumentException {
        if (optionName == null) {
            throw new IllegalArgumentException("optionName is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("optionName is null");
        }
        switch (optionName) {
            case "SetMinimumPollingInterval": {
                if (this.ioTHubConnectionType != IoTHubConnectionType.USE_TRANSPORTCLIENT) break;
                throw new IllegalStateException("setOption SetMinimumPollingIntervalonly works with HTTP protocol");
            }
            case "SetSendInterval": {
                if (this.ioTHubConnectionType == IoTHubConnectionType.USE_TRANSPORTCLIENT) {
                    throw new IllegalStateException("Setting send interval is not supported for single client if using TransportClient. Use TransportClient.setSendInterval() instead.");
                }
            }
            case "SetCertificatePath": {
                if (this.ioTHubConnectionType != IoTHubConnectionType.USE_TRANSPORTCLIENT) break;
                if (this.transportClient.getTransportClientState() == TransportClient.TransportClientState.OPENED) {
                    throw new IllegalStateException("setOption SetCertificatePath only works when the transport is closed");
                }
                this.setOption_SetCertificatePath(value);
                return;
            }
            case "SetSASTokenExpiryTime": {
                if (this.ioTHubConnectionType == IoTHubConnectionType.USE_TRANSPORTCLIENT) {
                    if (this.transportClient.getTransportClientState() == TransportClient.TransportClientState.OPENED) {
                        throw new IllegalStateException("setOption SetSASTokenExpiryTime with TransportClient only works when the transport client is closed");
                    }
                    this.setOption_SetSASTokenExpiryTime(value);
                    return;
                }
                this.setOption_SetSASTokenExpiryTime(value);
                return;
            }
            default: {
                throw new IllegalArgumentException("optionName is unknown = " + optionName);
            }
        }
        super.setOption(optionName, value);
    }

    @Override
    void setOption_SetSASTokenExpiryTime(Object value) throws IllegalArgumentException {
        this.logger.LogInfo("Setting SASTokenExpiryTime as %s seconds, method name is %s ", value, this.logger.getMethodName());
        if (this.getConfig().getAuthenticationType() != DeviceClientConfig.AuthType.SAS_TOKEN) {
            throw new IllegalStateException("Cannot set sas token validity time when not using sas token authentication");
        }
        if (value != null) {
            if (!(value instanceof Long)) {
                throw new IllegalArgumentException("value is not long = " + value);
            }
            long validTimeInSeconds = (Long)value;
            this.getConfig().getSasTokenAuthentication().setTokenValidSecs(validTimeInSeconds);
            if (this.getDeviceIO() != null && this.getDeviceIO().isOpen()) {
                try {
                    if (this.getConfig().getSasTokenAuthentication().canRefreshToken()) {
                        if (this.ioTHubConnectionType == IoTHubConnectionType.USE_TRANSPORTCLIENT) {
                            this.transportClient.closeNow();
                            this.transportClient.open();
                        } else {
                            this.getDeviceIO().close();
                            this.getDeviceIO().open();
                        }
                    }
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
    }

    private static long getReceivePeriod(IotHubClientProtocol protocol) {
        switch (protocol) {
            case HTTPS: {
                return RECEIVE_PERIOD_MILLIS_HTTPS;
            }
            case AMQPS: 
            case AMQPS_WS: {
                return RECEIVE_PERIOD_MILLIS_AMQPS;
            }
            case MQTT: 
            case MQTT_WS: {
                return RECEIVE_PERIOD_MILLIS_MQTT;
            }
        }
        throw new IllegalStateException("Invalid client protocol specified.");
    }

    protected DeviceClient() {
        this.transportClient = null;
    }
}

