/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Pair;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.ProductInfo;
import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenHardwareAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubSasTokenSoftwareAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubX509HardwareAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.auth.IotHubX509SoftwareAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.transport.ExponentialBackoffWithJitter;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderTpm;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProviderX509;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class DeviceClientConfig {
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = 240000;
    private static final int DEFAULT_MESSAGE_LOCK_TIMEOUT_SECS = 180;
    private static final long DEFAULT_OPERATION_TIMEOUT = 240000L;
    private boolean useWebsocket;
    private IotHubAuthenticationProvider authenticationProvider;
    private MessageCallback deviceMethodsMessageCallback;
    private Object deviceMethodsMessageContext;
    private MessageCallback deviceTwinMessageCallback;
    private Object deviceTwinMessageContext;
    private MessageCallback defaultDeviceTelemetryMessageCallback;
    private Object defaultDeviceTelemetryMessageContext;
    private Map<String, Pair<MessageCallback, Object>> inputChannelMessageCallbacks = new HashMap<String, Pair<MessageCallback, Object>>();
    private CustomLogger logger;
    private ProductInfo productInfo;
    private long operationTimeout = 240000L;
    private IotHubClientProtocol protocol;
    private RetryPolicy retryPolicy = new ExponentialBackoffWithJitter();

    public DeviceClientConfig(IotHubConnectionString iotHubConnectionString) throws IllegalArgumentException {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("connection string cannot be null");
        }
        if (iotHubConnectionString.isUsingX509()) {
            throw new IllegalArgumentException("Cannot use this constructor for x509 connection strings. Use constructor that takes public key certificate and private key instead");
        }
        this.useWebsocket = false;
        this.authenticationProvider = new IotHubSasTokenSoftwareAuthenticationProvider(iotHubConnectionString.getHostName(), iotHubConnectionString.getGatewayHostName(), iotHubConnectionString.getDeviceId(), iotHubConnectionString.getModuleId(), iotHubConnectionString.getSharedAccessKey(), iotHubConnectionString.getSharedAccessToken());
        this.productInfo = new ProductInfo();
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClientConfig object is created successfully with IotHubName=%s, deviceID=%s , method name is %s ", iotHubConnectionString.getHostName(), iotHubConnectionString.getDeviceId(), this.logger.getMethodName());
    }

    public DeviceClientConfig(IotHubAuthenticationProvider authenticationProvider) throws IllegalArgumentException {
        if (!(authenticationProvider instanceof IotHubSasTokenAuthenticationProvider)) {
            throw new UnsupportedOperationException("This constructor only support sas token authentication currently");
        }
        this.authenticationProvider = authenticationProvider;
        this.useWebsocket = false;
        this.productInfo = new ProductInfo();
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClientConfig object is created successfully with IotHubName=%s, deviceID=%s , method name is %s ", this.authenticationProvider.getHostname(), authenticationProvider.getDeviceId(), this.logger.getMethodName());
    }

    public DeviceClientConfig(IotHubConnectionString iotHubConnectionString, String publicKeyCertificate, boolean isPathForPublic, String privateKey, boolean isPathForPrivate) {
        if (iotHubConnectionString == null) {
            throw new IllegalArgumentException("connection string cannot be null");
        }
        if (!iotHubConnectionString.isUsingX509()) {
            throw new IllegalArgumentException("Cannot use this constructor for connection strings that don't use x509 authentication.");
        }
        this.productInfo = new ProductInfo();
        this.useWebsocket = false;
        this.authenticationProvider = new IotHubX509SoftwareAuthenticationProvider(iotHubConnectionString.getHostName(), iotHubConnectionString.getGatewayHostName(), iotHubConnectionString.getDeviceId(), iotHubConnectionString.getModuleId(), publicKeyCertificate, isPathForPublic, privateKey, isPathForPrivate);
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClientConfig object is created successfully with IotHubName=%s, deviceID=%s , method name is %s ", iotHubConnectionString.getHostName(), iotHubConnectionString.getDeviceId(), this.logger.getMethodName());
    }

    DeviceClientConfig(IotHubConnectionString connectionString, SecurityProvider securityProvider) throws IOException {
        if (connectionString == null) {
            throw new IllegalArgumentException("The provided connection string cannot be null");
        }
        if (securityProvider == null) {
            throw new IllegalArgumentException("security provider cannot be null");
        }
        if (securityProvider instanceof SecurityProviderTpm) {
            this.authenticationProvider = new IotHubSasTokenHardwareAuthenticationProvider(connectionString.getHostName(), connectionString.getGatewayHostName(), connectionString.getDeviceId(), connectionString.getModuleId(), securityProvider);
        } else if (securityProvider instanceof SecurityProviderX509) {
            this.authenticationProvider = new IotHubX509HardwareAuthenticationProvider(connectionString.getHostName(), connectionString.getGatewayHostName(), connectionString.getDeviceId(), connectionString.getModuleId(), securityProvider);
        } else {
            throw new UnsupportedOperationException("The provided security provider is not supported.");
        }
        this.useWebsocket = false;
        this.productInfo = new ProductInfo();
        this.logger = new CustomLogger(this.getClass());
        this.logger.LogInfo("DeviceClientConfig object is created successfully with IotHubName=%s, deviceID=%s , method name is %s ", connectionString.getHostName(), connectionString.getDeviceId(), this.logger.getMethodName());
    }

    public IotHubClientProtocol getProtocol() {
        return this.protocol;
    }

    void setProtocol(IotHubClientProtocol protocol) {
        this.protocol = protocol;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) throws IllegalArgumentException {
        if (retryPolicy == null) {
            throw new IllegalArgumentException("Retry Policy cannot be null.");
        }
        this.retryPolicy = retryPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public IotHubSasTokenAuthenticationProvider getSasTokenAuthentication() {
        if (this.authenticationProvider instanceof IotHubSasTokenAuthenticationProvider) {
            return (IotHubSasTokenAuthenticationProvider)this.authenticationProvider;
        }
        return null;
    }

    public IotHubAuthenticationProvider getAuthenticationProvider() {
        return this.authenticationProvider;
    }

    public boolean isUseWebsocket() {
        return this.useWebsocket;
    }

    public void setUseWebsocket(boolean useWebsocket) {
        this.useWebsocket = useWebsocket;
    }

    public void setMessageCallback(MessageCallback callback, Object context) {
        this.defaultDeviceTelemetryMessageCallback = callback;
        this.defaultDeviceTelemetryMessageContext = context;
    }

    public void setMessageCallback(String inputName, MessageCallback callback, Object context) {
        this.inputChannelMessageCallbacks.put(inputName, new Pair<MessageCallback, Object>(callback, context));
    }

    public String getIotHubHostname() {
        return this.authenticationProvider.getHostname();
    }

    public String getIotHubName() {
        return IotHubConnectionString.parseHubName(this.authenticationProvider.getHostname());
    }

    public String getGatewayHostname() {
        return this.authenticationProvider.getGatewayHostname();
    }

    public String getDeviceId() {
        return this.authenticationProvider.getDeviceId();
    }

    public String getModuleId() {
        return this.authenticationProvider.getModuleId();
    }

    public int getReadTimeoutMillis() {
        return 240000;
    }

    public MessageCallback getDeviceTelemetryMessageCallback(String inputName) {
        if (inputName == null || !this.inputChannelMessageCallbacks.containsKey(inputName)) {
            return this.defaultDeviceTelemetryMessageCallback;
        }
        return this.inputChannelMessageCallbacks.get(inputName).getKey();
    }

    public Object getDeviceTelemetryMessageContext(String inputName) {
        if (inputName == null || !this.inputChannelMessageCallbacks.containsKey(inputName)) {
            return this.defaultDeviceTelemetryMessageContext;
        }
        return this.inputChannelMessageCallbacks.get(inputName).getValue();
    }

    public void setDeviceMethodsMessageCallback(MessageCallback callback, Object context) {
        this.deviceMethodsMessageCallback = callback;
        this.deviceMethodsMessageContext = context;
    }

    public MessageCallback getDeviceMethodsMessageCallback() {
        return this.deviceMethodsMessageCallback;
    }

    public Object getDeviceMethodsMessageContext() {
        return this.deviceMethodsMessageContext;
    }

    public void setDeviceTwinMessageCallback(MessageCallback callback, Object context) {
        this.deviceTwinMessageCallback = callback;
        this.deviceTwinMessageContext = context;
    }

    public MessageCallback getDeviceTwinMessageCallback() {
        return this.deviceTwinMessageCallback;
    }

    public Object getDeviceTwinMessageContext() {
        return this.deviceTwinMessageContext;
    }

    public int getMessageLockTimeoutSecs() {
        return 180;
    }

    public AuthType getAuthenticationType() {
        if (this.authenticationProvider instanceof IotHubSasTokenAuthenticationProvider) {
            return AuthType.SAS_TOKEN;
        }
        return AuthType.X509_CERTIFICATE;
    }

    void setOperationTimeout(long timeout) throws IllegalArgumentException {
        if (timeout < 1L) {
            throw new IllegalArgumentException("Operation timeout cannot be 0 or negative");
        }
        this.operationTimeout = timeout;
    }

    public long getOperationTimeout() {
        return this.operationTimeout;
    }

    public ProductInfo getProductInfo() {
        return this.productInfo;
    }

    protected DeviceClientConfig() {
        this.authenticationProvider = null;
        this.deviceMethodsMessageCallback = null;
        this.defaultDeviceTelemetryMessageCallback = null;
        this.deviceTwinMessageCallback = null;
        this.deviceMethodsMessageContext = null;
        this.defaultDeviceTelemetryMessageContext = null;
        this.deviceTwinMessageContext = null;
        this.logger = null;
        this.useWebsocket = false;
    }

    public static enum AuthType {
        X509_CERTIFICATE,
        SAS_TOKEN;

    }
}

