/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.CustomLogger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class MessageProperty {
    public static final Set<String> RESERVED_PROPERTY_NAMES;
    public static final String OUTPUT_NAME_PROPERTY = "iothub-outputname";
    public static final String CONNECTION_DEVICE_ID = "iothub-connection-device-id";
    public static final String CONNECTION_MODULE_ID = "iothub-connection-module-id";
    public static final String IOTHUB_CONTENT_ENCODING = "iothub-contentencoding";
    public static final String IOTHUB_CONTENT_TYPE = "iothub-contenttype";
    private String name;
    private String value;
    private CustomLogger logger;

    public MessageProperty(String name, String value) {
        this.logger = new CustomLogger(this.getClass());
        if (name == null) {
            this.logger.LogError("Property argument 'name' cannot be null, method name is %s ", this.logger.getMethodName());
            throw new IllegalArgumentException("Property argument 'name' cannot be null.");
        }
        if (value == null) {
            this.logger.LogError("Property argument 'value' cannot be null, method name is %s ", this.logger.getMethodName());
            throw new IllegalArgumentException("Property argument 'value' cannot be null.");
        }
        if (!MessageProperty.usesValidChars(name)) {
            this.logger.LogError("%s is not a valid IoT Hub message property name, method name is %s ", name, this.logger.getMethodName());
            String errMsg = String.format("%s is not a valid IoT Hub message property name. %n", name);
            throw new IllegalArgumentException(errMsg);
        }
        if (RESERVED_PROPERTY_NAMES.contains(name)) {
            this.logger.LogError("%s is a reserved IoT Hub message property name, method name is %s ", name, this.logger.getMethodName());
            String errMsg = String.format("%s is a reserved IoT Hub message property name.%n", name);
            throw new IllegalArgumentException(errMsg);
        }
        if (!MessageProperty.usesValidChars(value)) {
            this.logger.LogError("%s is not a valid IoT Hub message property value, method name is %s ", value, this.logger.getMethodName());
            String errMsg = String.format("%s is not a valid IoT Hub message property value.%n", value);
            throw new IllegalArgumentException(errMsg);
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasSameName(String name) {
        boolean nameMatches = false;
        if (this.getName().equalsIgnoreCase(name)) {
            nameMatches = true;
        }
        return nameMatches;
    }

    public static boolean isValidAppProperty(String name, String value) {
        boolean propertyIsValid = false;
        if (!RESERVED_PROPERTY_NAMES.contains(name) && MessageProperty.usesValidChars(name) && MessageProperty.usesValidChars(value)) {
            propertyIsValid = true;
        }
        return propertyIsValid;
    }

    public static boolean isValidSystemProperty(String name, String value) {
        boolean propertyIsValid = false;
        if (RESERVED_PROPERTY_NAMES.contains(name) && MessageProperty.usesValidChars(name) && MessageProperty.usesValidChars(value)) {
            propertyIsValid = true;
        }
        return propertyIsValid;
    }

    private static boolean usesValidChars(String s) {
        boolean isValid = false;
        if (s.matches("\\p{ASCII}*")) {
            isValid = true;
        }
        return isValid;
    }

    protected MessageProperty() {
        this.name = null;
        this.value = null;
    }

    static {
        HashSet<String> reservedPropertyNames = new HashSet<String>();
        reservedPropertyNames.add("iothub-enqueuedtime");
        reservedPropertyNames.add("iothub-messagelocktoken");
        reservedPropertyNames.add("iothub-sequencenumber");
        reservedPropertyNames.add("iothub-operation");
        reservedPropertyNames.add("iothub-partition-key");
        reservedPropertyNames.add("iothub-ack");
        reservedPropertyNames.add(CONNECTION_DEVICE_ID);
        reservedPropertyNames.add("iothub-connection-auth-method");
        reservedPropertyNames.add("iothub-connection-auth-generation-id");
        reservedPropertyNames.add("iothub-messageid");
        reservedPropertyNames.add("iothub-correlationid");
        reservedPropertyNames.add("iothub-userid");
        reservedPropertyNames.add("iothub-to");
        reservedPropertyNames.add("iothub-content-type");
        reservedPropertyNames.add(IOTHUB_CONTENT_TYPE);
        reservedPropertyNames.add("iothub-content-encoding");
        reservedPropertyNames.add(IOTHUB_CONTENT_ENCODING);
        reservedPropertyNames.add("iothub-absolute-expiry-time");
        reservedPropertyNames.add("IoThub-methodname");
        reservedPropertyNames.add("connectionDeviceId");
        reservedPropertyNames.add("connectionModuleId");
        reservedPropertyNames.add(OUTPUT_NAME_PROPERTY);
        reservedPropertyNames.add("iothub-inputname");
        reservedPropertyNames.add(CONNECTION_DEVICE_ID);
        reservedPropertyNames.add(CONNECTION_MODULE_ID);
        RESERVED_PROPERTY_NAMES = Collections.unmodifiableSet(reservedPropertyNames);
    }
}

