/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethodCallback;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.PropertyCallBack;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.TwinPropertyCallBack;
import com.microsoft.azure.sdk.iot.device.InternalClient;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.edge.HttpsHsmTrustBundleProvider;
import com.microsoft.azure.sdk.iot.device.edge.MethodRequest;
import com.microsoft.azure.sdk.iot.device.edge.MethodResult;
import com.microsoft.azure.sdk.iot.device.exceptions.ModuleClientException;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.hsm.HsmException;
import com.microsoft.azure.sdk.iot.device.hsm.HttpHsmSignatureProvider;
import com.microsoft.azure.sdk.iot.device.hsm.IotHubSasTokenHsmAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsTransportManager;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;

public class ModuleClient
extends InternalClient {
    private static final String DEFAULT_API_VERSION = "2018-06-28";
    private static long SEND_PERIOD_MILLIS = 10L;
    private static long RECEIVE_PERIOD_MILLIS_AMQPS = 10L;
    private static long RECEIVE_PERIOD_MILLIS_MQTT = 10L;
    private static long RECEIVE_PERIOD_MILLIS_HTTPS = 1500000L;
    private static int DEFAULT_SAS_TOKEN_TIME_TO_LIVE_SECONDS = 3600;
    private static int DEFAULT_SAS_TOKEN_BUFFER_PERCENTAGE = 85;
    private static final String IotEdgedUriVariableName = "IOTEDGE_WORKLOADURI";
    private static final String IotHubHostnameVariableName = "IOTEDGE_IOTHUBHOSTNAME";
    private static final String GatewayHostnameVariableName = "IOTEDGE_GATEWAYHOSTNAME";
    private static final String DeviceIdVariableName = "IOTEDGE_DEVICEID";
    private static final String ModuleIdVariableName = "IOTEDGE_MODULEID";
    private static final String ModuleGenerationIdVariableName = "IOTEDGE_MODULEGENERATIONID";
    private static final String AuthSchemeVariableName = "IOTEDGE_AUTHSCHEME";
    private static final String SasTokenAuthScheme = "sasToken";
    private static final String EdgehubConnectionstringVariableName = "EdgeHubConnectionString";
    private static final String IothubConnectionstringVariableName = "IotHubConnectionString";
    private static final String EdgeCaCertificateFileVariableName = "EdgeModuleCACertificateFile";

    public ModuleClient(String connectionString, IotHubClientProtocol protocol) throws ModuleClientException, IllegalArgumentException, UnsupportedOperationException, URISyntaxException {
        super(new IotHubConnectionString(connectionString), protocol, SEND_PERIOD_MILLIS, ModuleClient.getReceivePeriod(protocol));
        ModuleClient.commonConstructorVerifications(protocol, this.config);
    }

    public ModuleClient(String connectionString, IotHubClientProtocol protocol, String publicKeyCertificate, boolean isCertificatePath, String privateKey, boolean isPrivateKeyPath) throws ModuleClientException, URISyntaxException {
        super(new IotHubConnectionString(connectionString), protocol, publicKeyCertificate, isCertificatePath, privateKey, isPrivateKeyPath, SEND_PERIOD_MILLIS, ModuleClient.getReceivePeriod(protocol));
        ModuleClient.commonConstructorVerifications(protocol, this.getConfig());
    }

    public static ModuleClient createFromEnvironment() throws ModuleClientException {
        return ModuleClient.createFromEnvironment(IotHubClientProtocol.AMQPS);
    }

    public static ModuleClient createFromEnvironment(IotHubClientProtocol protocol) throws ModuleClientException {
        HttpHsmSignatureProvider signatureProvider;
        Map<String, String> envVariables = System.getenv();
        String connectionString = envVariables.get(EdgehubConnectionstringVariableName);
        if (connectionString == null) {
            connectionString = envVariables.get(IothubConnectionstringVariableName);
        }
        if (connectionString != null) {
            ModuleClient moduleClient = null;
            try {
                moduleClient = new ModuleClient(connectionString, protocol);
            }
            catch (URISyntaxException e) {
                throw new ModuleClientException("Could not create module client", e);
            }
            String alternativeDefaultTrustedCert = envVariables.get(EdgeCaCertificateFileVariableName);
            if (alternativeDefaultTrustedCert != null && !alternativeDefaultTrustedCert.isEmpty()) {
                moduleClient.setOption_SetCertificatePath(alternativeDefaultTrustedCert);
            }
            return moduleClient;
        }
        String edgedUri = envVariables.get(IotEdgedUriVariableName);
        String deviceId = envVariables.get(DeviceIdVariableName);
        String moduleId = envVariables.get(ModuleIdVariableName);
        String hostname = envVariables.get(IotHubHostnameVariableName);
        String authScheme = envVariables.get(AuthSchemeVariableName);
        String gatewayHostname = envVariables.get(GatewayHostnameVariableName);
        String generationId = envVariables.get(ModuleGenerationIdVariableName);
        if (edgedUri == null) {
            throw new ModuleClientException("Environment variable IOTEDGE_WORKLOADURI is required.");
        }
        if (deviceId == null) {
            throw new ModuleClientException("Environment variable IOTEDGE_DEVICEID is required.");
        }
        if (moduleId == null) {
            throw new ModuleClientException("Environment variable IOTEDGE_MODULEID is required.");
        }
        if (hostname == null) {
            throw new ModuleClientException("Environment variable IOTEDGE_IOTHUBHOSTNAME is required.");
        }
        if (authScheme == null) {
            throw new ModuleClientException("Environment variable IOTEDGE_AUTHSCHEME is required.");
        }
        if (generationId == null) {
            throw new ModuleClientException("Environment variable IOTEDGE_MODULEGENERATIONID is required");
        }
        if (!authScheme.equalsIgnoreCase(SasTokenAuthScheme)) {
            throw new ModuleClientException("Unsupported authentication scheme. Supported scheme is sasToken.");
        }
        try {
            signatureProvider = new HttpHsmSignatureProvider(edgedUri, DEFAULT_API_VERSION);
        }
        catch (URISyntaxException | NoSuchAlgorithmException e) {
            throw new ModuleClientException("Could not use Hsm Signature Provider", e);
        }
        try {
            IotHubSasTokenHsmAuthenticationProvider iotHubAuthenticationProvider = IotHubSasTokenHsmAuthenticationProvider.create(signatureProvider, deviceId, moduleId, hostname, gatewayHostname, generationId, DEFAULT_SAS_TOKEN_TIME_TO_LIVE_SECONDS, DEFAULT_SAS_TOKEN_BUFFER_PERCENTAGE);
            ModuleClient moduleClient = new ModuleClient(iotHubAuthenticationProvider, protocol, SEND_PERIOD_MILLIS, ModuleClient.getReceivePeriod(protocol));
            if (gatewayHostname != null && !gatewayHostname.isEmpty()) {
                HttpsHsmTrustBundleProvider trustBundleProvider = new HttpsHsmTrustBundleProvider();
                String trustCertificates = trustBundleProvider.getTrustBundleCerts(edgedUri, DEFAULT_API_VERSION);
                moduleClient.setTrustedCertificates(trustCertificates);
            }
            return moduleClient;
        }
        catch (TransportException | HsmException | IOException | URISyntaxException e) {
            throw new ModuleClientException(e);
        }
    }

    private ModuleClient(IotHubAuthenticationProvider iotHubAuthenticationProvider, IotHubClientProtocol protocol, long sendPeriodMillis, long receivePeriodMillis) throws IOException, TransportException {
        super(iotHubAuthenticationProvider, protocol, sendPeriodMillis, receivePeriodMillis);
    }

    public void sendEventAsync(Message message, IotHubEventCallback callback, Object callbackContext, String outputName) throws IllegalArgumentException {
        if (outputName == null || outputName.isEmpty()) {
            throw new IllegalArgumentException("outputName cannot be null or empty");
        }
        message.setOutputName(outputName);
        this.sendEventAsync(message, callback, callbackContext);
    }

    @Override
    public void sendEventAsync(Message message, IotHubEventCallback callback, Object callbackContext) throws IllegalArgumentException {
        message.setConnectionModuleId(this.config.getModuleId());
        super.sendEventAsync(message, callback, callbackContext);
    }

    public MethodResult invokeMethod(String deviceId, MethodRequest methodRequest) throws ModuleClientException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null or empty");
        }
        try {
            HttpsTransportManager httpsTransportManager = new HttpsTransportManager(this.config);
            httpsTransportManager.open();
            return httpsTransportManager.invokeMethod(methodRequest, deviceId, "");
        }
        catch (TransportException | IOException | URISyntaxException e) {
            throw new ModuleClientException("Could not invoke method", e);
        }
    }

    public MethodResult invokeMethod(String deviceId, String moduleId, MethodRequest methodRequest) throws ModuleClientException, IllegalArgumentException {
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null or empty");
        }
        if (moduleId == null || moduleId.isEmpty()) {
            throw new IllegalArgumentException("DeviceId cannot be null or empty");
        }
        try {
            HttpsTransportManager httpsTransportManager = new HttpsTransportManager(this.config);
            httpsTransportManager.open();
            return httpsTransportManager.invokeMethod(methodRequest, deviceId, moduleId);
        }
        catch (TransportException | IOException | URISyntaxException e) {
            throw new ModuleClientException("Could not invoke method", e);
        }
    }

    public void getTwin() throws IOException {
        this.getTwinInternal();
    }

    public void startTwin(IotHubEventCallback deviceTwinStatusCallback, Object deviceTwinStatusCallbackContext, PropertyCallBack genericPropertyCallBack, Object genericPropertyCallBackContext) throws IOException, IllegalArgumentException, UnsupportedOperationException {
        this.startTwinInternal(deviceTwinStatusCallback, deviceTwinStatusCallbackContext, genericPropertyCallBack, genericPropertyCallBackContext);
    }

    public void startTwin(IotHubEventCallback deviceTwinStatusCallback, Object deviceTwinStatusCallbackContext, TwinPropertyCallBack genericPropertyCallBack, Object genericPropertyCallBackContext) throws IOException, IllegalArgumentException, UnsupportedOperationException {
        this.startTwinInternal(deviceTwinStatusCallback, deviceTwinStatusCallbackContext, genericPropertyCallBack, genericPropertyCallBackContext);
    }

    public void subscribeToMethod(DeviceMethodCallback methodCallback, Object methodCallbackContext, IotHubEventCallback methodStatusCallback, Object methodStatusCallbackContext) throws IOException, IllegalArgumentException {
        this.subscribeToMethodsInternal(methodCallback, methodCallbackContext, methodStatusCallback, methodStatusCallbackContext);
    }

    public ModuleClient setMessageCallback(MessageCallback callback, Object context) {
        this.setMessageCallbackInternal(callback, context);
        return this;
    }

    public ModuleClient setMessageCallback(String inputName, MessageCallback callback, Object context) {
        if (inputName == null || inputName.isEmpty()) {
            throw new IllegalArgumentException("InputName must not be null or empty");
        }
        if (callback == null && context != null) {
            throw new IllegalArgumentException("Cannot give non-null context for a null callback.");
        }
        this.config.setMessageCallback(inputName, callback, context);
        return this;
    }

    private static long getReceivePeriod(IotHubClientProtocol protocol) {
        switch (protocol) {
            case HTTPS: {
                return RECEIVE_PERIOD_MILLIS_HTTPS;
            }
            case AMQPS: 
            case AMQPS_WS: {
                return RECEIVE_PERIOD_MILLIS_AMQPS;
            }
            case MQTT: 
            case MQTT_WS: {
                return RECEIVE_PERIOD_MILLIS_MQTT;
            }
        }
        throw new IllegalStateException("Invalid client protocol specified.");
    }

    private static void commonConstructorVerifications(IotHubClientProtocol protocol, DeviceClientConfig config) {
        if (protocol != IotHubClientProtocol.MQTT && protocol != IotHubClientProtocol.AMQPS && protocol != IotHubClientProtocol.MQTT_WS && protocol != IotHubClientProtocol.AMQPS_WS) {
            throw new UnsupportedOperationException("Only MQTT, MQTT_WS, AMQPS and AMQPS_WS are supported for ModuleClient.");
        }
        if (config.getModuleId() == null || config.getModuleId().isEmpty()) {
            throw new IllegalArgumentException("Connection string must contain field for ModuleId");
        }
    }
}

