/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.hsm;

import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.hsm.HsmException;
import com.microsoft.azure.sdk.iot.device.hsm.HttpsRequestResponseSerializer;
import com.microsoft.azure.sdk.iot.device.hsm.parser.ErrorResponse;
import com.microsoft.azure.sdk.iot.device.hsm.parser.SignRequest;
import com.microsoft.azure.sdk.iot.device.hsm.parser.SignResponse;
import com.microsoft.azure.sdk.iot.device.hsm.parser.TrustBundleResponse;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsMethod;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsRequest;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class HttpsHsmClient {
    private String baseUrl;
    private String scheme;
    private static final String HTTPS_SCHEME = "https";
    private static final String HTTP_SCHEME = "http";
    private static final String UNIX_SCHEME = "unix";
    private static final String API_VERSION_QUERY_STRING_PREFIX = "api-version=";

    public HttpsHsmClient(String baseUrl) throws URISyntaxException {
        this.baseUrl = baseUrl;
        URI uri = new URI(baseUrl);
        this.scheme = uri.getScheme();
        if (this.scheme.equalsIgnoreCase(UNIX_SCHEME)) {
            URLStreamHandlerFactory fac = new URLStreamHandlerFactory(){

                @Override
                public URLStreamHandler createURLStreamHandler(String protocol) {
                    if (protocol.equalsIgnoreCase(HttpsHsmClient.UNIX_SCHEME)) {
                        return new URLStreamHandler(){

                            @Override
                            protected URLConnection openConnection(URL u) {
                                throw new UnsupportedOperationException("Cannot use URL class to open a unix connection");
                            }
                        };
                    }
                    return null;
                }
            };
            try {
                URL.setURLStreamHandlerFactory(fac);
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }

    public SignResponse sign(String apiVersion, String moduleName, SignRequest signRequest, String generationId) throws IOException, TransportException, HsmException {
        String uri = this.baseUrl != null ? this.baseUrl.replaceFirst("/*$", "") : "";
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append("/modules/" + URLEncoder.encode(moduleName, "UTF-8"));
        pathBuilder.append("/genid/" + URLEncoder.encode(generationId, "UTF-8"));
        pathBuilder.append("/sign");
        byte[] body = signRequest.toJson().getBytes();
        HttpsResponse response = this.sendRequestBasedOnScheme(HttpsMethod.POST, body, uri, pathBuilder.toString(), API_VERSION_QUERY_STRING_PREFIX + apiVersion);
        int responseCode = response.getStatus();
        String responseBody = new String(response.getBody());
        if (responseCode >= 200 && responseCode < 300) {
            return SignResponse.fromJson(responseBody);
        }
        String exceptionMessage = "HttpsHsmClient received status code " + responseCode + " from provided uri.";
        ErrorResponse errorResponse = ErrorResponse.fromJson(responseBody);
        if (errorResponse != null) {
            exceptionMessage = exceptionMessage + " Error response message: " + errorResponse.getMessage();
        }
        throw new HsmException(exceptionMessage);
    }

    public TrustBundleResponse getTrustBundle(String apiVersion) throws IOException, TransportException, HsmException {
        String body;
        if (apiVersion == null || apiVersion.isEmpty()) {
            throw new IllegalArgumentException("api version cannot be null or empty");
        }
        String uri = this.baseUrl != null ? this.baseUrl.replaceFirst("/*$", "") : "";
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append("/trust-bundle");
        HttpsResponse response = this.sendRequestBasedOnScheme(HttpsMethod.GET, new byte[0], uri, pathBuilder.toString(), API_VERSION_QUERY_STRING_PREFIX + apiVersion);
        int statusCode = response.getStatus();
        String string = body = response.getBody() != null ? new String(response.getBody()) : "";
        if (statusCode >= 200 && statusCode < 300) {
            return TrustBundleResponse.fromJson(body);
        }
        ErrorResponse errorResponse = ErrorResponse.fromJson(body);
        if (errorResponse != null) {
            throw new HsmException("Received error from hsm with status code " + statusCode + " and message " + errorResponse.getMessage());
        }
        throw new HsmException("Received error from hsm with status code " + statusCode);
    }

    private HttpsResponse sendRequestBasedOnScheme(HttpsMethod httpsMethod, byte[] body, String baseUri, String path, String queryString) throws TransportException, IOException {
        HttpsResponse response;
        URL requestUrl = queryString != null && !queryString.isEmpty() ? new URL(baseUri + path + "?" + queryString) : new URL(baseUri + path);
        HttpsRequest httpsRequest = new HttpsRequest(requestUrl, httpsMethod, body, "");
        httpsRequest.setHeaderField("Accept", "application/json");
        if (body.length > 0) {
            httpsRequest.setHeaderField("Content-Type", "application/json");
        }
        if (this.scheme.equalsIgnoreCase(HTTPS_SCHEME) || this.scheme.equalsIgnoreCase(HTTP_SCHEME)) {
            response = httpsRequest.send();
        } else if (this.scheme.equalsIgnoreCase(UNIX_SCHEME)) {
            String unixAddressPrefix = "unix://";
            String localUnixSocketPath = baseUri.substring(baseUri.indexOf(unixAddressPrefix) + unixAddressPrefix.length());
            response = this.sendHttpRequestUsingUnixSocket(httpsRequest, path, queryString, localUnixSocketPath);
        } else {
            throw new UnsupportedOperationException("unrecognized URI scheme. Only HTTPS, HTTP and UNIX are supported");
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpsResponse sendHttpRequestUsingUnixSocket(HttpsRequest httpsRequest, String httpRequestPath, String httpRequestQueryString, String unixSocketAddress) throws IOException {
        HttpsResponse response = null;
        try (UnixSocketChannel channel = null;){
            byte[] requestBytes = HttpsRequestResponseSerializer.serializeRequest(httpsRequest, httpRequestPath, httpRequestQueryString, unixSocketAddress);
            UnixSocketAddress address = new UnixSocketAddress(unixSocketAddress);
            channel = UnixSocketChannel.open((UnixSocketAddress)address);
            channel.write(ByteBuffer.wrap(requestBytes));
            if (httpsRequest.getBody() != null) {
                channel.write(ByteBuffer.wrap(httpsRequest.getBody()));
            }
            String responseString = this.readResponseFromChannel(channel);
            response = HttpsRequestResponseSerializer.deserializeResponse(new BufferedReader(new StringReader(responseString)));
        }
        return response;
    }

    private String readResponseFromChannel(UnixSocketChannel channel) throws IOException {
        ByteBuffer buf = ByteBuffer.allocateDirect(10);
        String response = "";
        int numRead = 0;
        while (numRead >= 0) {
            buf.rewind();
            numRead = channel.read(buf);
            buf.rewind();
            for (int i = 0; i < numRead; ++i) {
                response = response + new String(new byte[]{buf.get()}, StandardCharsets.US_ASCII);
            }
        }
        return response;
    }
}

